/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mariadb.jdbc.client.context;

import com.vecoo.extralib.shade.mariadb.jdbc.Configuration;
import com.vecoo.extralib.shade.mariadb.jdbc.HostAddress;
import com.vecoo.extralib.shade.mariadb.jdbc.client.PrepareCache;
import com.vecoo.extralib.shade.mariadb.jdbc.client.context.BaseContext;
import com.vecoo.extralib.shade.mariadb.jdbc.client.impl.TransactionSaver;
import com.vecoo.extralib.shade.mariadb.jdbc.export.ExceptionFactory;
import com.vecoo.extralib.shade.mariadb.jdbc.message.ClientMessage;
import com.vecoo.extralib.shade.mariadb.jdbc.message.client.RedoableClientMessage;
import com.vecoo.extralib.shade.mariadb.jdbc.message.server.InitialHandshakePacket;

public class RedoContext
extends BaseContext {
    private final TransactionSaver transactionSaver;

    public RedoContext(HostAddress hostAddress, InitialHandshakePacket handshake, long clientCapabilities, Configuration conf, ExceptionFactory exceptionFactory, PrepareCache prepareCache, Boolean loopbackAddress) {
        super(hostAddress, handshake, clientCapabilities, conf, exceptionFactory, prepareCache, loopbackAddress);
        this.transactionSaver = new TransactionSaver(conf.transactionReplaySize());
    }

    @Override
    public void setServerStatus(int serverStatus) {
        this.serverStatus = serverStatus;
        if ((serverStatus & 1) == 0) {
            this.transactionSaver.clear();
        }
    }

    public void saveRedo(ClientMessage msg) {
        if (msg instanceof RedoableClientMessage) {
            RedoableClientMessage redoMsg = (RedoableClientMessage)msg;
            redoMsg.saveParameters();
            this.transactionSaver.add(redoMsg);
        }
    }

    public void saveRedo(ClientMessage[] msgs) {
        for (ClientMessage msg : msgs) {
            this.saveRedo(msg);
        }
    }

    public TransactionSaver getTransactionSaver() {
        return this.transactionSaver;
    }
}

