/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.item;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.vecoo.extralib.ExtraLib;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomModelData;
import org.jetbrains.annotations.NotNull;

public class UtilItem {
    @NotNull
    public static ItemStack parseItem(@NotNull String itemId) {
        Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemId));
        if (item == Items.AIR) {
            return ItemStack.EMPTY;
        }
        return item.getDefaultInstance();
    }

    @NotNull
    public static ItemStack parseItemCustomModel(@NotNull String itemId) {
        String[] parts = itemId.split(":");
        ItemStack itemStack = UtilItem.parseItem(parts[0] + ":" + parts[1]);
        if (itemStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (parts.length == 3) {
            try {
                itemStack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(Integer.parseInt(parts[2])));
            }
            catch (NumberFormatException e) {
                ExtraLib.getLogger().error("Invalid CustomModelData value in item: " + itemId);
            }
        }
        return itemStack;
    }

    @NotNull
    public static JsonElement serialize(@NotNull ItemStack itemStack, @NotNull MinecraftServer server) {
        return (JsonElement)ItemStack.CODEC.encodeStart((DynamicOps)server.registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)itemStack).getOrThrow();
    }

    @NotNull
    public static ItemStack deserialize(@NotNull JsonElement jsonElement, @NotNull MinecraftServer server) {
        return (ItemStack)((Pair)ItemStack.CODEC.decode((DynamicOps)server.registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)jsonElement).getOrThrow()).getFirst();
    }
}

