/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mariadb.jdbc.client.socket.impl;

import com.vecoo.extralib.shade.mariadb.jdbc.HostAddress;
import com.vecoo.extralib.shade.mariadb.jdbc.client.socket.Writer;
import com.vecoo.extralib.shade.mariadb.jdbc.client.util.MutableByte;
import com.vecoo.extralib.shade.mariadb.jdbc.export.MaxAllowedPacketException;
import com.vecoo.extralib.shade.mariadb.jdbc.util.log.Logger;
import com.vecoo.extralib.shade.mariadb.jdbc.util.log.LoggerHelper;
import com.vecoo.extralib.shade.mariadb.jdbc.util.log.Loggers;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class PacketWriter
implements Writer {
    public static final int SMALL_BUFFER_SIZE = 8192;
    private static final Logger logger = Loggers.getLogger(PacketWriter.class);
    private static final byte QUOTE = 39;
    private static final byte DBL_QUOTE = 34;
    private static final byte ZERO_BYTE = 0;
    private static final byte BACKSLASH = 92;
    private static final int MEDIUM_BUFFER_SIZE = 131072;
    private static final int LARGE_BUFFER_SIZE = 0x100000;
    private static final int MAX_PACKET_LENGTH = 0x1000003;
    protected final MutableByte sequence;
    protected final MutableByte compressSequence;
    private final int maxQuerySizeToLog;
    private final OutputStream out;
    private final int maxPacketLength = 0x1000003;
    private final Integer maxAllowedPacket;
    protected byte[] buf;
    protected int pos = 4;
    private long cmdLength;
    private boolean permitTrace = true;
    private String serverThreadLog = "";
    private int mark = -1;
    private boolean bufContainDataAfterMark = false;

    public PacketWriter(OutputStream out, int maxQuerySizeToLog, Integer maxAllowedPacket, MutableByte sequence, MutableByte compressSequence) {
        this.out = out;
        this.buf = new byte[8192];
        this.maxQuerySizeToLog = maxQuerySizeToLog;
        this.cmdLength = 0L;
        this.sequence = sequence;
        this.compressSequence = compressSequence;
        this.maxAllowedPacket = maxAllowedPacket;
    }

    @Override
    public int pos() {
        return this.pos;
    }

    @Override
    public void pos(int pos) throws IOException {
        if (pos > this.buf.length) {
            this.growBuffer(pos);
        }
        this.pos = pos;
    }

    @Override
    public long getCmdLength() {
        return this.cmdLength;
    }

    @Override
    public void writeByte(int value) throws IOException {
        if (this.pos >= this.buf.length) {
            if (this.pos >= 0x1000003 && !this.bufContainDataAfterMark) {
                this.writeSocket(false);
            } else {
                this.growBuffer(1);
            }
        }
        this.buf[this.pos++] = (byte)value;
    }

    @Override
    public void writeShort(short value) throws IOException {
        if (2 > this.buf.length - this.pos) {
            this.writeBytes(new byte[]{(byte)value, (byte)(value >> 8)}, 0, 2);
            return;
        }
        this.buf[this.pos] = (byte)value;
        this.buf[this.pos + 1] = (byte)(value >> 8);
        this.pos += 2;
    }

    @Override
    public void writeInt(int value) throws IOException {
        if (4 > this.buf.length - this.pos) {
            byte[] arr = new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24)};
            this.writeBytes(arr, 0, 4);
            return;
        }
        this.buf[this.pos] = (byte)value;
        this.buf[this.pos + 1] = (byte)(value >> 8);
        this.buf[this.pos + 2] = (byte)(value >> 16);
        this.buf[this.pos + 3] = (byte)(value >> 24);
        this.pos += 4;
    }

    @Override
    public void writeLong(long value) throws IOException {
        if (8 > this.buf.length - this.pos) {
            byte[] arr = new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24), (byte)(value >> 32), (byte)(value >> 40), (byte)(value >> 48), (byte)(value >> 56)};
            this.writeBytes(arr, 0, 8);
            return;
        }
        this.buf[this.pos] = (byte)value;
        this.buf[this.pos + 1] = (byte)(value >> 8);
        this.buf[this.pos + 2] = (byte)(value >> 16);
        this.buf[this.pos + 3] = (byte)(value >> 24);
        this.buf[this.pos + 4] = (byte)(value >> 32);
        this.buf[this.pos + 5] = (byte)(value >> 40);
        this.buf[this.pos + 6] = (byte)(value >> 48);
        this.buf[this.pos + 7] = (byte)(value >> 56);
        this.pos += 8;
    }

    @Override
    public void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    @Override
    public void writeFloat(float value) throws IOException {
        this.writeInt(Float.floatToIntBits(value));
    }

    @Override
    public void writeBytes(byte[] arr) throws IOException {
        this.writeBytes(arr, 0, arr.length);
    }

    @Override
    public void writeBytesAtPos(byte[] arr, int pos) {
        System.arraycopy(arr, 0, this.buf, pos, arr.length);
    }

    @Override
    public void writeBytes(byte[] arr, int off, int len) throws IOException {
        if (len > this.buf.length - this.pos) {
            if (this.buf.length != 0x1000003) {
                this.growBuffer(len);
            }
            if (len > this.buf.length - this.pos) {
                if (this.mark != -1) {
                    this.growBuffer(len);
                    if (this.mark != -1) {
                        this.flushBufferStopAtMark();
                    }
                }
                if (len > this.buf.length - this.pos) {
                    int remainingLen = len;
                    while (true) {
                        int lenToFillbuf = Math.min(0x1000003 - this.pos, remainingLen);
                        System.arraycopy(arr, off, this.buf, this.pos, lenToFillbuf);
                        off += lenToFillbuf;
                        this.pos += lenToFillbuf;
                        if ((remainingLen -= lenToFillbuf) <= 0) break;
                        this.writeSocket(false);
                    }
                    return;
                }
            }
        }
        System.arraycopy(arr, off, this.buf, this.pos, len);
        this.pos += len;
    }

    @Override
    public void writeLength(long length) throws IOException {
        if (length < 251L) {
            this.writeByte((byte)length);
            return;
        }
        if (length < 65536L) {
            if (3 > this.buf.length - this.pos) {
                byte[] arr = new byte[]{-4, (byte)length, (byte)(length >>> 8)};
                this.writeBytes(arr, 0, 3);
                return;
            }
            this.buf[this.pos] = -4;
            this.buf[this.pos + 1] = (byte)length;
            this.buf[this.pos + 2] = (byte)(length >>> 8);
            this.pos += 3;
            return;
        }
        if (length < 0x1000000L) {
            if (4 > this.buf.length - this.pos) {
                byte[] arr = new byte[]{-3, (byte)length, (byte)(length >>> 8), (byte)(length >>> 16)};
                this.writeBytes(arr, 0, 4);
                return;
            }
            this.buf[this.pos] = -3;
            this.buf[this.pos + 1] = (byte)length;
            this.buf[this.pos + 2] = (byte)(length >>> 8);
            this.buf[this.pos + 3] = (byte)(length >>> 16);
            this.pos += 4;
            return;
        }
        if (9 > this.buf.length - this.pos) {
            byte[] arr = new byte[]{-2, (byte)length, (byte)(length >>> 8), (byte)(length >>> 16), (byte)(length >>> 24), (byte)(length >>> 32), (byte)(length >>> 40), (byte)(length >>> 48), (byte)(length >>> 56)};
            this.writeBytes(arr, 0, 9);
            return;
        }
        this.buf[this.pos] = -2;
        this.buf[this.pos + 1] = (byte)length;
        this.buf[this.pos + 2] = (byte)(length >>> 8);
        this.buf[this.pos + 3] = (byte)(length >>> 16);
        this.buf[this.pos + 4] = (byte)(length >>> 24);
        this.buf[this.pos + 5] = (byte)(length >>> 32);
        this.buf[this.pos + 6] = (byte)(length >>> 40);
        this.buf[this.pos + 7] = (byte)(length >>> 48);
        this.buf[this.pos + 8] = (byte)(length >>> 56);
        this.pos += 9;
    }

    @Override
    public void writeAscii(String str) throws IOException {
        int len = str.length();
        if (len > this.buf.length - this.pos) {
            byte[] arr = str.getBytes(StandardCharsets.US_ASCII);
            this.writeBytes(arr, 0, arr.length);
            return;
        }
        int off = 0;
        while (off < len) {
            this.buf[this.pos++] = (byte)str.charAt(off++);
        }
    }

    @Override
    public void writeString(String str) throws IOException {
        char currChar;
        int charsOffset;
        int charsLength = str.length();
        if (charsLength * 3 >= this.buf.length - this.pos) {
            byte[] arr = str.getBytes(StandardCharsets.UTF_8);
            this.writeBytes(arr, 0, arr.length);
            return;
        }
        for (charsOffset = 0; charsOffset < charsLength && (currChar = str.charAt(charsOffset)) < '\u0080'; ++charsOffset) {
            this.buf[this.pos++] = (byte)currChar;
        }
        while (charsOffset < charsLength) {
            if ((currChar = str.charAt(charsOffset++)) < '\u0080') {
                this.buf[this.pos++] = (byte)currChar;
                continue;
            }
            if (currChar < '\u0800') {
                this.buf[this.pos++] = (byte)(0xC0 | currChar >> 6);
                this.buf[this.pos++] = (byte)(0x80 | currChar & 0x3F);
                continue;
            }
            if (currChar >= '\ud800' && currChar < '\ue000') {
                if (currChar < '\udc00') {
                    if (charsOffset + 1 > charsLength) {
                        this.buf[this.pos++] = 99;
                        continue;
                    }
                    char nextChar = str.charAt(charsOffset);
                    if (nextChar >= '\udc00' && nextChar < '\ue000') {
                        int surrogatePairs = (currChar << 10) + nextChar + -56613888;
                        this.buf[this.pos++] = (byte)(0xF0 | surrogatePairs >> 18);
                        this.buf[this.pos++] = (byte)(0x80 | surrogatePairs >> 12 & 0x3F);
                        this.buf[this.pos++] = (byte)(0x80 | surrogatePairs >> 6 & 0x3F);
                        this.buf[this.pos++] = (byte)(0x80 | surrogatePairs & 0x3F);
                        ++charsOffset;
                        continue;
                    }
                    this.buf[this.pos++] = 63;
                    continue;
                }
                this.buf[this.pos++] = 63;
                continue;
            }
            this.buf[this.pos++] = (byte)(0xE0 | currChar >> 12);
            this.buf[this.pos++] = (byte)(0x80 | currChar >> 6 & 0x3F);
            this.buf[this.pos++] = (byte)(0x80 | currChar & 0x3F);
        }
    }

    @Override
    public byte[] buf() {
        return this.buf;
    }

    @Override
    public void writeStringEscaped(String str, boolean noBackslashEscapes) throws IOException {
        char currChar;
        int charsOffset;
        int charsLength = str.length();
        if (charsLength * 3 >= this.buf.length - this.pos) {
            byte[] arr = str.getBytes(StandardCharsets.UTF_8);
            this.writeBytesEscaped(arr, arr.length, noBackslashEscapes);
            return;
        }
        if (noBackslashEscapes) {
            for (charsOffset = 0; charsOffset < charsLength && (currChar = str.charAt(charsOffset)) < '\u0080'; ++charsOffset) {
                if (currChar == '\'') {
                    this.buf[this.pos++] = 39;
                }
                this.buf[this.pos++] = (byte)currChar;
            }
        } else {
            while (charsOffset < charsLength && (currChar = str.charAt(charsOffset)) < '\u0080') {
                if (currChar == '\\' || currChar == '\'' || currChar == '\u0000' || currChar == '\"') {
                    this.buf[this.pos++] = 92;
                }
                this.buf[this.pos++] = (byte)currChar;
                ++charsOffset;
            }
        }
        while (charsOffset < charsLength) {
            if ((currChar = str.charAt(charsOffset++)) < '\u0080') {
                if (noBackslashEscapes) {
                    if (currChar == '\'') {
                        this.buf[this.pos++] = 39;
                    }
                } else if (currChar == '\\' || currChar == '\'' || currChar == '\u0000' || currChar == '\"') {
                    this.buf[this.pos++] = 92;
                }
                this.buf[this.pos++] = (byte)currChar;
                continue;
            }
            if (currChar < '\u0800') {
                this.buf[this.pos++] = (byte)(0xC0 | currChar >> 6);
                this.buf[this.pos++] = (byte)(0x80 | currChar & 0x3F);
                continue;
            }
            if (currChar >= '\ud800' && currChar < '\ue000') {
                if (currChar < '\udc00') {
                    if (charsOffset + 1 > charsLength) {
                        this.buf[this.pos++] = 99;
                        continue;
                    }
                    char nextChar = str.charAt(charsOffset);
                    if (nextChar >= '\udc00' && nextChar < '\ue000') {
                        int surrogatePairs = (currChar << 10) + nextChar + -56613888;
                        this.buf[this.pos++] = (byte)(0xF0 | surrogatePairs >> 18);
                        this.buf[this.pos++] = (byte)(0x80 | surrogatePairs >> 12 & 0x3F);
                        this.buf[this.pos++] = (byte)(0x80 | surrogatePairs >> 6 & 0x3F);
                        this.buf[this.pos++] = (byte)(0x80 | surrogatePairs & 0x3F);
                        ++charsOffset;
                        continue;
                    }
                    this.buf[this.pos++] = 63;
                    continue;
                }
                this.buf[this.pos++] = 63;
                continue;
            }
            this.buf[this.pos++] = (byte)(0xE0 | currChar >> 12);
            this.buf[this.pos++] = (byte)(0x80 | currChar >> 6 & 0x3F);
            this.buf[this.pos++] = (byte)(0x80 | currChar & 0x3F);
        }
    }

    @Override
    public void writeBytesEscaped(byte[] bytes, int len, boolean noBackslashEscapes) throws IOException {
        if (len * 2 > this.buf.length - this.pos) {
            if (this.buf.length != 0x1000003) {
                this.growBuffer(len * 2);
            }
            if (len * 2 > this.buf.length - this.pos) {
                if (this.mark != -1) {
                    this.growBuffer(len * 2);
                    if (this.mark != -1) {
                        this.flushBufferStopAtMark();
                    }
                } else {
                    if (this.buf.length <= this.pos) {
                        this.writeSocket(false);
                    }
                    if (noBackslashEscapes) {
                        for (int i = 0; i < len; ++i) {
                            if (39 == bytes[i]) {
                                this.buf[this.pos++] = 39;
                                if (this.buf.length <= this.pos) {
                                    this.writeSocket(false);
                                }
                            }
                            this.buf[this.pos++] = bytes[i];
                            if (this.buf.length > this.pos) continue;
                            this.writeSocket(false);
                        }
                    } else {
                        for (int i = 0; i < len; ++i) {
                            if (bytes[i] == 39 || bytes[i] == 92 || bytes[i] == 34 || bytes[i] == 0) {
                                this.buf[this.pos++] = 92;
                                if (this.buf.length <= this.pos) {
                                    this.writeSocket(false);
                                }
                            }
                            this.buf[this.pos++] = bytes[i];
                            if (this.buf.length > this.pos) continue;
                            this.writeSocket(false);
                        }
                    }
                    return;
                }
            }
        }
        if (noBackslashEscapes) {
            for (int i = 0; i < len; ++i) {
                if (39 == bytes[i]) {
                    this.buf[this.pos++] = 39;
                }
                this.buf[this.pos++] = bytes[i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (bytes[i] == 39 || bytes[i] == 92 || bytes[i] == 34 || bytes[i] == 0) {
                    this.buf[this.pos++] = 92;
                }
                this.buf[this.pos++] = bytes[i];
            }
        }
    }

    private void growBuffer(int len) throws IOException {
        int bufLength = this.buf.length;
        int newCapacity = bufLength == 8192 ? (len + this.pos <= 131072 ? 131072 : (len + this.pos <= 0x100000 ? 0x100000 : 0x1000003)) : (bufLength == 131072 ? (len + this.pos < 0x100000 ? 0x100000 : 0x1000003) : (this.bufContainDataAfterMark ? Math.max(len + this.pos, 0x1000003) : 0x1000003));
        if (len + this.pos > newCapacity && this.mark != -1) {
            this.flushBufferStopAtMark();
            if (len + this.pos <= bufLength) {
                return;
            }
            this.growBuffer(len);
            return;
        }
        byte[] newBuf = new byte[newCapacity];
        System.arraycopy(this.buf, 0, newBuf, 0, this.pos);
        this.buf = newBuf;
    }

    @Override
    public void writeEmptyPacket() throws IOException {
        this.buf[0] = 0;
        this.buf[1] = 0;
        this.buf[2] = 0;
        this.buf[3] = this.sequence.incrementAndGet();
        this.out.write(this.buf, 0, 4);
        if (logger.isTraceEnabled()) {
            logger.trace("send com : content length=0 {}\n{}", this.serverThreadLog, LoggerHelper.hex(this.buf, 0, 4));
        }
        this.out.flush();
        this.cmdLength = 0L;
    }

    @Override
    public void flush() throws IOException {
        this.writeSocket(true);
        if (this.buf.length > 8192 && this.cmdLength * 2L < (long)this.buf.length) {
            this.buf = new byte[8192];
        }
        this.pos = 4;
        this.cmdLength = 0L;
        this.mark = -1;
    }

    @Override
    public void flushPipeline() throws IOException {
        this.writeSocket(false);
        if (this.buf.length > 8192 && this.cmdLength * 2L < (long)this.buf.length) {
            this.buf = new byte[8192];
        }
        this.pos = 4;
        this.cmdLength = 0L;
        this.mark = -1;
    }

    private void checkMaxAllowedLength(int length) throws MaxAllowedPacketException {
        if (this.maxAllowedPacket != null && this.cmdLength + (long)length >= (long)this.maxAllowedPacket.intValue()) {
            throw new MaxAllowedPacketException("query size (" + (this.cmdLength + (long)length) + ") is >= to max_allowed_packet (" + this.maxAllowedPacket + ")", this.cmdLength != 0L);
        }
    }

    @Override
    public boolean throwMaxAllowedLength(int length) {
        if (this.maxAllowedPacket != null) {
            return this.cmdLength + (long)length >= (long)this.maxAllowedPacket.intValue();
        }
        return false;
    }

    @Override
    public boolean throwMaxAllowedLengthOr16M(int length) {
        if (this.maxAllowedPacket != null) {
            return this.cmdLength + (long)length >= (long)this.maxAllowedPacket.intValue();
        }
        return this.cmdLength + (long)length >= 0x1000000L;
    }

    @Override
    public void permitTrace(boolean permitTrace) {
        this.permitTrace = permitTrace;
    }

    @Override
    public void setServerThreadId(Long serverThreadId, HostAddress hostAddress) {
        Boolean isMaster = hostAddress != null ? hostAddress.primary : null;
        this.serverThreadLog = "conn=" + (serverThreadId == null ? "-1" : serverThreadId) + (isMaster != null ? " (" + (isMaster != false ? "M" : "S") + ")" : "");
    }

    @Override
    public void mark() {
        this.mark = this.pos;
    }

    @Override
    public boolean isMarked() {
        return this.mark != -1;
    }

    @Override
    public boolean hasFlushed() {
        return this.sequence.get() != -1;
    }

    @Override
    public void flushBufferStopAtMark() throws IOException {
        int end = this.pos;
        this.pos = this.mark;
        this.writeSocket(true);
        this.out.flush();
        this.cmdLength = 0L;
        System.arraycopy(this.buf, this.mark, this.buf, this.pos, end - this.mark);
        this.pos += end - this.mark;
        this.mark = -1;
        this.bufContainDataAfterMark = true;
    }

    @Override
    public boolean bufIsDataAfterMark() {
        return this.bufContainDataAfterMark;
    }

    @Override
    public byte[] resetMark() {
        this.pos = this.mark;
        this.mark = -1;
        if (this.bufContainDataAfterMark) {
            byte[] data = Arrays.copyOfRange(this.buf, 4, this.pos);
            this.initPacket();
            this.bufContainDataAfterMark = false;
            return data;
        }
        return null;
    }

    @Override
    public void initPacket() {
        this.sequence.set((byte)-1);
        this.compressSequence.set((byte)-1);
        this.pos = 4;
        this.cmdLength = 0L;
    }

    protected void writeSocket(boolean commandEnd) throws IOException {
        if (this.pos > 4) {
            this.buf[0] = (byte)(this.pos - 4);
            this.buf[1] = (byte)(this.pos - 4 >>> 8);
            this.buf[2] = (byte)(this.pos - 4 >>> 16);
            this.buf[3] = this.sequence.incrementAndGet();
            this.checkMaxAllowedLength(this.pos - 4);
            this.out.write(this.buf, 0, this.pos);
            if (commandEnd) {
                this.out.flush();
            }
            this.cmdLength += (long)(this.pos - 4);
            if (logger.isTraceEnabled()) {
                if (this.permitTrace) {
                    logger.trace("send: {}\n{}", this.serverThreadLog, LoggerHelper.hex(this.buf, 0, this.pos, this.maxQuerySizeToLog));
                } else {
                    logger.trace("send: content length={} {} com=<hidden>", this.pos - 4, this.serverThreadLog);
                }
            }
            if (commandEnd && this.pos == 0x1000003) {
                this.writeEmptyPacket();
            }
            this.pos = 4;
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public byte getSequence() {
        return this.sequence.get();
    }
}

