/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mysql.cj.jdbc;

import com.vecoo.extralib.shade.mysql.cj.BindValue;
import com.vecoo.extralib.shade.mysql.cj.CancelQueryTask;
import com.vecoo.extralib.shade.mysql.cj.Messages;
import com.vecoo.extralib.shade.mysql.cj.NativeSession;
import com.vecoo.extralib.shade.mysql.cj.PreparedQuery;
import com.vecoo.extralib.shade.mysql.cj.QueryBindings;
import com.vecoo.extralib.shade.mysql.cj.QueryInfo;
import com.vecoo.extralib.shade.mysql.cj.ServerPreparedQuery;
import com.vecoo.extralib.shade.mysql.cj.conf.PropertyKey;
import com.vecoo.extralib.shade.mysql.cj.exceptions.CJException;
import com.vecoo.extralib.shade.mysql.cj.exceptions.ExceptionFactory;
import com.vecoo.extralib.shade.mysql.cj.exceptions.ExceptionInterceptor;
import com.vecoo.extralib.shade.mysql.cj.exceptions.WrongArgumentException;
import com.vecoo.extralib.shade.mysql.cj.jdbc.ClientPreparedStatement;
import com.vecoo.extralib.shade.mysql.cj.jdbc.CloseOption;
import com.vecoo.extralib.shade.mysql.cj.jdbc.JdbcConnection;
import com.vecoo.extralib.shade.mysql.cj.jdbc.MysqlParameterMetadata;
import com.vecoo.extralib.shade.mysql.cj.jdbc.exceptions.MySQLStatementCancelledException;
import com.vecoo.extralib.shade.mysql.cj.jdbc.exceptions.MySQLTimeoutException;
import com.vecoo.extralib.shade.mysql.cj.jdbc.exceptions.SQLError;
import com.vecoo.extralib.shade.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import com.vecoo.extralib.shade.mysql.cj.jdbc.result.ResultSetInternalMethods;
import com.vecoo.extralib.shade.mysql.cj.jdbc.result.ResultSetMetaData;
import com.vecoo.extralib.shade.mysql.cj.protocol.ColumnDefinition;
import com.vecoo.extralib.shade.mysql.cj.protocol.Message;
import com.vecoo.extralib.shade.mysql.cj.telemetry.TelemetryAttribute;
import com.vecoo.extralib.shade.mysql.cj.telemetry.TelemetryScope;
import com.vecoo.extralib.shade.mysql.cj.telemetry.TelemetrySpan;
import com.vecoo.extralib.shade.mysql.cj.telemetry.TelemetrySpanName;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;

public class ServerPreparedStatement
extends ClientPreparedStatement {
    private boolean hasOnDuplicateKeyUpdate = false;
    private boolean invalid = false;
    private CJException invalidationException;
    protected boolean isCacheable = false;
    protected boolean isCached = false;

    protected static ServerPreparedStatement getInstance(JdbcConnection conn, String sql, String db, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ServerPreparedStatement(conn, sql, db, resultSetType, resultSetConcurrency);
    }

    protected ServerPreparedStatement(JdbcConnection conn, String sql, String db, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(conn, db);
        this.checkNullOrEmptyQuery(sql);
        String statementComment = this.session.getQueryComment();
        PreparedQuery prepQuery = (PreparedQuery)this.query;
        prepQuery.setOriginalSql(statementComment == null ? sql : "/* " + statementComment + " */ " + sql);
        prepQuery.setQueryInfo(new QueryInfo(prepQuery.getOriginalSql(), this.session, this.charEncoding));
        this.hasOnDuplicateKeyUpdate = prepQuery.getQueryInfo().containsOnDuplicateKeyUpdate();
        try {
            this.serverPrepare(sql);
        }
        catch (CJException | SQLException sqlEx) {
            this.doClose(CloseOption.NO_CACHE);
            throw SQLExceptionsMapping.translateException(sqlEx, this.exceptionInterceptor);
        }
        this.setResultSetType(resultSetType);
        this.setResultSetConcurrency(resultSetConcurrency);
    }

    @Override
    protected void initQuery() {
        this.query = ServerPreparedQuery.getInstance(this.session);
    }

    @Override
    public String toString() {
        try {
            StringBuilder toStringBuf = new StringBuilder();
            toStringBuf.append(this.getClass().getName() + "[");
            toStringBuf.append(((ServerPreparedQuery)this.query).getServerStatementId());
            toStringBuf.append("]: ");
            toStringBuf.append(((PreparedQuery)this.query).asSql());
            return toStringBuf.toString();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void addBatch() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                this.query.addBatch(((PreparedQuery)this.query).getQueryBindings().clone());
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    protected JdbcConnection checkClosed() {
        if (this.invalid) {
            throw this.invalidationException;
        }
        return super.checkClosed();
    }

    @Override
    public void clearParameters() {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((ServerPreparedQuery)this.query).clearParameters(true);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected void setClosed(boolean flag) {
        this.isClosed = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long[] executeBatchSerially(long batchTimeout) throws SQLException {
        Lock connectionLock = this.checkClosed().getConnectionLock();
        connectionLock.lock();
        try {
            long[] lArray;
            JdbcConnection locallyScopedConn = this.connection;
            if (locallyScopedConn.isReadOnly()) {
                throw SQLError.createSQLException(Messages.getString("ServerPreparedStatement.2") + Messages.getString("ServerPreparedStatement.3"), "S1009", this.exceptionInterceptor);
            }
            this.clearWarnings();
            BindValue[] oldBindValues = ((ServerPreparedQuery)this.query).getQueryBindings().getBindValues();
            try {
                long[] updateCounts = null;
                if (this.query.getBatchedArgs() != null) {
                    int nbrCommands = this.query.getBatchedArgs().size();
                    updateCounts = new long[nbrCommands];
                    if (this.retrieveGeneratedKeys) {
                        this.batchedGeneratedKeys = new ArrayList(nbrCommands);
                    }
                    for (int i = 0; i < nbrCommands; ++i) {
                        updateCounts[i] = -3L;
                    }
                    SQLException sqlEx = null;
                    int commandIndex = 0;
                    BindValue[] previousBindValuesForBatch = null;
                    CancelQueryTask timeoutTask = null;
                    try {
                        timeoutTask = this.startQueryTimer(this, batchTimeout);
                        for (commandIndex = 0; commandIndex < nbrCommands; ++commandIndex) {
                            Object arg = this.query.getBatchedArgs().get(commandIndex);
                            try {
                                if (arg instanceof String) {
                                    updateCounts[commandIndex] = this.executeUpdateInternal((String)arg, true, this.retrieveGeneratedKeys);
                                    this.getBatchedGeneratedKeys(this.results.getFirstCharOfQuery() == 'I' && this.containsOnDuplicateKeyInString((String)arg) ? 1 : 0);
                                    continue;
                                }
                                ((PreparedQuery)this.query).setQueryBindings((QueryBindings)arg);
                                BindValue[] parameterBindings = ((QueryBindings)arg).getBindValues();
                                if (previousBindValuesForBatch != null) {
                                    for (int j = 0; j < parameterBindings.length; ++j) {
                                        if (parameterBindings[j].getMysqlType() == previousBindValuesForBatch[j].getMysqlType()) continue;
                                        ((ServerPreparedQuery)this.query).getQueryBindings().getSendTypesToServer().set(true);
                                        break;
                                    }
                                }
                                try {
                                    updateCounts[commandIndex] = this.executeUpdateInternal(false, true);
                                }
                                finally {
                                    previousBindValuesForBatch = parameterBindings;
                                }
                                this.getBatchedGeneratedKeys(this.containsOnDuplicateKeyUpdate() ? 1 : 0);
                                continue;
                            }
                            catch (SQLException ex) {
                                updateCounts[commandIndex] = -3L;
                                if (this.continueBatchOnError && !(ex instanceof MySQLTimeoutException) && !(ex instanceof MySQLStatementCancelledException) && !this.hasDeadlockOrTimeoutRolledBackTx(ex)) {
                                    sqlEx = ex;
                                    continue;
                                }
                                long[] newUpdateCounts = new long[commandIndex];
                                System.arraycopy(updateCounts, 0, newUpdateCounts, 0, commandIndex);
                                throw SQLError.createBatchUpdateException(ex, newUpdateCounts, this.exceptionInterceptor);
                            }
                        }
                    }
                    finally {
                        this.stopQueryTimer(timeoutTask, false, false);
                        this.resetCancelledState();
                    }
                    if (sqlEx != null) {
                        throw SQLError.createBatchUpdateException(sqlEx, updateCounts, this.exceptionInterceptor);
                    }
                }
                lArray = updateCounts != null ? updateCounts : new long[]{};
                ((ServerPreparedQuery)this.query).getQueryBindings().setBindValues(oldBindValues);
                ((ServerPreparedQuery)this.query).getQueryBindings().getSendTypesToServer().set(true);
            }
            catch (Throwable throwable) {
                ((ServerPreparedQuery)this.query).getQueryBindings().setBindValues(oldBindValues);
                ((ServerPreparedQuery)this.query).getQueryBindings().getSendTypesToServer().set(true);
                this.clearBatch();
                throw throwable;
            }
            this.clearBatch();
            return lArray;
        }
        finally {
            connectionLock.unlock();
        }
    }

    private static SQLException appendMessageToException(SQLException sqlEx, String messageToAppend, ExceptionInterceptor interceptor) {
        String sqlState = sqlEx.getSQLState();
        int vendorErrorCode = sqlEx.getErrorCode();
        SQLException sqlExceptionWithNewMessage = SQLError.createSQLException(sqlEx.getMessage() + messageToAppend, sqlState, vendorErrorCode, interceptor);
        sqlExceptionWithNewMessage.setStackTrace(sqlEx.getStackTrace());
        return sqlExceptionWithNewMessage;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected <M extends Message> ResultSetInternalMethods executeInternal(int maxRowsToRetrieve, M sendPacket, boolean createStreamingResultSet, boolean queryIsSelectOnly, ColumnDefinition metadata, boolean isBatch) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BindValue getBinding(int parameterIndex, boolean forLongData) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                int i = this.getCoreParameterIndex(parameterIndex);
                BindValue bindValue = ((ServerPreparedQuery)this.query).getQueryBindings().getBinding(i, forLongData);
                return bindValue;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ColumnDefinition resultFields = ((ServerPreparedQuery)this.query).getResultFields();
                ResultSetMetaData resultSetMetaData = resultFields == null || resultFields.getFields() == null ? null : new ResultSetMetaData(this.session, resultFields.getFields(), this.session.getPropertySet().getBooleanProperty(PropertyKey.useOldAliasMetadataBehavior).getValue(), this.session.getPropertySet().getBooleanProperty(PropertyKey.yearIsDateType).getValue(), this.exceptionInterceptor);
                return resultSetMetaData;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                if (this.parameterMetaData == null) {
                    this.parameterMetaData = new MysqlParameterMetadata(this.session, ((ServerPreparedQuery)this.query).getParameterFields(), ((PreparedQuery)this.query).getParameterCount(), this.exceptionInterceptor);
                }
                MysqlParameterMetadata mysqlParameterMetadata = this.parameterMetaData;
                return mysqlParameterMetadata;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isNull(int paramIndex) {
        throw new IllegalArgumentException(Messages.getString("ServerPreparedStatement.7"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doClose(CloseOption ... options) throws SQLException {
        try {
            block32: {
                JdbcConnection locallyScopedConn = this.connection;
                if (locallyScopedConn == null) {
                    return;
                }
                Lock connectionLock = locallyScopedConn.getConnectionLock();
                connectionLock.lock();
                try {
                    if (this.isClosed) {
                        return;
                    }
                    if (CloseOption.NO_CACHE.notIn(options) && this.isCacheable && this.isPoolable()) {
                        this.clearParameters();
                        this.clearAttributes();
                        this.clearBatch();
                        this.isClosed = true;
                        this.connection.recachePreparedStatement(this);
                        this.isCached = true;
                        this.results = null;
                        this.generatedKeysResults = null;
                        return;
                    }
                    if (this.connection == null) break block32;
                    CJException exceptionDuringClose = null;
                    if (this.isCached) {
                        locallyScopedConn.decachePreparedStatement(this);
                        this.isCached = false;
                    }
                    NativeSession sessionLocalCopy = this.session;
                    String user = this.connection.getUser();
                    super.doClose(options);
                    ((ServerPreparedQuery)this.query).clearParameters(false);
                    if (!locallyScopedConn.isClosed()) {
                        TelemetrySpan span = sessionLocalCopy.getTelemetryHandler().startSpan(TelemetrySpanName.STMT_DEALLOCATE_PREPARED, new Object[0]);
                        try (TelemetryScope scope = span.makeCurrent();){
                            String dbOperation = this.getQueryInfo().getStatementKeyword();
                            span.setAttribute(TelemetryAttribute.DB_NAME, this::getCurrentDatabase);
                            span.setAttribute(TelemetryAttribute.DB_OPERATION, dbOperation);
                            span.setAttribute(TelemetryAttribute.DB_STATEMENT, dbOperation + " (...)");
                            span.setAttribute(TelemetryAttribute.DB_SYSTEM, "mysql");
                            span.setAttribute(TelemetryAttribute.DB_USER, user);
                            span.setAttribute(TelemetryAttribute.THREAD_ID, () -> Thread.currentThread().getId());
                            span.setAttribute(TelemetryAttribute.THREAD_NAME, () -> Thread.currentThread().getName());
                            try {
                                ((NativeSession)locallyScopedConn.getSession()).getProtocol().sendCommand(this.commandBuilder.buildComStmtClose(null, ((ServerPreparedQuery)this.query).getServerStatementId()), true, 0);
                            }
                            catch (CJException sqlEx) {
                                exceptionDuringClose = sqlEx;
                            }
                        }
                        catch (Throwable t2) {
                            span.setError(t2);
                            throw t2;
                        }
                        finally {
                            span.end();
                        }
                    }
                    if (exceptionDuringClose != null) {
                        throw exceptionDuringClose;
                    }
                }
                finally {
                    connectionLock.unlock();
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rePrepare() {
        block31: {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                TelemetrySpan span = this.session.getTelemetryHandler().startSpan(TelemetrySpanName.STMT_PREPARE, new Object[0]);
                try (TelemetryScope scope = span.makeCurrent();){
                    String dbOperation = this.getQueryInfo().getStatementKeyword();
                    span.setAttribute(TelemetryAttribute.DB_NAME, this::getCurrentDatabase);
                    span.setAttribute(TelemetryAttribute.DB_OPERATION, dbOperation);
                    span.setAttribute(TelemetryAttribute.DB_STATEMENT, dbOperation + " (...)");
                    span.setAttribute(TelemetryAttribute.DB_SYSTEM, "mysql");
                    span.setAttribute(TelemetryAttribute.DB_USER, () -> this.connection.getUser());
                    span.setAttribute(TelemetryAttribute.THREAD_ID, () -> Thread.currentThread().getId());
                    span.setAttribute(TelemetryAttribute.THREAD_NAME, () -> Thread.currentThread().getName());
                    this.invalidationException = null;
                    try {
                        this.serverPrepare(((PreparedQuery)this.query).getOriginalSql());
                    }
                    catch (Exception ex) {
                        this.invalidationException = ExceptionFactory.createException(ex.getMessage(), ex);
                    }
                    if (this.invalidationException == null) break block31;
                    this.invalid = true;
                    this.query.closeQuery();
                    if (this.results != null) {
                        try {
                            this.results.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.generatedKeysResults != null) {
                        try {
                            this.generatedKeysResults.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        this.closeAllOpenResults();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.connection != null && !((Boolean)this.dontTrackOpenResources.getValue()).booleanValue()) {
                        this.connection.unregisterStatement(this);
                    }
                }
                catch (Throwable t2) {
                    span.setError(t2);
                    throw t2;
                }
                finally {
                    span.end();
                }
            }
            finally {
                connectionLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSetInternalMethods serverExecute(int maxRowsToRetrieve, boolean createStreamingResultSet, ColumnDefinition metadata) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ResultSetInternalMethods resultSetInternalMethods = this.results = (ResultSetInternalMethods)((ServerPreparedQuery)this.query).serverExecute(maxRowsToRetrieve, createStreamingResultSet, metadata, this.resultSetFactory);
                return resultSetInternalMethods;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serverPrepare(String sql) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                SQLException t2 = null;
                try {
                    ServerPreparedQuery q = (ServerPreparedQuery)this.query;
                    q.serverPrepare(sql);
                }
                catch (IOException ioEx) {
                    t2 = SQLError.createCommunicationsException(this.connection, this.session.getProtocol().getPacketSentTimeHolder(), this.session.getProtocol().getPacketReceivedTimeHolder(), ioEx, this.exceptionInterceptor);
                }
                catch (CJException sqlEx) {
                    SQLException ex = SQLExceptionsMapping.translateException(sqlEx, this.exceptionInterceptor);
                    if (((Boolean)this.dumpQueriesOnException.getValue()).booleanValue()) {
                        StringBuilder messageBuf = new StringBuilder(((PreparedQuery)this.query).getOriginalSql().length() + 32);
                        messageBuf.append("\n\nQuery being prepared when exception was thrown:\n\n");
                        messageBuf.append(((PreparedQuery)this.query).getOriginalSql());
                        ex = ServerPreparedStatement.appendMessageToException(ex, messageBuf.toString(), this.exceptionInterceptor);
                    }
                    t2 = ex;
                }
                finally {
                    block22: {
                        try {
                            this.session.clearInputStream();
                        }
                        catch (Exception e) {
                            if (t2 != null) break block22;
                            t2 = SQLError.createCommunicationsException(this.connection, this.session.getProtocol().getPacketSentTimeHolder(), this.session.getProtocol().getPacketReceivedTimeHolder(), e, this.exceptionInterceptor);
                        }
                    }
                    if (t2 != null) {
                        throw t2;
                    }
                }
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    protected void checkBounds(int parameterIndex, int parameterIndexOffset) throws SQLException {
        int paramCount = ((PreparedQuery)this.query).getParameterCount();
        if (paramCount == 0) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ServerPreparedStatement.8"), this.session.getExceptionInterceptor());
        }
        if (parameterIndex < 0 || parameterIndex > paramCount) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ServerPreparedStatement.9") + (parameterIndex + 1) + Messages.getString("ServerPreparedStatement.10") + paramCount, this.session.getExceptionInterceptor());
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this.checkClosed();
            throw SQLError.createSQLFeatureNotSupportedException();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        try {
            this.checkClosed();
            this.setString(parameterIndex, x.toString());
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public long getServerStatementId() {
        return ((ServerPreparedQuery)this.query).getServerStatementId();
    }

    @Override
    protected boolean containsOnDuplicateKeyUpdate() {
        return this.hasOnDuplicateKeyUpdate;
    }

    @Override
    protected ClientPreparedStatement prepareBatchedInsertSQL(JdbcConnection localConn, int numBatches) throws SQLException {
        Lock connectionLock = this.checkClosed().getConnectionLock();
        connectionLock.lock();
        try {
            ClientPreparedStatement pstmt = localConn.prepareStatement(((PreparedQuery)this.query).getQueryInfo().getSqlForBatch(numBatches), this.resultSetConcurrency, this.query.getResultType().getIntValue()).unwrap(ClientPreparedStatement.class);
            pstmt.setRetrieveGeneratedKeys(this.retrieveGeneratedKeys);
            this.getQueryAttributesBindings().runThroughAll(a -> pstmt.setAttribute(a.getName(), a.getValue()));
            ClientPreparedStatement clientPreparedStatement = pstmt;
            return clientPreparedStatement;
        }
        catch (CJException e) {
            SQLException sqlEx = SQLError.createSQLException(Messages.getString("ServerPreparedStatement.27"), "S1000", this.exceptionInterceptor);
            sqlEx.initCause(e);
            throw sqlEx;
        }
        finally {
            connectionLock.unlock();
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        try {
            super.setPoolable(poolable);
            if (!poolable && this.isCached) {
                this.connection.decachePreparedStatement(this);
                this.isCached = false;
                if (this.isClosed) {
                    this.isClosed = false;
                    this.doClose(CloseOption.PROPAGATE, CloseOption.NO_CACHE);
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }
}

