/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mariadb.jdbc;

import com.vecoo.extralib.shade.mariadb.jdbc.BasePreparedStatement;
import com.vecoo.extralib.shade.mariadb.jdbc.Configuration;
import com.vecoo.extralib.shade.mariadb.jdbc.Connection;
import com.vecoo.extralib.shade.mariadb.jdbc.ParameterMetaData;
import com.vecoo.extralib.shade.mariadb.jdbc.client.ColumnDecoder;
import com.vecoo.extralib.shade.mariadb.jdbc.client.Completion;
import com.vecoo.extralib.shade.mariadb.jdbc.client.result.CompleteResult;
import com.vecoo.extralib.shade.mariadb.jdbc.client.result.Result;
import com.vecoo.extralib.shade.mariadb.jdbc.client.result.ResultSetMetaData;
import com.vecoo.extralib.shade.mariadb.jdbc.client.util.ClosableLock;
import com.vecoo.extralib.shade.mariadb.jdbc.client.util.Parameters;
import com.vecoo.extralib.shade.mariadb.jdbc.export.ExceptionFactory;
import com.vecoo.extralib.shade.mariadb.jdbc.export.Prepare;
import com.vecoo.extralib.shade.mariadb.jdbc.message.ClientMessage;
import com.vecoo.extralib.shade.mariadb.jdbc.message.client.ExecutePacket;
import com.vecoo.extralib.shade.mariadb.jdbc.message.client.PrepareExecutePacket;
import com.vecoo.extralib.shade.mariadb.jdbc.message.client.PreparePacket;
import com.vecoo.extralib.shade.mariadb.jdbc.message.server.OkPacket;
import com.vecoo.extralib.shade.mariadb.jdbc.message.server.PrepareResultPacket;
import com.vecoo.extralib.shade.mariadb.jdbc.util.ParameterList;
import com.vecoo.extralib.shade.mariadb.jdbc.util.timeout.QueryTimeoutHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class ServerPreparedStatement
extends BasePreparedStatement {
    private static final Pattern PREPARABLE_STATEMENT_PATTERN = Pattern.compile("^(SELECT|UPDATE|INSERT|DELETE|REPLACE|DO|CALL)", 2);

    public ServerPreparedStatement(String sql, Connection con, ClosableLock lock, int autoGeneratedKeys, int resultSetType, int resultSetConcurrency, int defaultFetchSize) throws SQLException {
        super(sql, con, lock, autoGeneratedKeys, resultSetType, resultSetConcurrency, defaultFetchSize);
        Prepare prepare = this.prepareResult = con.cachePrepStmts() ? con.getContext().getPrepareCacheCmd(sql, this) : null;
        if (this.prepareResult == null && !PREPARABLE_STATEMENT_PATTERN.matcher(sql).find()) {
            con.getClient().execute(new PreparePacket(sql), this, true);
        }
        this.parameters = new ParameterList();
    }

    protected void executeInternal() throws SQLException {
        this.checkNotClosed();
        this.validParameters();
        try (ClosableLock ignore = this.lock.closeableLock();
             QueryTimeoutHandler ignore2 = this.con.handleTimeout(this.queryTimeout);){
            String cmd = this.escapeTimeout(this.sql);
            if (this.prepareResult == null && this.con.cachePrepStmts()) {
                this.prepareResult = this.con.getContext().getPrepareCacheCmd(cmd, this);
            }
            if (this.prepareResult == null && this.con.getContext().permitPipeline()) {
                this.executePipeline(cmd);
            } else {
                this.executeStandard(cmd);
            }
        }
        catch (SQLException e) {
            this.results = null;
            this.currResult = null;
            throw e;
        }
        finally {
            this.localInfileInputStream = null;
        }
    }

    private void executePipeline(String cmd) throws SQLException {
        try {
            List<Completion> res = this.con.getClient().execute(new PrepareExecutePacket(cmd, this.parameters, this, this.localInfileInputStream), this, this.fetchSize, this.maxRows, this.resultSetConcurrency, this.resultSetType, this.closeOnCompletion, false);
            this.results = res.subList(1, res.size());
        }
        catch (SQLException ex) {
            this.results = null;
            throw ex;
        }
    }

    private void executeStandard(String cmd) throws SQLException {
        if (this.prepareResult == null) {
            if (this.con.cachePrepStmts()) {
                this.prepareResult = this.con.getContext().getPrepareCacheCmd(cmd, this);
            }
            if (this.prepareResult == null) {
                this.con.getClient().execute(new PreparePacket(cmd), this, true);
            }
        }
        this.validParameters();
        ExecutePacket execute = new ExecutePacket(this.prepareResult, this.parameters, cmd, this, this.localInfileInputStream);
        this.results = this.con.getClient().execute(execute, this, this.fetchSize, this.maxRows, this.resultSetConcurrency, this.resultSetType, this.closeOnCompletion, false);
    }

    @Override
    protected boolean executeInternalPreparedBatch() throws SQLException {
        boolean canUseBulk;
        this.checkNotClosed();
        String cmd = this.escapeTimeout(this.sql);
        boolean possibleLoadLocal = this.con.getContext().hasClientCapability(128L);
        if (possibleLoadLocal) {
            String sqlUpper = this.sql.toUpperCase(Locale.ROOT);
            boolean bl = possibleLoadLocal = sqlUpper.contains(" LOCAL ") && sqlUpper.contains("LOAD") && sqlUpper.contains(" INFILE");
        }
        if (possibleLoadLocal) {
            this.executeBatchStandard(cmd);
            return false;
        }
        Configuration conf = this.con.getContext().getConf();
        this.parseCommandIfNeeded(this.sql);
        boolean bl = canUseBulk = !(!this.con.getContext().hasServerCapability(0x400000000L) || (!this.clientParser.isInsert() || !conf.useBulkStmts() && !conf.useBulkStmtsForInserts() || !this.con.getContext().hasClientCapability(0x2000000000L) && this.clientParser.isInsertDuplicate()) && (this.clientParser.isInsert() || !conf.useBulkStmts()) || !this.con.getContext().hasClientCapability(0x2000000000L) && this.autoGeneratedKeys == 1);
        if (canUseBulk && this.batchParameters.size() > 1 && ((Parameters)this.batchParameters.get(0)).size() > 0) {
            this.executeBatchBulk(cmd);
            return true;
        }
        this.executeBatchPipeline(cmd);
        return false;
    }

    private void executeBatchPipeline(String cmd) throws SQLException {
        if (this.prepareResult == null && this.con.cachePrepStmts()) {
            this.prepareResult = this.con.getContext().getPrepareCacheCmd(cmd, this);
        }
        if (!this.con.getContext().hasServerCapability(0x400000000L)) {
            this.con.getClient().execute(new PreparePacket(cmd), this, false);
        }
        int maxCmd = 250;
        ArrayList<Completion> res = new ArrayList<Completion>();
        try {
            int index = 0;
            if (this.prepareResult == null) {
                res.addAll(this.executeBunchPrepare(cmd, index, maxCmd));
                index += maxCmd;
            }
            while (index < this.batchParameters.size()) {
                res.addAll(this.executeBunch(cmd, index, maxCmd));
                index += maxCmd;
            }
            this.results = res;
        }
        catch (SQLException bue) {
            this.results = null;
            throw this.exceptionFactory().createBatchUpdate(res, this.batchParameters.size(), bue);
        }
    }

    private List<Completion> executeBunch(String cmd, int index, int maxCmd) throws SQLException {
        int maxCmdToSend = Math.min(this.batchParameters.size() - index, maxCmd);
        ClientMessage[] packets = new ClientMessage[maxCmdToSend];
        for (int i = index; i < index + maxCmdToSend; ++i) {
            packets[i - index] = new ExecutePacket(this.prepareResult, (Parameters)this.batchParameters.get(i), cmd, this, this.localInfileInputStream);
        }
        return this.con.getClient().executePipeline(packets, this, 0, this.maxRows, 1007, 1003, this.closeOnCompletion, false);
    }

    private List<Completion> executeBunchPrepare(String cmd, int index, int maxCmd) throws SQLException {
        int maxCmdToSend = Math.min(this.batchParameters.size() - index, maxCmd);
        ClientMessage[] packets = new ClientMessage[maxCmdToSend + 1];
        packets[0] = new PreparePacket(cmd);
        for (int i = index; i < index + maxCmdToSend; ++i) {
            packets[i + 1 - index] = new ExecutePacket(null, (Parameters)this.batchParameters.get(i), cmd, this, this.localInfileInputStream);
        }
        List<Completion> res = this.con.getClient().executePipeline(packets, this, 0, this.maxRows, 1007, 1003, this.closeOnCompletion, false);
        if (res.get(0) instanceof PrepareResultPacket) {
            return res.subList(1, res.size());
        }
        return res;
    }

    private void executeBatchStandard(String cmd) throws SQLException {
        ArrayList<Completion> tmpResults = new ArrayList<Completion>();
        SQLException error = null;
        for (Parameters batchParameter : this.batchParameters) {
            if (this.prepareResult == null) {
                if (this.con.cachePrepStmts()) {
                    this.prepareResult = this.con.getContext().getPrepareCacheCmd(cmd, this);
                }
                if (this.prepareResult == null) {
                    this.con.getClient().execute(new PreparePacket(cmd), this, false);
                }
            }
            try {
                ExecutePacket execute = new ExecutePacket(this.prepareResult, batchParameter, cmd, this, this.localInfileInputStream);
                tmpResults.addAll(this.con.getClient().execute(execute, this, false));
            }
            catch (SQLException e) {
                if (error != null) continue;
                error = e;
            }
        }
        if (error != null) {
            throw this.exceptionFactory().createBatchUpdate(tmpResults, this.batchParameters.size(), error);
        }
        this.results = tmpResults;
    }

    @Override
    public boolean execute() throws SQLException {
        this.executeInternal();
        this.handleParameterOutput();
        return this.currResult instanceof Result;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        super.setMaxRows(max);
        if (this.con.useServerMaxRows() && this.prepareResult != null) {
            this.prepareResult.decrementUse(this.con.getClient(), this);
            this.prepareResult = null;
        }
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        super.setLargeMaxRows(max);
        if (this.con.useServerMaxRows() && this.prepareResult != null) {
            this.prepareResult.decrementUse(this.con.getClient(), this);
            this.prepareResult = null;
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        super.setQueryTimeout(seconds);
        if (this.con.useServerTimeout() && this.prepareResult != null) {
            this.prepareResult.decrementUse(this.con.getClient(), this);
            this.prepareResult = null;
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeInternal();
        this.handleParameterOutput();
        if (this.currResult instanceof Result) {
            return (Result)this.currResult;
        }
        if (this.con.getContext().getConf().permitNoResults()) {
            return new CompleteResult(new ColumnDecoder[0], new byte[0][], this.con.getContext(), this.resultSetType);
        }
        throw new SQLException("PrepareStatement.executeQuery() command does NOT return a result-set as expected. Either use PrepareStatement.execute(), PrepareStatement.executeUpdate(), or correct command");
    }

    @Override
    public int executeUpdate() throws SQLException {
        return (int)this.executeLargeUpdate();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.executeInternal();
        this.handleParameterOutput();
        if (this.currResult instanceof Result) {
            throw this.exceptionFactory().create("the given SQL statement produces an unexpected ResultSet object", "HY000");
        }
        return ((OkPacket)this.currResult).getAffectedRows();
    }

    protected void handleParameterOutput() throws SQLException {
        this.currResult = (Completion)this.results.remove(0);
    }

    @Override
    public void addBatch() throws SQLException {
        this.validParameters();
        if (this.batchParameters == null) {
            this.batchParameters = new ArrayList();
        }
        this.batchParameters.add(this.parameters);
        this.parameters = this.parameters.clone();
    }

    protected void validParameters() throws SQLException {
        if (this.prepareResult != null) {
            for (int i = 0; i < this.prepareResult.getParameters().length; ++i) {
                if (this.parameters.containsKey(i)) continue;
                throw this.exceptionFactory().create("Parameter at position " + (i + 1) + " is not set", "07004");
            }
        } else {
            if (this.batchParameters != null && !this.batchParameters.isEmpty() && this.parameters.size() < ((Parameters)this.batchParameters.get(0)).size()) {
                throw this.exceptionFactory().create("batch set of parameters differ from previous set. All parameters must be set", "07004");
            }
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (this.parameters.containsKey(i)) continue;
                throw this.exceptionFactory().create("Parameter at position " + (i + 1) + " is not set", "07004");
            }
        }
    }

    @Override
    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        if (this.prepareResult == null) {
            this.con.getClient().execute(new PreparePacket(this.escapeTimeout(this.sql)), this, true);
        }
        return new ResultSetMetaData(this.exceptionFactory(), this.prepareResult.getColumns(), this.con.getContext().getConf(), false);
    }

    @Override
    public java.sql.ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.prepareResult == null) {
            this.con.getClient().execute(new PreparePacket(this.escapeTimeout(this.sql)), this, true);
        }
        return new ParameterMetaData(this.exceptionFactory(), this.prepareResult.getParameters());
    }

    protected ExceptionFactory exceptionFactory() {
        return this.con.getExceptionFactory().of(this);
    }

    @Override
    public void close() throws SQLException {
        if (this.prepareResult != null) {
            this.prepareResult.decrementUse(this.con.getClient(), this);
            this.prepareResult = null;
        }
        this.con.fireStatementClosed(this);
        super.close();
    }

    @Override
    public String toString() {
        return "ServerPreparedStatement{" + super.toString() + '}';
    }
}

