/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mariadb.jdbc.pool;

import com.vecoo.extralib.shade.mariadb.jdbc.Configuration;
import com.vecoo.extralib.shade.mariadb.jdbc.pool.Pool;
import com.vecoo.extralib.shade.mariadb.jdbc.pool.PoolThreadFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class Pools {
    private static final AtomicInteger poolIndex = new AtomicInteger();
    private static final Map<Configuration, Pool> poolMap = new ConcurrentHashMap<Configuration, Pool>();
    private static ScheduledThreadPoolExecutor poolExecutor = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pool retrievePool(Configuration conf) {
        if (!poolMap.containsKey(conf)) {
            Map<Configuration, Pool> map = poolMap;
            synchronized (map) {
                if (!poolMap.containsKey(conf)) {
                    if (poolExecutor == null) {
                        poolExecutor = new ScheduledThreadPoolExecutor(1, new PoolThreadFactory("MariaDbPool-maxTimeoutIdle-checker"));
                    }
                    Pool pool = new Pool(conf, poolIndex.incrementAndGet(), poolExecutor);
                    poolMap.put(conf, pool);
                    return pool;
                }
            }
        }
        return poolMap.get(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Pool pool) {
        if (poolMap.containsKey(pool.getConf())) {
            Map<Configuration, Pool> map = poolMap;
            synchronized (map) {
                if (poolMap.containsKey(pool.getConf())) {
                    poolMap.remove(pool.getConf());
                    if (poolMap.isEmpty()) {
                        Pools.shutdownExecutor();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        Map<Configuration, Pool> map = poolMap;
        synchronized (map) {
            for (Pool pool : poolMap.values()) {
                try {
                    pool.close();
                }
                catch (Exception exception) {}
            }
            Pools.shutdownExecutor();
            poolMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(String poolName) {
        if (poolName == null) {
            return;
        }
        Map<Configuration, Pool> map = poolMap;
        synchronized (map) {
            for (Pool pool : poolMap.values()) {
                if (!poolName.equals(pool.getConf().poolName())) continue;
                try {
                    pool.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
        }
    }

    private static void shutdownExecutor() {
        if (poolExecutor != null) {
            poolExecutor.shutdown();
            try {
                poolExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            poolExecutor = null;
        }
    }
}

