/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mariadb.jdbc.type;

import com.vecoo.extralib.shade.mariadb.jdbc.client.Column;
import com.vecoo.extralib.shade.mariadb.jdbc.client.ReadableByteBuf;
import com.vecoo.extralib.shade.mariadb.jdbc.type.GeometryCollection;
import com.vecoo.extralib.shade.mariadb.jdbc.type.LineString;
import com.vecoo.extralib.shade.mariadb.jdbc.type.MultiLineString;
import com.vecoo.extralib.shade.mariadb.jdbc.type.MultiPoint;
import com.vecoo.extralib.shade.mariadb.jdbc.type.MultiPolygon;
import com.vecoo.extralib.shade.mariadb.jdbc.type.Point;
import com.vecoo.extralib.shade.mariadb.jdbc.type.Polygon;
import java.sql.SQLDataException;

public interface Geometry {
    public static Point parsePoint(boolean littleEndian, ReadableByteBuf buf) {
        double x = littleEndian ? buf.readDouble() : buf.readDoubleBE();
        double y = littleEndian ? buf.readDouble() : buf.readDoubleBE();
        return new Point(x, y);
    }

    public static Geometry getGeometry(ReadableByteBuf buf, int length, Column column) throws SQLDataException {
        if (length == 0) {
            return null;
        }
        boolean littleEndian = buf.readByte() == 1;
        int dataType = littleEndian ? buf.readInt() : buf.readIntBE();
        switch (dataType) {
            case 1: {
                return Geometry.parsePoint(littleEndian, buf);
            }
            case 2: {
                int pointNumber = littleEndian ? buf.readInt() : buf.readIntBE();
                Point[] points = new Point[pointNumber];
                for (int i = 0; i < pointNumber; ++i) {
                    points[i] = Geometry.parsePoint(littleEndian, buf);
                }
                return new LineString(points, true);
            }
            case 3: {
                int numRings = littleEndian ? buf.readInt() : buf.readIntBE();
                LineString[] lines = new LineString[numRings];
                for (int i = 0; i < numRings; ++i) {
                    int pointNb = littleEndian ? buf.readInt() : buf.readIntBE();
                    Point[] lsPoints = new Point[pointNb];
                    for (int j = 0; j < pointNb; ++j) {
                        lsPoints[j] = Geometry.parsePoint(littleEndian, buf);
                    }
                    lines[i] = new LineString(lsPoints, false);
                }
                return new Polygon(lines);
            }
            case 4: {
                int pointNb = littleEndian ? buf.readInt() : buf.readIntBE();
                Point[] pointArr = new Point[pointNb];
                for (int i = 0; i < pointNb; ++i) {
                    pointArr[i] = (Point)Geometry.getGeometry(buf, length, column);
                }
                return new MultiPoint(pointArr);
            }
            case 5: {
                int multiNb = littleEndian ? buf.readInt() : buf.readIntBE();
                LineString[] multiLines = new LineString[multiNb];
                for (int i = 0; i < multiNb; ++i) {
                    multiLines[i] = (LineString)Geometry.getGeometry(buf, length, column);
                }
                return new MultiLineString(multiLines);
            }
            case 6: {
                int multiPolyNb = littleEndian ? buf.readInt() : buf.readIntBE();
                Polygon[] multiPolygons = new Polygon[multiPolyNb];
                for (int i = 0; i < multiPolyNb; ++i) {
                    multiPolygons[i] = (Polygon)Geometry.getGeometry(buf, length, column);
                }
                return new MultiPolygon(multiPolygons);
            }
            case 7: {
                int multiCollNb = littleEndian ? buf.readInt() : buf.readIntBE();
                Geometry[] multiGeos = new Geometry[multiCollNb];
                for (int i = 0; i < multiCollNb; ++i) {
                    multiGeos[i] = Geometry.getGeometry(buf, length, column);
                }
                return new GeometryCollection(multiGeos);
            }
        }
        buf.skip(length - 5);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Geometry", new Object[]{column.getType()}));
    }
}

