/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mysql.cj.jdbc;

import com.vecoo.extralib.shade.mysql.cj.Messages;
import com.vecoo.extralib.shade.mysql.cj.MysqlType;
import com.vecoo.extralib.shade.mysql.cj.exceptions.AssertionFailedException;
import com.vecoo.extralib.shade.mysql.cj.exceptions.CJException;
import com.vecoo.extralib.shade.mysql.cj.jdbc.DatabaseMetaData;
import com.vecoo.extralib.shade.mysql.cj.jdbc.JdbcConnection;
import com.vecoo.extralib.shade.mysql.cj.jdbc.exceptions.SQLError;
import com.vecoo.extralib.shade.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import com.vecoo.extralib.shade.mysql.cj.jdbc.result.ResultSetFactory;
import com.vecoo.extralib.shade.mysql.cj.protocol.a.result.ByteArrayRow;
import com.vecoo.extralib.shade.mysql.cj.protocol.a.result.ResultsetRowsStatic;
import com.vecoo.extralib.shade.mysql.cj.result.DefaultColumnDefinition;
import com.vecoo.extralib.shade.mysql.cj.result.Field;
import com.vecoo.extralib.shade.mysql.cj.result.Row;
import com.vecoo.extralib.shade.mysql.cj.util.SearchMode;
import com.vecoo.extralib.shade.mysql.cj.util.StringUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DatabaseMetaDataMysqlSchema
extends DatabaseMetaData {
    DatabaseMetaDataMysqlSchema(JdbcConnection connToSet, String databaseToSet, ResultSetFactory resultSetFactory) {
        super(connToSet, databaseToSet, resultSetFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ForeignKeyConstraintInfo> extractForeignKeysForTable(String dbName, String tableName) throws SQLException {
        ArrayList<String> tableList = new ArrayList<String>();
        if (tableName != null) {
            tableList.add(tableName);
        } else {
            ResultSet rs = null;
            try {
                String quotedDbName = this.pedanticValue() != false ? dbName : StringUtils.quoteIdentifier(dbName, this.getQuoteId(), true);
                rs = this.chooseBasedOnDatabaseTerm(() -> this.getTables(quotedDbName, null, null, new String[]{"TABLE"}), () -> this.getTables(null, quotedDbName, null, new String[]{"TABLE"}));
                while (rs.next()) {
                    tableList.add(rs.getString("TABLE_NAME"));
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        AssertionFailedException.shouldNotHappen(e);
                    }
                    rs = null;
                }
            }
        }
        ArrayList<ForeignKeyConstraintInfo> tableForeignKeysList = new ArrayList<ForeignKeyConstraintInfo>();
        ResultSet rs = null;
        try (Statement stmt = this.getJdbcConnection().getMetaDataSafeStatement();){
            for (String tableToExtract : tableList) {
                StringBuilder query = new StringBuilder("SHOW CREATE TABLE ");
                query.append(StringUtils.getFullyQualifiedName(dbName, tableToExtract, this.getQuoteId(), true));
                try {
                    rs = stmt.executeQuery(query.toString());
                }
                catch (SQLException e) {
                    String sqlState = e.getSQLState();
                    int errorCode = e.getErrorCode();
                    if ("42S02".equals(sqlState) && (errorCode == 1146 || errorCode == 1109) || "42000".equals(sqlState) && errorCode == 1049) continue;
                    throw e;
                }
                while (rs.next()) {
                    tableForeignKeysList.addAll(this.extractForeignKeysFromCreateTable(dbName, rs.getString(1), rs.getString(2)));
                }
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    AssertionFailedException.shouldNotHappen(e);
                }
                rs = null;
            }
        }
        return tableForeignKeysList;
    }

    private List<ForeignKeyConstraintInfo> extractForeignKeysFromCreateTable(String dbName, String tableName, String createTableSql) throws SQLException {
        Function<String, Integer> mysqlActionToJdbc = action -> {
            if (action.startsWith("NO ACTION")) {
                return 3;
            }
            if (action.startsWith("CASCADE")) {
                return 0;
            }
            if (action.startsWith("SET NULL")) {
                return 2;
            }
            if (action.startsWith("SET DEFAULT")) {
                return 4;
            }
            return 1;
        };
        ArrayList<ForeignKeyConstraintInfo> tableForeignKeysList = new ArrayList<ForeignKeyConstraintInfo>();
        StringTokenizer lineTokenizer = new StringTokenizer(createTableSql, "\n");
        while (lineTokenizer.hasMoreTokens()) {
            int onUpdatePos;
            int beginPos;
            String line = lineTokenizer.nextToken().trim();
            String constraintName = null;
            String referencedDbName = StringUtils.quoteIdentifier(dbName, this.getQuoteId(), true);
            String referencedTableName = "";
            int referentialActionOnDelete = 1;
            int referentialActionOnUpdate = 1;
            if (StringUtils.startsWithIgnoreCase(line, "CONSTRAINT") && (beginPos = line.indexOf(this.getQuoteId())) != -1) {
                int endPos = -1;
                endPos = StringUtils.indexOfQuoteDoubleAware(line, this.getQuoteId(), beginPos + 1);
                if (endPos != -1) {
                    constraintName = StringUtils.unquoteIdentifier(line.substring(beginPos + 1, endPos), this.getQuoteId());
                    line = line.substring(endPos + 1, line.length()).trim();
                }
            }
            if (!line.startsWith("FOREIGN KEY")) continue;
            int afterFk = "FOREIGN KEY".length();
            int referencingColumnsBegin = StringUtils.indexOfIgnoreCase(afterFk, line, "(", this.getQuoteId(), this.getQuoteId(), SearchMode.__BSE_MRK_COM_MYM_HNT_WS);
            if (referencingColumnsBegin == -1) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.14"), "S1000", this.getExceptionInterceptor());
            }
            int referencingColumnsEnd = StringUtils.indexOfIgnoreCase(referencingColumnsBegin, line, ")", this.getQuoteId(), this.getQuoteId(), SearchMode.__BSE_MRK_COM_MYM_HNT_WS);
            if (referencingColumnsEnd == -1) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.15"), "S1000", this.getExceptionInterceptor());
            }
            String referencingColumnNamesToken = line.substring(referencingColumnsBegin + 1, referencingColumnsEnd);
            List<String> referencingColumnNames = StringUtils.split(referencingColumnNamesToken, ",", this.getQuoteId(), this.getQuoteId(), false).stream().map(c -> StringUtils.unquoteIdentifier(c, this.getQuoteId())).collect(Collectors.toList());
            int indexOfRef = StringUtils.indexOfIgnoreCase(afterFk, line, "REFERENCES", this.getQuoteId(), this.getQuoteId(), SearchMode.__BSE_MRK_COM_MYM_HNT_WS);
            if (indexOfRef == -1) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.16"), "S1000", this.getExceptionInterceptor());
            }
            int afterRef = indexOfRef + "REFERENCES".length();
            int referencedColumnsBegin = StringUtils.indexOfIgnoreCase(afterRef, line, "(", this.getQuoteId(), this.getQuoteId(), SearchMode.__BSE_MRK_COM_MYM_HNT_WS);
            if (referencedColumnsBegin == -1) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.17"), "S1000", this.getExceptionInterceptor());
            }
            referencedTableName = line.substring(afterRef, referencedColumnsBegin).trim();
            int referencedColumnsEnd = StringUtils.indexOfIgnoreCase(referencedColumnsBegin + 1, line, ")", this.getQuoteId(), this.getQuoteId(), SearchMode.__BSE_MRK_COM_MYM_HNT_WS);
            if (referencedColumnsEnd == -1) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.18"), "S1000", this.getExceptionInterceptor());
            }
            String referencedColumnNamesToken = line.substring(referencedColumnsBegin + 1, referencedColumnsEnd);
            List<String> referencedColumnNames = StringUtils.split(referencedColumnNamesToken, ",", this.getQuoteId(), this.getQuoteId(), false).stream().map(c -> StringUtils.unquoteIdentifier(c, this.getQuoteId())).collect(Collectors.toList());
            if (referencedColumnNames.size() != referencingColumnNames.size()) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.12"), "S1000", this.getExceptionInterceptor());
            }
            List<String> tableRef = StringUtils.splitDBdotName(referencedTableName, referencedDbName, this.getQuoteId(), true);
            referencedDbName = StringUtils.unquoteIdentifier(tableRef.get(0), this.getQuoteId());
            referencedTableName = StringUtils.unquoteIdentifier(tableRef.get(1), this.getQuoteId());
            String referentialActions = line.substring(referencedColumnsEnd + 1);
            int onDeletePos = referentialActions.indexOf("ON DELETE");
            if (onDeletePos != -1) {
                int afterOnDelete = onDeletePos + "ON DELETE ".length();
                String onDeleteAction = referentialActions.substring(afterOnDelete);
                referentialActionOnDelete = mysqlActionToJdbc.apply(onDeleteAction);
            }
            if ((onUpdatePos = referentialActions.indexOf("ON UPDATE")) != -1) {
                int afterOnUpdate = onUpdatePos + "ON UPDATE ".length();
                String onUpdateAction = referentialActions.substring(afterOnUpdate);
                referentialActionOnUpdate = mysqlActionToJdbc.apply(onUpdateAction);
            }
            tableForeignKeysList.add(new ForeignKeyConstraintInfo(constraintName, dbName, tableName, referencingColumnNames, referencedDbName, referencedTableName, referencedColumnNames, referentialActionOnDelete, referentialActionOnUpdate));
        }
        return tableForeignKeysList;
    }

    private ResultSet getStoredRoutines(String catalog, String schemaPattern, String routineNamePattern, StoredRoutineType targetMetaData) throws SQLException {
        String dbFilter = this.chooseDatabaseTerm(catalog, schemaPattern);
        String routineNameFilter = this.normalizeIdentifierQuoting(routineNamePattern);
        TreeMap<MultiComparable, ByteArrayRow> sortedRows = new TreeMap<MultiComparable, ByteArrayRow>();
        List dbList = this.chooseBasedOnDatabaseTerm(() -> this.getDatabasesByLiteral(dbFilter), () -> this.getDatabasesByPattern(dbFilter));
        for (String db : dbList) {
            Object row;
            Throwable throwable;
            StringBuilder query;
            if (targetMetaData == StoredRoutineType.FUNCTION || this.getProceduresReturnsFunctionsValue().booleanValue()) {
                query = new StringBuilder("SHOW FUNCTION STATUS WHERE ");
                query.append(this.chooseBasedOnDatabaseTerm(() -> "Db = ?", () -> "Db LIKE ?"));
                if (!StringUtils.isNullOrEmpty(routineNameFilter)) {
                    query.append(" AND Name LIKE ?");
                }
                throwable = null;
                try (PreparedStatement functionsStmt = this.prepareMetaDataSafeStatement(query.toString());){
                    functionsStmt.setString(1, db);
                    if (!StringUtils.isNullOrEmpty(routineNameFilter)) {
                        functionsStmt.setString(2, routineNameFilter);
                    }
                    ResultSet functionsRs = functionsStmt.executeQuery();
                    while (functionsRs.next()) {
                        String funcDb = functionsRs.getString("db");
                        String functionName = functionsRs.getString("name");
                        row = null;
                        if (targetMetaData == StoredRoutineType.PROCEDURE) {
                            row = new byte[9][];
                            row[0] = this.chooseBasedOnDatabaseTerm(() -> this.s2b(funcDb), () -> this.s2b("def"));
                            row[1] = this.chooseBasedOnDatabaseTerm(() -> null, () -> this.s2b(funcDb));
                            row[2] = this.s2b(functionName);
                            row[3] = null;
                            row[4] = null;
                            row[5] = null;
                            row[6] = this.s2b(functionsRs.getString("comment"));
                            row[7] = this.n2b(2);
                            row[8] = this.s2b(functionName);
                        } else {
                            row = new byte[6][];
                            row[0] = this.chooseBasedOnDatabaseTerm(() -> this.s2b(funcDb), () -> this.s2b("def"));
                            row[1] = this.chooseBasedOnDatabaseTerm(() -> null, () -> this.s2b(funcDb));
                            row[2] = this.s2b(functionName);
                            row[3] = this.s2b(functionsRs.getString("comment"));
                            row[4] = this.n2b(1);
                            row[5] = this.s2b(functionName);
                        }
                        sortedRows.put(new MultiComparable(new Comparable[]{funcDb, functionName, StoredRoutineType.FUNCTION}), new ByteArrayRow((byte[][])row, this.getExceptionInterceptor()));
                    }
                    try {
                        functionsRs.close();
                    }
                    catch (Exception sqlEx) {
                        AssertionFailedException.shouldNotHappen(sqlEx);
                    }
                    functionsRs = null;
                }
                catch (Throwable functionsRs) {
                    throwable = functionsRs;
                    throw functionsRs;
                }
            }
            if (targetMetaData != StoredRoutineType.PROCEDURE) continue;
            query = new StringBuilder("SHOW PROCEDURE STATUS WHERE ");
            query.append(this.chooseBasedOnDatabaseTerm(() -> "Db = ?", () -> "Db LIKE ?"));
            if (!StringUtils.isNullOrEmpty(routineNameFilter)) {
                query.append(" AND Name LIKE ?");
            }
            PreparedStatement proceduresStmt = this.prepareMetaDataSafeStatement(query.toString());
            throwable = null;
            try {
                proceduresStmt.setString(1, db);
                if (!StringUtils.isNullOrEmpty(routineNameFilter)) {
                    proceduresStmt.setString(2, routineNameFilter);
                }
                ResultSet proceduresRs = proceduresStmt.executeQuery();
                while (proceduresRs.next()) {
                    String procDb = proceduresRs.getString("db");
                    String procedureName = proceduresRs.getString("name");
                    row = new byte[9][];
                    row[0] = this.chooseBasedOnDatabaseTerm(() -> this.s2b(procDb), () -> this.s2b("def"));
                    row[1] = this.chooseBasedOnDatabaseTerm(() -> null, () -> this.s2b(procDb));
                    row[2] = this.s2b(procedureName);
                    row[3] = null;
                    row[4] = null;
                    row[5] = null;
                    row[6] = this.s2b(proceduresRs.getString("comment"));
                    row[7] = this.n2b(1);
                    row[8] = this.s2b(procedureName);
                    sortedRows.put(new MultiComparable(new Comparable[]{procDb, procedureName, StoredRoutineType.PROCEDURE}), new ByteArrayRow((byte[][])row, this.getExceptionInterceptor()));
                }
                try {
                    proceduresRs.close();
                }
                catch (Exception sqlEx) {
                    AssertionFailedException.shouldNotHappen(sqlEx);
                }
                proceduresRs = null;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (proceduresStmt == null) continue;
                if (throwable != null) {
                    try {
                        proceduresStmt.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                proceduresStmt.close();
            }
        }
        ArrayList rows = new ArrayList(sortedRows.values());
        Field[] fields = targetMetaData == StoredRoutineType.PROCEDURE ? this.createProceduresFields() : this.createFunctionsFields();
        return this.getResultSetFactory().createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(fields)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet getStoredRoutineColumns(String catalog, String schemaPattern, String routineNamePattern, String columnNamePattern, StoredRoutineType targetMetaData) throws SQLException {
        ArrayList<MultiComparable> routinesToExtract = new ArrayList<MultiComparable>();
        ResultSet routinesRs = null;
        try {
            routinesRs = this.getStoredRoutines(catalog, schemaPattern, routineNamePattern, targetMetaData);
            while (routinesRs.next()) {
                String dbField;
                if (targetMetaData == StoredRoutineType.PROCEDURE) {
                    dbField = this.chooseBasedOnDatabaseTerm(() -> "PROCEDURE_CAT", () -> "PROCEDURE_SCHEM");
                    Object routineType = routinesRs.getShort("PROCEDURE_TYPE") == 1 ? StoredRoutineType.PROCEDURE : StoredRoutineType.FUNCTION;
                    routinesToExtract.add(new MultiComparable(new Comparable[]{routinesRs.getString(dbField), routinesRs.getString("PROCEDURE_NAME"), routineType}));
                    continue;
                }
                dbField = this.chooseBasedOnDatabaseTerm(() -> "FUNCTION_CAT", () -> "FUNCTION_SCHEM");
                routinesToExtract.add(new MultiComparable(new Comparable[]{routinesRs.getString(dbField), routinesRs.getString("FUNCTION_NAME"), StoredRoutineType.FUNCTION}));
            }
        }
        finally {
            if (routinesRs != null) {
                try {
                    routinesRs.close();
                }
                catch (SQLException sqlEx) {
                    AssertionFailedException.shouldNotHappen(sqlEx);
                }
                routinesRs = null;
            }
        }
        ArrayList<Row> rows = new ArrayList<Row>();
        for (MultiComparable routine : routinesToExtract) {
            rows.addAll(this.extractStoredRoutineColumnsTypeInfo((String)routine.getElement(0), (String)routine.getElement(1), (StoredRoutineType)((Object)routine.getElement(2)), columnNamePattern, targetMetaData));
        }
        Field[] fields = targetMetaData == StoredRoutineType.PROCEDURE ? this.createProcedureColumnsFields() : this.createFunctionColumnsFields();
        return this.getResultSetFactory().createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(fields)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Row> extractStoredRoutineColumnsTypeInfo(String dbName, String routineName, StoredRoutineType routineType, String parameterNamePattern, StoredRoutineType targetMetaData) throws SQLException {
        String parameterDef;
        String closingDelimiters;
        String openingDelimiters;
        boolean isRoutineInAnsiMode;
        ArrayList<Row> rows;
        block40: {
            rows = new ArrayList<Row>();
            isRoutineInAnsiMode = false;
            openingDelimiters = null;
            closingDelimiters = null;
            parameterDef = null;
            ResultSet paramRetrievalRs = null;
            try (Statement paramRetrievalStmt = this.getJdbcConnection().getMetaDataSafeStatement();){
                String fieldName = null;
                StringBuilder query = new StringBuilder();
                if (routineType == StoredRoutineType.PROCEDURE) {
                    fieldName = "Create Procedure";
                    query.append("SHOW CREATE PROCEDURE ");
                } else {
                    fieldName = "Create Function";
                    query.append("SHOW CREATE FUNCTION ");
                }
                query.append(StringUtils.quoteIdentifier(dbName, this.getQuoteId(), true));
                query.append('.');
                query.append(StringUtils.quoteIdentifier(routineName, this.getQuoteId(), true));
                paramRetrievalRs = paramRetrievalStmt.executeQuery(query.toString());
                if (!paramRetrievalRs.next()) break block40;
                String routineCode = paramRetrievalRs.getString(fieldName);
                if (!this.noAccessToProcedureBodiesValue().booleanValue() && StringUtils.isNullOrEmpty(routineCode)) {
                    throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.4"), "S1000", this.getExceptionInterceptor());
                }
                try {
                    String sqlMode = paramRetrievalRs.getString("sql_mode");
                    isRoutineInAnsiMode = StringUtils.indexOfIgnoreCase(sqlMode, "ANSI") != -1;
                }
                catch (SQLException e) {
                    AssertionFailedException.shouldNotHappen(e);
                }
                String identifierMarkers = isRoutineInAnsiMode ? "`\"" : "`";
                String identifierAndStringMarkers = "'" + identifierMarkers;
                openingDelimiters = "(" + identifierMarkers;
                closingDelimiters = ")" + identifierMarkers;
                if (!StringUtils.isNullOrEmpty(routineCode)) {
                    routineCode = StringUtils.stripCommentsAndHints(routineCode, identifierAndStringMarkers, identifierAndStringMarkers, !this.getSession().getServerSession().isNoBackslashEscapesSet());
                    int startOfParamDeclaration = StringUtils.indexOfIgnoreCase(0, routineCode, "(", this.getQuoteId(), this.getQuoteId(), this.getSession().getServerSession().isNoBackslashEscapesSet() ? SearchMode.__MRK_COM_MYM_HNT_WS : SearchMode.__FULL);
                    int endOfParamDeclaration = this.indexOfParameterDeclarationEnd(startOfParamDeclaration, routineCode, identifierMarkers);
                    if (routineType == StoredRoutineType.FUNCTION) {
                        int declarationStart;
                        int returnsIndex = StringUtils.indexOfIgnoreCase(0, routineCode, " RETURNS ", this.getQuoteId(), this.getQuoteId(), this.getSession().getServerSession().isNoBackslashEscapesSet() ? SearchMode.__MRK_COM_MYM_HNT_WS : SearchMode.__FULL);
                        int endReturnsDef = this.indexOfEndOfReturnsClause(routineCode, returnsIndex, identifierMarkers);
                        for (declarationStart = returnsIndex + "RETURNS ".length(); declarationStart < routineCode.length() && Character.isWhitespace(routineCode.charAt(declarationStart)); ++declarationStart) {
                        }
                        String returnsDefn = routineCode.substring(declarationStart, endReturnsDef).trim();
                        TypeDescriptor returnsTypeDescriptor = new TypeDescriptor(returnsDefn, "YES");
                        rows.add(this.typeDescriptorToStoredRoutineRow(dbName, routineName, "", false, false, true, returnsTypeDescriptor, 0, targetMetaData));
                    }
                    if (startOfParamDeclaration == -1 || endOfParamDeclaration == -1) {
                        throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.5"), "S1000", this.getExceptionInterceptor());
                    }
                    parameterDef = routineCode.substring(startOfParamDeclaration + 1, endOfParamDeclaration);
                }
            }
            finally {
                if (paramRetrievalRs != null) {
                    try {
                        paramRetrievalRs.close();
                    }
                    catch (SQLException sqlEx) {
                        AssertionFailedException.shouldNotHappen(sqlEx);
                    }
                    paramRetrievalRs = null;
                }
            }
        }
        if (parameterDef == null) return rows;
        int ordinal = 1;
        List<String> parseList = StringUtils.split(parameterDef, ",", openingDelimiters, closingDelimiters, true);
        for (String declaration : parseList) {
            String paramNameFilter;
            if (declaration.trim().length() == 0) break;
            String paramName = null;
            boolean isOutParam = false;
            boolean isInParam = false;
            StringTokenizer declarationTok = new StringTokenizer(declaration = declaration.replaceAll("[\\t\\n\\x0B\\f\\r]", " "), " ");
            if (!declarationTok.hasMoreTokens()) throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.8"), "S1000", this.getExceptionInterceptor());
            String possibleParamName = declarationTok.nextToken();
            if (possibleParamName.equalsIgnoreCase("OUT")) {
                isOutParam = true;
                isInParam = false;
                if (!declarationTok.hasMoreTokens()) throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.6"), "S1000", this.getExceptionInterceptor());
                paramName = declarationTok.nextToken();
            } else if (possibleParamName.equalsIgnoreCase("INOUT")) {
                isOutParam = true;
                isInParam = true;
                if (!declarationTok.hasMoreTokens()) throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.6"), "S1000", this.getExceptionInterceptor());
                paramName = declarationTok.nextToken();
            } else if (possibleParamName.equalsIgnoreCase("IN")) {
                isOutParam = false;
                isInParam = true;
                if (!declarationTok.hasMoreTokens()) throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.6"), "S1000", this.getExceptionInterceptor());
                paramName = declarationTok.nextToken();
            } else {
                isOutParam = false;
                isInParam = true;
                paramName = possibleParamName;
            }
            TypeDescriptor typeDesc = null;
            if (!declarationTok.hasMoreTokens()) throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.7"), "S1000", this.getExceptionInterceptor());
            StringBuilder typeInfo = new StringBuilder(declarationTok.nextToken());
            while (declarationTok.hasMoreTokens()) {
                typeInfo.append(" ");
                typeInfo.append(declarationTok.nextToken());
            }
            typeDesc = new TypeDescriptor(typeInfo.toString(), "YES");
            if (paramName.startsWith("`") && paramName.endsWith("`")) {
                paramName = StringUtils.unquoteIdentifier(paramName, "`");
            } else if (isRoutineInAnsiMode && paramName.startsWith("\"") && paramName.endsWith("\"")) {
                paramName = StringUtils.unquoteIdentifier(paramName, "\"");
            }
            if ((paramNameFilter = this.normalizeIdentifierQuoting(parameterNamePattern)) != null && !StringUtils.wildCompareIgnoreCase(paramName, paramNameFilter)) continue;
            rows.add(this.typeDescriptorToStoredRoutineRow(dbName, routineName, paramName, isOutParam, isInParam, false, typeDesc, ordinal++, targetMetaData));
        }
        return rows;
    }

    private int indexOfParameterDeclarationEnd(int beginIndex, String procedureDef, String identifierMarkers) throws SQLException {
        int openParenIndex = beginIndex;
        int closeParenIndex = beginIndex;
        boolean betweenParens = true;
        while (betweenParens && closeParenIndex < procedureDef.length()) {
            int nextClosedParenIndex = StringUtils.indexOfIgnoreCase(closeParenIndex + 1, procedureDef, ")", identifierMarkers, identifierMarkers, this.getSession().getServerSession().isNoBackslashEscapesSet() ? SearchMode.__MRK_COM_MYM_HNT_WS : SearchMode.__BSE_MRK_COM_MYM_HNT_WS);
            if (nextClosedParenIndex != -1) {
                int nextOpenParenIndex = StringUtils.indexOfIgnoreCase(openParenIndex + 1, procedureDef, "(", identifierMarkers, identifierMarkers, this.getSession().getServerSession().isNoBackslashEscapesSet() ? SearchMode.__MRK_COM_MYM_HNT_WS : SearchMode.__BSE_MRK_COM_MYM_HNT_WS);
                if (nextOpenParenIndex != -1 && nextOpenParenIndex < nextClosedParenIndex) {
                    openParenIndex = nextOpenParenIndex;
                    closeParenIndex = nextClosedParenIndex;
                    continue;
                }
                betweenParens = false;
                closeParenIndex = nextClosedParenIndex;
                continue;
            }
            throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.5"), "S1000", this.getExceptionInterceptor());
        }
        return closeParenIndex;
    }

    private int indexOfEndOfReturnsClause(String procedureDefn, int positionOfReturnKeyword, String identifierMarkers) throws SQLException {
        int i;
        String openingMarkers = identifierMarkers + "(";
        String closingMarkers = identifierMarkers + ")";
        String[] tokens = new String[]{"COMMENT", "LANGUAGE", "NOT", "DETERMINISTIC", "CONTAINS", "NO", "READS", "MODIFIES", "SQL", "BEGIN", "RETURN"};
        int startLookingAt = positionOfReturnKeyword + "RETURNS".length() + 1;
        int endOfReturn = -1;
        for (i = 0; i < tokens.length; ++i) {
            int nextEndOfReturn = StringUtils.indexOfIgnoreCase(startLookingAt, procedureDefn, tokens[i], openingMarkers, closingMarkers, this.getSession().getServerSession().isNoBackslashEscapesSet() ? SearchMode.__MRK_COM_MYM_HNT_WS : SearchMode.__BSE_MRK_COM_MYM_HNT_WS);
            if (nextEndOfReturn == -1 || endOfReturn != -1 && nextEndOfReturn >= endOfReturn) continue;
            endOfReturn = nextEndOfReturn;
        }
        if (endOfReturn != -1) {
            return endOfReturn;
        }
        endOfReturn = StringUtils.indexOfIgnoreCase(startLookingAt, procedureDefn, ":", openingMarkers, closingMarkers, this.getSession().getServerSession().isNoBackslashEscapesSet() ? SearchMode.__MRK_COM_MYM_HNT_WS : SearchMode.__BSE_MRK_COM_MYM_HNT_WS);
        if (endOfReturn != -1) {
            for (i = endOfReturn; i > startLookingAt; --i) {
                if (!Character.isWhitespace(procedureDefn.charAt(i))) continue;
                return i;
            }
        }
        throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.5"), "S1000", this.getExceptionInterceptor());
    }

    private Row typeDescriptorToStoredRoutineRow(String dbName, String routineName, String paramName, boolean isOutParam, boolean isInParam, boolean isReturnParam, TypeDescriptor typeDesc, int ordinal, StoredRoutineType targetMetaData) throws SQLException {
        byte[][] row = targetMetaData == StoredRoutineType.PROCEDURE ? new byte[20][] : new byte[17][];
        row[0] = this.chooseBasedOnDatabaseTerm(() -> this.s2b(dbName), () -> this.s2b("def"));
        row[1] = this.chooseBasedOnDatabaseTerm(() -> null, () -> this.s2b(dbName));
        row[2] = this.s2b(routineName);
        row[3] = this.s2b(paramName);
        int columnType = this.getStoredRoutineColumnType(isOutParam, isInParam, isReturnParam, targetMetaData);
        row[4] = this.n2b(columnType);
        row[5] = this.n2b(typeDesc.getJdbcType());
        row[6] = this.s2b(typeDesc.mysqlType.getName());
        row[7] = typeDesc.datetimePrecision == null ? this.n2b(typeDesc.columnSize) : this.n2b(typeDesc.datetimePrecision);
        row[8] = typeDesc.columnSize == null ? null : this.n2b(typeDesc.columnSize);
        row[9] = typeDesc.decimalDigits == null ? null : this.n2b(typeDesc.decimalDigits);
        row[10] = this.n2b(typeDesc.numPrecRadix);
        switch (typeDesc.nullability) {
            case 0: {
                row[11] = this.n2b(targetMetaData == StoredRoutineType.PROCEDURE ? 0 : 0);
                break;
            }
            case 1: {
                row[11] = this.n2b(targetMetaData == StoredRoutineType.PROCEDURE ? 1 : 1);
                break;
            }
            case 2: {
                row[11] = this.n2b(targetMetaData == StoredRoutineType.PROCEDURE ? 2 : 2);
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.1"), "S1000", this.getExceptionInterceptor());
            }
        }
        row[12] = null;
        if (targetMetaData == StoredRoutineType.PROCEDURE) {
            row[13] = null;
            row[14] = null;
            row[15] = null;
            row[16] = typeDesc.charOctetLength == null ? null : this.n2b(typeDesc.charOctetLength);
            row[17] = this.n2b(ordinal);
            row[18] = this.s2b(typeDesc.isNullable);
            row[19] = this.s2b(routineName);
        } else {
            row[13] = typeDesc.charOctetLength == null ? null : this.n2b(typeDesc.charOctetLength);
            row[14] = this.n2b(ordinal);
            row[15] = this.s2b(typeDesc.isNullable);
            row[16] = this.s2b(routineName);
        }
        return new ByteArrayRow(row, this.getExceptionInterceptor());
    }

    private int getStoredRoutineColumnType(boolean isOutParam, boolean isInParam, boolean isReturnParam, StoredRoutineType targetMetaData) {
        if (isInParam && isOutParam) {
            return targetMetaData == StoredRoutineType.PROCEDURE ? 2 : 2;
        }
        if (isInParam) {
            return targetMetaData == StoredRoutineType.PROCEDURE ? 1 : 1;
        }
        if (isOutParam) {
            return targetMetaData == StoredRoutineType.PROCEDURE ? 4 : 3;
        }
        if (isReturnParam) {
            return targetMetaData == StoredRoutineType.PROCEDURE ? 5 : 4;
        }
        return targetMetaData == StoredRoutineType.PROCEDURE ? 0 : 0;
    }

    private List<String> getDatabases() throws SQLException {
        return this.getDatabasesByPattern(null);
    }

    private List<String> getDatabasesByPattern(String dbPattern) throws SQLException {
        String dbFilter = this.normalizeIdentifierQuoting(dbPattern);
        String query = dbFilter == null ? "SHOW DATABASES" : "SHOW DATABASES LIKE ?";
        try (PreparedStatement pStmt = this.prepareMetaDataSafeStatement(query);){
            if (dbFilter != null) {
                pStmt.setString(1, dbFilter);
            }
            ResultSet rs = pStmt.executeQuery();
            ArrayList<String> dbList = new ArrayList<String>();
            while (rs.next()) {
                dbList.add(rs.getString(1));
            }
            Collections.sort(dbList);
            ArrayList<String> arrayList = dbList;
            return arrayList;
        }
    }

    private List<String> getDatabasesByLiteral(String dbName) throws SQLException {
        String dbFilter = this.normalizeIdentifierCase(this.normalizeIdentifierQuoting(dbName));
        return dbFilter == null ? this.getDatabases() : Collections.singletonList(dbFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        try {
            if (table == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            String dbFilter = this.chooseDatabaseTerm(catalog, schema);
            String tableFilter = this.normalizeIdentifierQuoting(table);
            ArrayList<ByteArrayRow> rows = new ArrayList<ByteArrayRow>();
            try (Statement stmt = this.getJdbcConnection().getMetaDataSafeStatement();){
                List<String> dbList = this.getDatabasesByLiteral(dbFilter);
                for (String db : dbList) {
                    ResultSet rs = null;
                    try {
                        StringBuilder query = new StringBuilder("SHOW COLUMNS FROM ");
                        query.append(this.quoteIdentifier(tableFilter));
                        query.append(" FROM ");
                        query.append(this.quoteIdentifier(db));
                        rs = stmt.executeQuery(query.toString());
                        while (rs.next()) {
                            String keyType = rs.getString("Key");
                            if (keyType == null || !StringUtils.startsWithIgnoreCase(keyType, "PRI")) continue;
                            byte[][] row = new byte[8][];
                            row[0] = this.n2b(2);
                            row[1] = rs.getBytes("Field");
                            TypeDescriptor typeDesc = new TypeDescriptor(rs.getString("Type"), rs.getString("Null"));
                            row[2] = this.n2b(typeDesc.getJdbcType());
                            row[3] = this.s2b(typeDesc.mysqlType.getName());
                            row[4] = this.n2b(typeDesc.columnSize);
                            row[5] = this.n2b(MAX_BUFFER_SIZE);
                            row[6] = typeDesc.decimalDigits == null ? null : this.n2b(typeDesc.decimalDigits);
                            row[7] = this.n2b(1);
                            rows.add(new ByteArrayRow(row, this.getExceptionInterceptor()));
                        }
                    }
                    catch (SQLException e) {
                        String sqlState = e.getSQLState();
                        int errorCode = e.getErrorCode();
                        if ("42S02".equals(sqlState) && (errorCode == 1146 || errorCode == 1109) || "42000".equals(sqlState) && errorCode == 1049) continue;
                        throw e;
                    }
                    finally {
                        if (rs == null) continue;
                        try {
                            rs.close();
                        }
                        catch (SQLException e) {
                            AssertionFailedException.shouldNotHappen(e);
                        }
                        rs = null;
                    }
                }
            }
            return this.getResultSetFactory().createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(this.createBestRowIdentifierFields())));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        try {
            List dbList = this.chooseBasedOnDatabaseTerm(this::getDatabases, Collections::emptyList);
            ArrayList<ByteArrayRow> rows = new ArrayList<ByteArrayRow>(dbList.size());
            for (String db : dbList) {
                byte[][] row = new byte[][]{this.s2b(db)};
                rows.add(new ByteArrayRow(row, this.getExceptionInterceptor()));
            }
            return this.getResultSetFactory().createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(this.createCatalogsFields())));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        try {
            String dbFromTerm = this.chooseDatabaseTerm(catalog, schema);
            String dbFilter = this.normalizeIdentifierQuoting(dbFromTerm);
            String tableFilter = this.normalizeIdentifierQuoting(table);
            String columnNameFilter = this.normalizeIdentifierQuoting(columnNamePattern);
            StringBuilder query = new StringBuilder("SELECT c.host, c.db, t.grantor, c.user, c.table_name, c.column_name, c.column_priv");
            query.append(" FROM mysql.columns_priv c, mysql.tables_priv t");
            query.append(" WHERE c.host = t.host AND c.db = t.db AND c.table_name = t.table_name");
            if (dbFilter != null) {
                query.append(" AND c.db = ?");
            }
            query.append(" AND c.table_name = ?");
            if (columnNameFilter != null) {
                query.append(" AND c.column_name LIKE ?");
            }
            ArrayList<ByteArrayRow> rows = new ArrayList<ByteArrayRow>();
            try (PreparedStatement pStmt = this.prepareMetaDataSafeStatement(query.toString());){
                int nextIdx = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextIdx++, this.storesLowerCaseIdentifiers() ? dbFilter.toLowerCase(Locale.ROOT) : dbFilter);
                }
                pStmt.setString(nextIdx++, this.storesLowerCaseIdentifiers() ? tableFilter.toLowerCase(Locale.ROOT) : tableFilter);
                if (columnNameFilter != null) {
                    pStmt.setString(nextIdx, columnNameFilter);
                }
                ResultSet rs = null;
                try {
                    rs = pStmt.executeQuery();
                    while (rs.next()) {
                        String host = rs.getString(1);
                        String db = rs.getString(2);
                        String grantor = rs.getString(3);
                        String user = rs.getString(4);
                        if (user == null || user.length() == 0) {
                            user = "%";
                        }
                        StringBuilder fullUser = new StringBuilder(user);
                        if (host != null && this.useHostsInPrivilegesValue().booleanValue()) {
                            fullUser.append("@");
                            fullUser.append(host);
                        }
                        String tableName = rs.getString(5);
                        String columnName = rs.getString(6);
                        String allPrivileges = rs.getString(7);
                        if (allPrivileges == null) continue;
                        allPrivileges = allPrivileges.toUpperCase(Locale.ROOT);
                        StringTokenizer st = new StringTokenizer(allPrivileges, ",");
                        while (st.hasMoreTokens()) {
                            String privilege = st.nextToken().trim();
                            byte[][] row = new byte[][]{this.chooseBasedOnDatabaseTerm(() -> this.s2b(db), () -> this.s2b("def")), this.chooseBasedOnDatabaseTerm(() -> null, () -> this.s2b(db)), this.s2b(tableName), this.s2b(columnName), this.s2b(grantor), this.s2b(fullUser.toString()), this.s2b(privilege), null};
                            rows.add(new ByteArrayRow(row, this.getExceptionInterceptor()));
                        }
                    }
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception e) {
                            AssertionFailedException.shouldNotHappen(e);
                        }
                        rs = null;
                    }
                }
            }
            return this.getResultSetFactory().createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(this.createColumnPrivilegesFields())));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            String columnNameFilter = this.normalizeIdentifierQuoting(columnNamePattern);
            ArrayList<ByteArrayRow> rows = new ArrayList<ByteArrayRow>();
            try (Statement stmt = this.getJdbcConnection().getMetaDataSafeStatement();){
                TreeMap<String, ArrayList<String>> tableNamesPerDb = new TreeMap<String, ArrayList<String>>();
                ResultSet tables = null;
                try {
                    tables = this.getTables(catalog, schemaPattern, tableNamePattern, null);
                    while (tables.next()) {
                        String db = tables.getString(this.chooseBasedOnDatabaseTerm(() -> "TABLE_CAT", () -> "TABLE_SCHEM"));
                        ArrayList<String> tableNames = (ArrayList<String>)tableNamesPerDb.get(db);
                        if (tableNames == null) {
                            tableNames = new ArrayList<String>();
                        }
                        tableNames.add(tables.getString("TABLE_NAME"));
                        tableNamesPerDb.put(db, tableNames);
                    }
                }
                finally {
                    if (tables != null) {
                        try {
                            tables.close();
                        }
                        catch (Exception sqlEx) {
                            AssertionFailedException.shouldNotHappen(sqlEx);
                        }
                        tables = null;
                    }
                }
                for (String dbName : tableNamesPerDb.keySet()) {
                    for (String tableName : (List)tableNamesPerDb.get(dbName)) {
                        ResultSet rs = null;
                        try {
                            StringBuilder query = new StringBuilder("SHOW FULL COLUMNS FROM ");
                            query.append(StringUtils.quoteIdentifier(tableName, this.getQuoteId(), true));
                            query.append(" FROM ");
                            query.append(StringUtils.quoteIdentifier(dbName, this.getQuoteId(), true));
                            boolean fixUpOrdinalsRequired = false;
                            HashMap<String, Integer> ordinalFixUpMap = null;
                            if (columnNameFilter != null && !columnNameFilter.equals("%")) {
                                fixUpOrdinalsRequired = true;
                                ordinalFixUpMap = new HashMap<String, Integer>();
                                rs = stmt.executeQuery(query.toString());
                                int ordinalPos = 1;
                                while (rs.next()) {
                                    String columnName = rs.getString("Field");
                                    ordinalFixUpMap.put(columnName, ordinalPos++);
                                }
                                rs.close();
                            }
                            if (columnNameFilter != null) {
                                query.append(" LIKE ");
                                query.append(StringUtils.quoteIdentifier(columnNameFilter, "'", true));
                            }
                            rs = stmt.executeQuery(query.toString());
                            int ordPos = 1;
                            while (rs.next()) {
                                TypeDescriptor typeDesc = new TypeDescriptor(rs.getString("Type"), rs.getString("Null"));
                                byte[][] row = new byte[24][];
                                row[0] = this.chooseBasedOnDatabaseTerm(() -> this.s2b(dbName), () -> this.s2b("def"));
                                row[1] = this.chooseBasedOnDatabaseTerm(() -> null, () -> this.s2b(dbName));
                                row[2] = this.s2b(tableName);
                                row[3] = rs.getBytes("Field");
                                row[4] = this.n2b(typeDesc.getJdbcType());
                                row[5] = this.s2b(typeDesc.mysqlType.getName());
                                if (typeDesc.columnSize == null) {
                                    row[6] = null;
                                } else {
                                    String collation = rs.getString("Collation");
                                    int mbminlen = 1;
                                    if (collation != null) {
                                        if (collation.indexOf("ucs2") > -1 || collation.indexOf("utf16") > -1) {
                                            mbminlen = 2;
                                        } else if (collation.indexOf("utf32") > -1) {
                                            mbminlen = 4;
                                        }
                                    }
                                    row[6] = mbminlen == 1 ? this.n2b(typeDesc.columnSize) : this.n2b(typeDesc.columnSize / mbminlen);
                                }
                                row[7] = this.n2b(typeDesc.bufferLength);
                                row[8] = typeDesc.decimalDigits == null ? null : this.n2b(typeDesc.decimalDigits);
                                row[9] = this.n2b(typeDesc.numPrecRadix);
                                row[10] = this.n2b(typeDesc.nullability);
                                row[11] = rs.getBytes("Comment");
                                row[12] = rs.getBytes("Default");
                                row[13] = new byte[]{48};
                                row[14] = new byte[]{48};
                                row[15] = (byte[])(StringUtils.indexOfIgnoreCase(typeDesc.mysqlType.getName(), "CHAR") != -1 || StringUtils.indexOfIgnoreCase(typeDesc.mysqlType.getName(), "BLOB") != -1 || StringUtils.indexOfIgnoreCase(typeDesc.mysqlType.getName(), "TEXT") != -1 || StringUtils.indexOfIgnoreCase(typeDesc.mysqlType.getName(), "ENUM") != -1 || StringUtils.indexOfIgnoreCase(typeDesc.mysqlType.getName(), "SET") != -1 || StringUtils.indexOfIgnoreCase(typeDesc.mysqlType.getName(), "BINARY") != -1 ? row[6] : null);
                                if (!fixUpOrdinalsRequired) {
                                    row[16] = this.n2b(ordPos++);
                                } else {
                                    String origColName = rs.getString("Field");
                                    Integer realOrdinal = (Integer)ordinalFixUpMap.get(origColName);
                                    if (realOrdinal != null) {
                                        row[16] = this.n2b(realOrdinal);
                                    } else {
                                        throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.10"), "S1000", this.getExceptionInterceptor());
                                    }
                                }
                                row[17] = this.s2b(typeDesc.isNullable);
                                row[18] = null;
                                row[19] = null;
                                row[20] = null;
                                row[21] = null;
                                String extra = rs.getString("Extra");
                                if (extra != null) {
                                    row[22] = this.s2b(StringUtils.indexOfIgnoreCase(extra, "auto_increment") != -1 ? "YES" : "NO");
                                    row[23] = this.s2b(StringUtils.indexOfIgnoreCase(extra, "generated") != -1 ? "YES" : "NO");
                                } else {
                                    row[22] = this.s2b("");
                                    row[23] = this.s2b("");
                                }
                                rows.add(new ByteArrayRow(row, this.getExceptionInterceptor()));
                            }
                        }
                        finally {
                            if (rs == null) continue;
                            try {
                                rs.close();
                            }
                            catch (Exception exception) {}
                            rs = null;
                        }
                    }
                }
            }
            return this.getResultSetFactory().createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(this.createColumnsFields())));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        try {
            if (parentTable == null || foreignTable == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            String parentDbFromTerm = this.chooseDatabaseTerm(parentCatalog, parentSchema);
            String parentDbFilter = this.normalizeIdentifierQuoting(parentDbFromTerm);
            String parentTableFilter = this.normalizeIdentifierQuoting(parentTable);
            String foreignDbFilter = this.chooseDatabaseTerm(foreignCatalog, foreignSchema);
            String foreignTableFilter = this.normalizeIdentifierQuoting(foreignTable);
            String parentDatabaseName = parentDbFilter == null && this.nullDatabaseMeansCurrentValue() != false ? this.getDatabase() : this.normalizeIdentifierCase(parentDbFilter);
            String parentTableName = this.normalizeIdentifierCase(parentTableFilter);
            ArrayList<ByteArrayRow> rows = new ArrayList<ByteArrayRow>();
            try (Statement stmt = this.getJdbcConnection().getMetaDataSafeStatement();){
                List<String> dbList = this.getDatabasesByLiteral(foreignDbFilter);
                for (String db : dbList) {
                    List<ForeignKeyConstraintInfo> foreignKeys = this.extractForeignKeysForTable(db, this.normalizeIdentifierCase(foreignTableFilter));
                    for (ForeignKeyConstraintInfo foreignKey : foreignKeys) {
                        if (!foreignKey.referencingTable.contentEquals(this.normalizeIdentifierCase(foreignTableFilter)) || !foreignKey.referencedTable.contentEquals(parentTableName) || parentDatabaseName != null && !foreignKey.referencedDatabase.contentEquals(parentDatabaseName)) continue;
                        int keySeq = 1;
                        Iterator<String> referencingColumns = foreignKey.referencingColumnsList.iterator();
                        Iterator<String> referencedColumns = foreignKey.referencedColumnsList.iterator();
                        while (referencingColumns.hasNext()) {
                            byte[][] row = new byte[][]{this.chooseBasedOnDatabaseTerm(() -> this.s2b(foreignKey.referencedDatabase), () -> this.s2b("def")), this.chooseBasedOnDatabaseTerm(() -> null, () -> this.s2b(foreignKey.referencedDatabase)), this.s2b(foreignKey.referencedTable), this.s2b(StringUtils.unquoteIdentifier(referencedColumns.next(), this.getQuoteId())), this.chooseBasedOnDatabaseTerm(() -> this.s2b(foreignKey.referencingDatabase), () -> this.s2b("def")), this.chooseBasedOnDatabaseTerm(() -> null, () -> this.s2b(foreignKey.referencingDatabase)), this.s2b(foreignKey.referencingTable), this.s2b(StringUtils.unquoteIdentifier(referencingColumns.next(), this.getQuoteId())), this.n2b(keySeq++), this.n2b(foreignKey.referentialActionOnUpdate), this.n2b(foreignKey.referentialActionOnDelete), this.s2b(foreignKey.constraintName), null, this.n2b(7)};
                            rows.add(new ByteArrayRow(row, this.getExceptionInterceptor()));
                        }
                    }
                }
            }
            return this.getResultSetFactory().createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(this.createForeignKeysFields())));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            if (table == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            String dbFromTerm = this.chooseDatabaseTerm(catalog, schema);
            String dbFilter = this.normalizeIdentifierQuoting(dbFromTerm);
            String tableFilter = this.normalizeIdentifierQuoting(table);
            String parentDatabase = dbFilter == null && this.nullDatabaseMeansCurrentValue() != false ? this.getDatabase() : this.normalizeIdentifierCase(dbFilter);
            String parentTable = this.normalizeIdentifierCase(tableFilter);
            ArrayList<ByteArrayRow> rows = new ArrayList<ByteArrayRow>();
            try (Statement stmt = this.getJdbcConnection().getMetaDataSafeStatement();){
                List<String> dbList = this.getDatabases();
                for (String db : dbList) {
                    List<ForeignKeyConstraintInfo> foreignKeys = this.extractForeignKeysForTable(db, null);
                    for (ForeignKeyConstraintInfo foreignKey : foreignKeys) {
                        if (!foreignKey.referencedTable.contentEquals(parentTable) || parentDatabase != null && !foreignKey.referencedDatabase.contentEquals(parentDatabase)) continue;
                        int keySeq = 1;
                        Iterator<String> referencingColumns = foreignKey.referencingColumnsList.iterator();
                        Iterator<String> referencedColumns = foreignKey.referencedColumnsList.iterator();
                        while (referencingColumns.hasNext()) {
                            byte[][] row = new byte[][]{this.chooseBasedOnDatabaseTerm(() -> this.s2b(foreignKey.referencedDatabase), () -> this.s2b("def")), this.chooseBasedOnDatabaseTerm(() -> null, () -> this.s2b(foreignKey.referencedDatabase)), this.s2b(foreignKey.referencedTable), this.s2b(StringUtils.unquoteIdentifier(referencedColumns.next(), this.getQuoteId())), this.chooseBasedOnDatabaseTerm(() -> this.s2b(foreignKey.referencingDatabase), () -> this.s2b("def")), this.chooseBasedOnDatabaseTerm(() -> null, () -> this.s2b(foreignKey.referencingDatabase)), this.s2b(foreignKey.referencingTable), this.s2b(StringUtils.unquoteIdentifier(referencingColumns.next(), this.getQuoteId())), this.n2b(keySeq++), this.n2b(foreignKey.referentialActionOnUpdate), this.n2b(foreignKey.referentialActionOnDelete), this.s2b(foreignKey.constraintName), null, this.n2b(7)};
                            rows.add(new ByteArrayRow(row, this.getExceptionInterceptor()));
                        }
                    }
                }
            }
            return this.getResultSetFactory().createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(this.createForeignKeysFields())));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        try {
            return this.getStoredRoutineColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern, StoredRoutineType.FUNCTION);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        try {
            return this.getStoredRoutines(catalog, schemaPattern, functionNamePattern, StoredRoutineType.FUNCTION);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            if (table == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            String dbFilter = this.chooseDatabaseTerm(catalog, schema);
            String tableFilter = this.normalizeIdentifierQuoting(table);
            ArrayList<ByteArrayRow> rows = new ArrayList<ByteArrayRow>();
            try (Statement stmt = this.getJdbcConnection().getMetaDataSafeStatement();){
                List<String> dbList = this.getDatabasesByLiteral(dbFilter);
                for (String db : dbList) {
                    List<ForeignKeyConstraintInfo> foreignKeys = this.extractForeignKeysForTable(db, this.normalizeIdentifierCase(tableFilter));
                    for (ForeignKeyConstraintInfo foreignKey : foreignKeys) {
                        int keySeq = 1;
                        Iterator<String> referencingColumns = foreignKey.referencingColumnsList.iterator();
                        Iterator<String> referencedColumns = foreignKey.referencedColumnsList.iterator();
                        while (referencingColumns.hasNext()) {
                            byte[][] row = new byte[][]{this.chooseBasedOnDatabaseTerm(() -> this.s2b(foreignKey.referencedDatabase), () -> this.s2b("def")), this.chooseBasedOnDatabaseTerm(() -> null, () -> this.s2b(foreignKey.referencedDatabase)), this.s2b(foreignKey.referencedTable), this.s2b(StringUtils.unquoteIdentifier(referencedColumns.next(), this.getQuoteId())), this.chooseBasedOnDatabaseTerm(() -> this.s2b(foreignKey.referencingDatabase), () -> this.s2b("def")), this.chooseBasedOnDatabaseTerm(() -> null, () -> this.s2b(foreignKey.referencingDatabase)), this.s2b(foreignKey.referencingTable), this.s2b(StringUtils.unquoteIdentifier(referencingColumns.next(), this.getQuoteId())), this.n2b(keySeq++), this.n2b(foreignKey.referentialActionOnUpdate), this.n2b(foreignKey.referentialActionOnDelete), this.s2b(foreignKey.constraintName), null, this.n2b(7)};
                            rows.add(new ByteArrayRow(row, this.getExceptionInterceptor()));
                        }
                    }
                }
            }
            return this.getResultSetFactory().createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(this.createForeignKeysFields())));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        try {
            if (table == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            String dbFilter = this.chooseDatabaseTerm(catalog, schema);
            String tableFilter = this.normalizeIdentifierQuoting(table);
            TreeMap<MultiComparable, ByteArrayRow> sortedRows = new TreeMap<MultiComparable, ByteArrayRow>();
            try (Statement stmt = this.getJdbcConnection().getMetaDataSafeStatement();){
                List<String> dbList = this.getDatabasesByLiteral(dbFilter);
                for (String db : dbList) {
                    ResultSet rs = null;
                    try {
                        StringBuilder query = new StringBuilder("SHOW INDEX FROM ");
                        query.append(StringUtils.quoteIdentifier(tableFilter, this.getQuoteId(), this.pedanticValue()));
                        query.append(" FROM ");
                        query.append(StringUtils.quoteIdentifier(db, this.getQuoteId(), true));
                        rs = stmt.executeQuery(query.toString());
                        while (rs.next()) {
                            byte[][] row = new byte[14][];
                            row[0] = this.chooseBasedOnDatabaseTerm(() -> this.s2b(db), () -> this.s2b("def"));
                            row[1] = this.chooseBasedOnDatabaseTerm(() -> null, () -> this.s2b(db));
                            row[2] = rs.getBytes("Table");
                            boolean indexIsUnique = rs.getInt("Non_unique") == 0;
                            row[3] = !indexIsUnique ? this.s2b("true") : this.s2b("false");
                            row[4] = null;
                            row[5] = rs.getBytes("Key_name");
                            short indexType = 3;
                            row[6] = this.n2b(indexType);
                            row[7] = rs.getBytes("Seq_in_index");
                            row[8] = rs.getBytes("Column_name");
                            row[9] = rs.getBytes("Collation");
                            row[10] = this.n2b(rs.getLong("Cardinality"));
                            row[11] = this.s2b("0");
                            row[12] = null;
                            MultiComparable indexInfoKey = new MultiComparable(new Comparable[]{Boolean.valueOf(!indexIsUnique), Short.valueOf(indexType), rs.getString("Key_name").toLowerCase(Locale.ROOT), Short.valueOf(rs.getShort("Seq_in_index"))});
                            if (unique) {
                                if (!indexIsUnique) continue;
                                sortedRows.put(indexInfoKey, new ByteArrayRow(row, this.getExceptionInterceptor()));
                                continue;
                            }
                            sortedRows.put(indexInfoKey, new ByteArrayRow(row, this.getExceptionInterceptor()));
                        }
                    }
                    catch (SQLException e) {
                        String sqlState = e.getSQLState();
                        int errorCode = e.getErrorCode();
                        if ("42S02".equals(sqlState) && (errorCode == 1146 || errorCode == 1109) || "42000".equals(sqlState) && errorCode == 1049) continue;
                        throw e;
                    }
                    finally {
                        if (rs == null) continue;
                        try {
                            rs.close();
                        }
                        catch (Exception exception) {}
                        rs = null;
                    }
                }
            }
            ArrayList rows = new ArrayList(sortedRows.values());
            return this.getResultSetFactory().createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(this.createIndexInfoFields())));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        try {
            if (table == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            String dbFilter = this.chooseDatabaseTerm(catalog, schema);
            String tableFilter = this.normalizeIdentifierQuoting(table);
            TreeMap<String, ByteArrayRow> sortedRows = new TreeMap<String, ByteArrayRow>(String.CASE_INSENSITIVE_ORDER);
            try (Statement stmt = this.getJdbcConnection().getMetaDataSafeStatement();){
                List<String> dbList = this.getDatabasesByLiteral(dbFilter);
                for (String db : dbList) {
                    ResultSet rs = null;
                    try {
                        StringBuilder query = new StringBuilder("SHOW KEYS FROM ");
                        query.append(StringUtils.quoteIdentifier(tableFilter, this.getQuoteId(), true));
                        query.append(" FROM ");
                        query.append(StringUtils.quoteIdentifier(db, this.getQuoteId(), true));
                        rs = stmt.executeQuery(query.toString());
                        while (rs.next()) {
                            String keyType = rs.getString("Key_name");
                            if (keyType == null || !keyType.equalsIgnoreCase("PRIMARY") && !keyType.equalsIgnoreCase("PRI")) continue;
                            byte[][] row = new byte[6][];
                            row[0] = this.chooseBasedOnDatabaseTerm(() -> this.s2b(db), () -> this.s2b("def"));
                            row[1] = this.chooseBasedOnDatabaseTerm(() -> null, () -> this.s2b(db));
                            row[2] = this.s2b(rs.getString("Table"));
                            String columnName = rs.getString("Column_name");
                            row[3] = this.s2b(columnName);
                            row[4] = this.s2b(rs.getString("Seq_in_index"));
                            row[5] = this.s2b(keyType);
                            sortedRows.put(columnName, new ByteArrayRow(row, this.getExceptionInterceptor()));
                        }
                    }
                    catch (SQLException e) {
                        String sqlState = e.getSQLState();
                        int errorCode = e.getErrorCode();
                        if ("42S02".equals(sqlState) && (errorCode == 1146 || errorCode == 1109) || "42000".equals(sqlState) && errorCode == 1049) continue;
                        throw e;
                    }
                    finally {
                        if (rs == null) continue;
                        try {
                            rs.close();
                        }
                        catch (Exception exception) {}
                        rs = null;
                    }
                }
            }
            ArrayList rows = new ArrayList(sortedRows.values());
            return this.getResultSetFactory().createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(this.createPrimaryKeysFields())));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        try {
            return this.getStoredRoutineColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern, StoredRoutineType.PROCEDURE);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        try {
            return this.getStoredRoutines(catalog, schemaPattern, procedureNamePattern, StoredRoutineType.PROCEDURE);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        try {
            List dbList = this.chooseBasedOnDatabaseTerm(Collections::emptyList, () -> this.getDatabasesByPattern(schemaPattern));
            ArrayList<ByteArrayRow> rows = new ArrayList<ByteArrayRow>(dbList.size());
            for (String db : dbList) {
                byte[][] row = new byte[][]{this.s2b(db), this.s2b("def")};
                rows.add(new ByteArrayRow(row, this.getExceptionInterceptor()));
            }
            return this.getResultSetFactory().createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(this.createSchemasFields())));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            String dbFromTerm = this.chooseDatabaseTerm(catalog, schemaPattern);
            String dbFilter = this.normalizeIdentifierQuoting(dbFromTerm);
            String tableNameFilter = this.normalizeIdentifierQuoting(tableNamePattern);
            StringBuilder query = new StringBuilder("SELECT host, db, table_name, grantor, user, table_priv FROM mysql.tables_priv");
            StringBuilder condition = new StringBuilder();
            if (dbFilter != null) {
                condition.append(this.chooseBasedOnDatabaseTerm(() -> " db = ?", () -> " db LIKE ?"));
            }
            if (tableNameFilter != null) {
                if (condition.length() > 0) {
                    condition.append(" AND");
                }
                condition.append(" table_name LIKE ?");
            }
            if (condition.length() > 0) {
                query.append(" WHERE");
                query.append((CharSequence)condition);
            }
            ResultSet rs = null;
            ArrayList<ByteArrayRow> rows = new ArrayList<ByteArrayRow>();
            try (PreparedStatement pStmt = this.prepareMetaDataSafeStatement(query.toString());){
                int nextIdx = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextIdx++, this.storesLowerCaseIdentifiers() ? dbFilter.toLowerCase(Locale.ROOT) : dbFilter);
                }
                if (tableNameFilter != null) {
                    pStmt.setString(nextIdx, this.storesLowerCaseIdentifiers() ? tableNameFilter.toLowerCase(Locale.ROOT) : tableNameFilter);
                }
                try {
                    rs = pStmt.executeQuery();
                    while (rs.next()) {
                        String allPrivileges;
                        String host = rs.getString(1);
                        String db = rs.getString(2);
                        String table = rs.getString(3);
                        String grantor = rs.getString(4);
                        String user = rs.getString(5);
                        if (user == null || user.length() == 0) {
                            user = "%";
                        }
                        StringBuilder fullUser = new StringBuilder(user);
                        if (host != null && this.useHostsInPrivilegesValue().booleanValue()) {
                            fullUser.append("@");
                            fullUser.append(host);
                        }
                        if ((allPrivileges = rs.getString(6)) == null) continue;
                        allPrivileges = allPrivileges.toUpperCase(Locale.ENGLISH);
                        StringTokenizer st = new StringTokenizer(allPrivileges, ",");
                        while (st.hasMoreTokens()) {
                            String privilege = st.nextToken().trim();
                            ResultSet columnRs = null;
                            try {
                                columnRs = this.getColumns(catalog, schemaPattern, StringUtils.quoteIdentifier(table, this.getQuoteId(), this.pedanticValue() == false), null);
                                while (columnRs.next()) {
                                    byte[][] row = new byte[8][];
                                    row[0] = this.chooseBasedOnDatabaseTerm(() -> this.s2b(db), () -> this.s2b("def"));
                                    row[1] = this.chooseBasedOnDatabaseTerm(() -> null, () -> this.s2b(db));
                                    row[2] = this.s2b(table);
                                    row[3] = grantor != null ? this.s2b(grantor) : null;
                                    row[4] = this.s2b(fullUser.toString());
                                    row[5] = this.s2b(privilege);
                                    row[6] = null;
                                    rows.add(new ByteArrayRow(row, this.getExceptionInterceptor()));
                                }
                            }
                            finally {
                                if (columnRs == null) continue;
                                try {
                                    columnRs.close();
                                }
                                catch (Exception e) {
                                    AssertionFailedException.shouldNotHappen(e);
                                }
                                columnRs = null;
                            }
                        }
                    }
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception e) {
                            AssertionFailedException.shouldNotHappen(e);
                        }
                        rs = null;
                    }
                }
            }
            return this.getResultSetFactory().createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(this.createTablePrivilegesFields())));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        try {
            String dbFilter = this.chooseDatabaseTerm(catalog, schemaPattern);
            String tableNameFilter = this.normalizeIdentifierQuoting(tableNamePattern);
            TreeMap<MultiComparable, ByteArrayRow> sortedRows = new TreeMap<MultiComparable, ByteArrayRow>();
            try (Statement stmt = this.getJdbcConnection().getMetaDataSafeStatement();){
                List dbList = this.chooseBasedOnDatabaseTerm(() -> this.getDatabasesByLiteral(dbFilter), () -> this.getDatabasesByPattern(dbFilter));
                for (String db : dbList) {
                    boolean operatingOnSystemDB = "information_schema".equalsIgnoreCase(db) || "mysql".equalsIgnoreCase(db) || "performance_schema".equalsIgnoreCase(db) || "sys".equalsIgnoreCase(db);
                    ResultSet rs = null;
                    try {
                        StringBuilder query = new StringBuilder("SHOW FULL TABLES FROM ");
                        query.append(StringUtils.quoteIdentifier(db, this.getQuoteId(), true));
                        if (tableNameFilter != null) {
                            query.append(" LIKE ");
                            query.append(StringUtils.quoteIdentifier(tableNameFilter, "'", true));
                        }
                        rs = stmt.executeQuery(query.toString());
                        boolean shouldReportTables = false;
                        boolean shouldReportViews = false;
                        boolean shouldReportSystemTables = false;
                        boolean shouldReportSystemViews = false;
                        boolean shouldReportLocalTemporaries = false;
                        if (types == null || types.length == 0) {
                            shouldReportTables = true;
                            shouldReportViews = true;
                            shouldReportSystemTables = true;
                            shouldReportSystemViews = true;
                            shouldReportLocalTemporaries = true;
                        } else {
                            for (String type : types) {
                                if (DatabaseMetaData.TableType.TABLE.equalsTo(type)) {
                                    shouldReportTables = true;
                                    continue;
                                }
                                if (DatabaseMetaData.TableType.VIEW.equalsTo(type)) {
                                    shouldReportViews = true;
                                    continue;
                                }
                                if (DatabaseMetaData.TableType.SYSTEM_TABLE.equalsTo(type)) {
                                    shouldReportSystemTables = true;
                                    continue;
                                }
                                if (DatabaseMetaData.TableType.SYSTEM_VIEW.equalsTo(type)) {
                                    shouldReportSystemViews = true;
                                    continue;
                                }
                                if (!DatabaseMetaData.TableType.LOCAL_TEMPORARY.equalsTo(type)) continue;
                                shouldReportLocalTemporaries = true;
                            }
                        }
                        while (rs.next()) {
                            boolean toAdd = false;
                            MultiComparable tableKey = null;
                            byte[][] row = new byte[10][];
                            row[0] = this.chooseBasedOnDatabaseTerm(() -> this.s2b(db), () -> this.s2b("def"));
                            row[1] = this.chooseBasedOnDatabaseTerm(() -> null, () -> this.s2b(db));
                            row[2] = rs.getBytes(1);
                            String tableType = rs.getString(2);
                            switch (DatabaseMetaData.TableType.getTableTypeCompliantWith(tableType)) {
                                case TABLE: {
                                    if (operatingOnSystemDB && shouldReportSystemTables) {
                                        row[3] = DatabaseMetaData.TableType.SYSTEM_TABLE.asBytes();
                                        tableKey = new MultiComparable(new Comparable[]{DatabaseMetaData.TableType.SYSTEM_TABLE.getName(), db, null, rs.getString(1)});
                                        toAdd = true;
                                        break;
                                    }
                                    if (operatingOnSystemDB || !shouldReportTables) break;
                                    row[3] = DatabaseMetaData.TableType.TABLE.asBytes();
                                    tableKey = new MultiComparable(new Comparable[]{DatabaseMetaData.TableType.TABLE.getName(), db, null, rs.getString(1)});
                                    toAdd = true;
                                    break;
                                }
                                case VIEW: {
                                    if (!shouldReportViews) break;
                                    row[3] = DatabaseMetaData.TableType.VIEW.asBytes();
                                    tableKey = new MultiComparable(new Comparable[]{DatabaseMetaData.TableType.VIEW.getName(), db, null, rs.getString(1)});
                                    toAdd = true;
                                    break;
                                }
                                case SYSTEM_TABLE: {
                                    if (!shouldReportSystemTables) break;
                                    row[3] = DatabaseMetaData.TableType.SYSTEM_TABLE.asBytes();
                                    tableKey = new MultiComparable(new Comparable[]{DatabaseMetaData.TableType.SYSTEM_TABLE.getName(), db, null, rs.getString(1)});
                                    toAdd = true;
                                    break;
                                }
                                case SYSTEM_VIEW: {
                                    if (!shouldReportSystemViews) break;
                                    row[3] = DatabaseMetaData.TableType.SYSTEM_VIEW.asBytes();
                                    tableKey = new MultiComparable(new Comparable[]{DatabaseMetaData.TableType.SYSTEM_VIEW.getName(), db, null, rs.getString(1)});
                                    toAdd = true;
                                    break;
                                }
                                case LOCAL_TEMPORARY: {
                                    if (!shouldReportLocalTemporaries) break;
                                    row[3] = DatabaseMetaData.TableType.LOCAL_TEMPORARY.asBytes();
                                    tableKey = new MultiComparable(new Comparable[]{DatabaseMetaData.TableType.LOCAL_TEMPORARY.getName(), db, null, rs.getString(1)});
                                    toAdd = true;
                                    break;
                                }
                                default: {
                                    row[3] = DatabaseMetaData.TableType.TABLE.asBytes();
                                    tableKey = new MultiComparable(new Comparable[]{DatabaseMetaData.TableType.TABLE.getName(), db, null, rs.getString(1)});
                                    toAdd = true;
                                }
                            }
                            row[4] = new byte[0];
                            row[5] = null;
                            row[6] = null;
                            row[7] = null;
                            row[8] = null;
                            row[9] = null;
                            if (!toAdd) continue;
                            sortedRows.put(tableKey, new ByteArrayRow(row, this.getExceptionInterceptor()));
                        }
                    }
                    catch (SQLException e) {
                        if ("08S01".equals(e.getSQLState())) {
                            throw e;
                        }
                        break;
                    }
                    finally {
                        if (rs == null) continue;
                        try {
                            rs.close();
                        }
                        catch (Exception e) {
                            AssertionFailedException.shouldNotHappen(e);
                        }
                        rs = null;
                    }
                }
            }
            ArrayList rows = new ArrayList(sortedRows.values());
            return this.getResultSetFactory().createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, this.createTablesFields()));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        try {
            if (table == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            String dbFilter = this.chooseDatabaseTerm(catalog, schema);
            String tableFilter = this.normalizeIdentifierQuoting(table);
            ArrayList<ByteArrayRow> rows = new ArrayList<ByteArrayRow>();
            try (Statement stmt = this.getJdbcConnection().getMetaDataSafeStatement();){
                List<String> dbList = this.getDatabasesByLiteral(dbFilter);
                for (String db : dbList) {
                    ResultSet rs = null;
                    try {
                        StringBuilder query = new StringBuilder("SHOW COLUMNS FROM ");
                        query.append(StringUtils.quoteIdentifier(tableFilter, this.getQuoteId(), true));
                        query.append(" FROM ");
                        query.append(StringUtils.quoteIdentifier(db, this.getQuoteId(), true));
                        query.append(" WHERE Extra LIKE '%on update CURRENT_TIMESTAMP%'");
                        rs = stmt.executeQuery(query.toString());
                        while (rs.next()) {
                            TypeDescriptor typeDesc = new TypeDescriptor(rs.getString("Type"), rs.getString("Null"));
                            byte[][] row = new byte[][]{null, rs.getBytes("Field"), this.n2b(typeDesc.getJdbcType()), this.s2b(typeDesc.mysqlType.getName()), typeDesc.columnSize == null ? null : this.n2b(typeDesc.columnSize), this.n2b(typeDesc.bufferLength), typeDesc.decimalDigits == null ? null : this.n2b(typeDesc.decimalDigits), this.n2b(1)};
                            rows.add(new ByteArrayRow(row, this.getExceptionInterceptor()));
                        }
                    }
                    catch (SQLException e) {
                        String sqlState = e.getSQLState();
                        int errorCode = e.getErrorCode();
                        if ("42S02".equals(sqlState) && (errorCode == 1146 || errorCode == 1109) || "42000".equals(sqlState) && errorCode == 1049) continue;
                        throw e;
                    }
                    finally {
                        if (rs == null) continue;
                        try {
                            rs.close();
                        }
                        catch (Exception e) {
                            AssertionFailedException.shouldNotHappen(e);
                        }
                        rs = null;
                    }
                }
            }
            return this.getResultSetFactory().createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(this.createVersionColumnsFields())));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private class ForeignKeyConstraintInfo {
        final String constraintName;
        final String referencingDatabase;
        final String referencingTable;
        final List<String> referencingColumnsList;
        final String referencedDatabase;
        final String referencedTable;
        final List<String> referencedColumnsList;
        final int referentialActionOnDelete;
        final int referentialActionOnUpdate;

        ForeignKeyConstraintInfo(String constraintName, String referencingDatabase, String referencingTable, List<String> referencingColumns, String referencedDatabase, String referencedTable, List<String> referencedColumns, int referentialActionOnDelete, int referentialActionOnUpdate) {
            this.constraintName = constraintName;
            this.referencingDatabase = referencingDatabase;
            this.referencingTable = referencingTable;
            this.referencingColumnsList = referencingColumns;
            this.referencedColumnsList = referencedColumns;
            this.referencedTable = referencedTable;
            this.referencedDatabase = referencedDatabase;
            this.referentialActionOnDelete = referentialActionOnDelete;
            this.referentialActionOnUpdate = referentialActionOnUpdate;
        }
    }

    private class MultiComparable
    implements Comparable<MultiComparable> {
        private final List<Comparable<?>> elements;

        public MultiComparable(Comparable<?> ... elements) {
            this.elements = Arrays.asList(elements);
        }

        public <T> T getElement(int index) {
            if (index < 0 || index >= this.elements.size()) {
                throw new IndexOutOfBoundsException("Index " + index + " out of bounds for size " + this.elements.size());
            }
            return (T)this.elements.get(index);
        }

        @Override
        public int compareTo(MultiComparable other) {
            int size = Math.min(this.elements.size(), other.elements.size());
            for (int i = 0; i < size; ++i) {
                Comparable<?> thisElement = this.elements.get(i);
                Comparable<?> otherElement = other.elements.get(i);
                if (thisElement == null && otherElement == null) continue;
                if (thisElement == null) {
                    return -1;
                }
                if (otherElement == null) {
                    return 1;
                }
                int result = thisElement.compareTo(otherElement);
                if (result == 0) continue;
                return result;
            }
            return Integer.compare(this.elements.size(), other.elements.size());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MultiComparable other = (MultiComparable)obj;
            return Objects.equals(this.elements, other.elements);
        }

        public int hashCode() {
            return Objects.hash(this.elements);
        }

        public String toString() {
            return this.elements.toString();
        }
    }

    private class TypeDescriptor {
        int bufferLength;
        Integer datetimePrecision = null;
        Integer columnSize = null;
        Integer charOctetLength = null;
        Integer decimalDigits = null;
        String isNullable;
        int nullability;
        int numPrecRadix = 10;
        MysqlType mysqlType;

        TypeDescriptor(String typeInfo, String nullabilityInfo) throws SQLException {
            if (typeInfo == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.0"), "S1009", DatabaseMetaDataMysqlSchema.this.getExceptionInterceptor());
            }
            this.mysqlType = MysqlType.getByName(typeInfo);
            int maxLength = 0;
            switch (this.mysqlType) {
                case ENUM: {
                    String temp = typeInfo.substring(typeInfo.indexOf("(") + 1, typeInfo.lastIndexOf(")"));
                    StringTokenizer tokenizer = new StringTokenizer(temp, ",");
                    while (tokenizer.hasMoreTokens()) {
                        String nextToken = tokenizer.nextToken();
                        maxLength = Math.max(maxLength, nextToken.length() - 2);
                    }
                    this.columnSize = maxLength;
                    break;
                }
                case SET: {
                    String temp = typeInfo.substring(typeInfo.indexOf("(") + 1, typeInfo.lastIndexOf(")"));
                    StringTokenizer tokenizer = new StringTokenizer(temp, ",");
                    int numElements = tokenizer.countTokens();
                    if (numElements > 0) {
                        maxLength += numElements - 1;
                    }
                    while (tokenizer.hasMoreTokens()) {
                        String setMember = tokenizer.nextToken().trim();
                        if (setMember.startsWith("'") && setMember.endsWith("'")) {
                            maxLength += setMember.length() - 2;
                            continue;
                        }
                        maxLength += setMember.length();
                    }
                    this.columnSize = maxLength;
                    break;
                }
                case FLOAT: 
                case FLOAT_UNSIGNED: {
                    if (typeInfo.indexOf(",") != -1) {
                        this.columnSize = Integer.valueOf(typeInfo.substring(typeInfo.indexOf("(") + 1, typeInfo.indexOf(",")).trim());
                        this.decimalDigits = Integer.valueOf(typeInfo.substring(typeInfo.indexOf(",") + 1, typeInfo.indexOf(")")).trim());
                        break;
                    }
                    if (typeInfo.indexOf("(") != -1) {
                        int size = Integer.parseInt(typeInfo.substring(typeInfo.indexOf("(") + 1, typeInfo.indexOf(")")).trim());
                        if (size <= 23) break;
                        this.mysqlType = this.mysqlType == MysqlType.FLOAT ? MysqlType.DOUBLE : MysqlType.DOUBLE_UNSIGNED;
                        this.columnSize = 22;
                        this.decimalDigits = 0;
                        break;
                    }
                    this.columnSize = 12;
                    this.decimalDigits = 0;
                    break;
                }
                case DECIMAL: 
                case DECIMAL_UNSIGNED: 
                case DOUBLE: 
                case DOUBLE_UNSIGNED: {
                    if (typeInfo.indexOf(",") != -1) {
                        this.columnSize = Integer.valueOf(typeInfo.substring(typeInfo.indexOf("(") + 1, typeInfo.indexOf(",")).trim());
                        this.decimalDigits = Integer.valueOf(typeInfo.substring(typeInfo.indexOf(",") + 1, typeInfo.indexOf(")")).trim());
                        break;
                    }
                    switch (this.mysqlType) {
                        case DECIMAL: 
                        case DECIMAL_UNSIGNED: {
                            this.columnSize = 65;
                            break;
                        }
                        case DOUBLE: 
                        case DOUBLE_UNSIGNED: {
                            this.columnSize = 22;
                            break;
                        }
                    }
                    this.decimalDigits = 0;
                    break;
                }
                case CHAR: 
                case VARCHAR: 
                case TINYTEXT: 
                case MEDIUMTEXT: 
                case LONGTEXT: 
                case JSON: 
                case TEXT: 
                case TINYBLOB: 
                case MEDIUMBLOB: 
                case LONGBLOB: 
                case BLOB: 
                case BINARY: 
                case VARBINARY: 
                case BIT: {
                    if (this.mysqlType == MysqlType.CHAR) {
                        this.columnSize = 1;
                    }
                    if (typeInfo.indexOf("(") == -1) break;
                    int endParenIndex = typeInfo.indexOf(")");
                    if (endParenIndex == -1) {
                        endParenIndex = typeInfo.length();
                    }
                    this.columnSize = Integer.valueOf(typeInfo.substring(typeInfo.indexOf("(") + 1, endParenIndex).trim());
                    if (!DatabaseMetaDataMysqlSchema.this.tinyInt1IsBitValue().booleanValue() || this.columnSize != 1 || !StringUtils.startsWithIgnoreCase(typeInfo, "tinyint")) break;
                    if (DatabaseMetaDataMysqlSchema.this.transformedBitIsBooleanValue().booleanValue()) {
                        this.mysqlType = MysqlType.BOOLEAN;
                        break;
                    }
                    this.mysqlType = MysqlType.BIT;
                    break;
                }
                case TINYINT: {
                    if (DatabaseMetaDataMysqlSchema.this.tinyInt1IsBitValue().booleanValue() && typeInfo.indexOf("(1)") != -1) {
                        if (DatabaseMetaDataMysqlSchema.this.transformedBitIsBooleanValue().booleanValue()) {
                            this.mysqlType = MysqlType.BOOLEAN;
                            break;
                        }
                        this.mysqlType = MysqlType.BIT;
                        break;
                    }
                    this.columnSize = 3;
                    break;
                }
                case TINYINT_UNSIGNED: {
                    this.columnSize = 3;
                    break;
                }
                case DATE: {
                    this.datetimePrecision = 0;
                    this.columnSize = 10;
                    break;
                }
                case TIME: {
                    int fract;
                    this.datetimePrecision = 0;
                    this.columnSize = 8;
                    if (typeInfo.indexOf("(") == -1 || (fract = Integer.parseInt(typeInfo.substring(typeInfo.indexOf("(") + 1, typeInfo.indexOf(")")).trim())) <= 0) break;
                    this.datetimePrecision = fract;
                    TypeDescriptor typeDescriptor = this;
                    typeDescriptor.columnSize = typeDescriptor.columnSize + (fract + 1);
                    break;
                }
                case DATETIME: 
                case TIMESTAMP: {
                    int fract;
                    this.datetimePrecision = 0;
                    this.columnSize = 19;
                    if (typeInfo.indexOf("(") == -1 || (fract = Integer.parseInt(typeInfo.substring(typeInfo.indexOf("(") + 1, typeInfo.indexOf(")")).trim())) <= 0) break;
                    this.datetimePrecision = fract;
                    TypeDescriptor typeDescriptor = this;
                    typeDescriptor.columnSize = typeDescriptor.columnSize + (fract + 1);
                    break;
                }
            }
            if (this.columnSize == null) {
                this.columnSize = this.mysqlType.getPrecision() > Integer.MAX_VALUE ? Integer.MAX_VALUE : this.mysqlType.getPrecision().intValue();
            }
            switch (this.mysqlType) {
                case CHAR: 
                case VARCHAR: 
                case TINYTEXT: 
                case MEDIUMTEXT: 
                case LONGTEXT: 
                case JSON: 
                case TEXT: 
                case TINYBLOB: 
                case MEDIUMBLOB: 
                case LONGBLOB: 
                case BLOB: 
                case BINARY: 
                case VARBINARY: 
                case BIT: {
                    this.charOctetLength = this.columnSize;
                    break;
                }
            }
            this.bufferLength = DatabaseMetaData.MAX_BUFFER_SIZE;
            this.numPrecRadix = 10;
            if (nullabilityInfo != null) {
                if (nullabilityInfo.equals("YES")) {
                    this.nullability = 1;
                    this.isNullable = "YES";
                } else if (nullabilityInfo.equals("UNKNOWN")) {
                    this.nullability = 2;
                    this.isNullable = "";
                } else {
                    this.nullability = 0;
                    this.isNullable = "NO";
                }
            } else {
                this.nullability = 0;
                this.isNullable = "NO";
            }
        }

        int getJdbcType() {
            return this.mysqlType == MysqlType.YEAR && DatabaseMetaDataMysqlSchema.this.yearIsDateTypeValue() == false ? 5 : this.mysqlType.getJdbcType();
        }
    }

    private static enum StoredRoutineType {
        FUNCTION,
        PROCEDURE;

    }
}

