/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common;

import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.ClientFinalMessage;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.ClientFirstMessage;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.CryptoUtil;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.ScramMechanism;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.ServerFirstMessage;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.StringPreparation;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.util.Preconditions;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class ScramFunctions {
    private static final byte @NotNull [] CLIENT_KEY_HMAC_MESSAGE = "Client Key".getBytes(StandardCharsets.UTF_8);
    private static final byte @NotNull [] SERVER_KEY_HMAC_MESSAGE = "Server Key".getBytes(StandardCharsets.UTF_8);

    private ScramFunctions() {
        throw new IllegalStateException("Utility class");
    }

    public static byte @NotNull [] saltedPassword(@NotNull ScramMechanism scramMechanism, @NotNull StringPreparation stringPreparation, char @NotNull [] password, byte @NotNull [] salt, int iterationCount) {
        return scramMechanism.saltedPassword(stringPreparation, password, salt, iterationCount);
    }

    public static byte @NotNull [] hmac(@NotNull ScramMechanism scramMechanism, byte @NotNull [] key, byte @NotNull [] message) {
        return scramMechanism.hmac(key, message);
    }

    public static byte[] clientKey(@NotNull ScramMechanism scramMechanism, byte @NotNull [] saltedPassword) {
        return ScramFunctions.hmac(scramMechanism, saltedPassword, CLIENT_KEY_HMAC_MESSAGE);
    }

    public static byte[] serverKey(@NotNull ScramMechanism scramMechanism, byte @NotNull [] saltedPassword) {
        return ScramFunctions.hmac(scramMechanism, saltedPassword, SERVER_KEY_HMAC_MESSAGE);
    }

    public static byte[] hash(@NotNull ScramMechanism scramMechanism, byte @NotNull [] message) {
        return scramMechanism.digest(message);
    }

    public static byte[] storedKey(@NotNull ScramMechanism scramMechanism, byte @NotNull [] clientKey) {
        return ScramFunctions.hash(scramMechanism, clientKey);
    }

    public static byte @NotNull [] clientSignature(@NotNull ScramMechanism scramMechanism, byte @NotNull [] storedKey, @NotNull String authMessage) {
        return ScramFunctions.hmac(scramMechanism, storedKey, authMessage.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] clientProof(byte @NotNull [] clientKey, byte @NotNull [] clientSignature) {
        return CryptoUtil.xor(clientKey, clientSignature);
    }

    public static byte @NotNull [] serverSignature(@NotNull ScramMechanism scramMechanism, byte @NotNull [] serverKey, @NotNull String authMessage) {
        return ScramFunctions.hmac(scramMechanism, serverKey, authMessage.getBytes(StandardCharsets.UTF_8));
    }

    public static boolean verifyClientProof(@NotNull ScramMechanism scramMechanism, byte @NotNull [] clientProof, byte @NotNull [] storedKey, @NotNull String authMessage) {
        byte[] clientSignature = ScramFunctions.clientSignature(scramMechanism, storedKey, authMessage);
        byte[] clientKey = CryptoUtil.xor(clientSignature, clientProof);
        byte[] computedStoredKey = ScramFunctions.hash(scramMechanism, clientKey);
        return Arrays.equals(storedKey, computedStoredKey);
    }

    public static boolean verifyServerSignature(ScramMechanism scramMechanism, byte[] serverKey, String authMessage, byte[] serverSignature) {
        return Arrays.equals(ScramFunctions.serverSignature(scramMechanism, serverKey, authMessage), serverSignature);
    }

    public static String nonce(int nonceSize, SecureRandom random) {
        Preconditions.gt0(nonceSize, "nonceSize");
        Preconditions.checkNotNull(random, "random");
        StringBuilder nonceBuilder = new StringBuilder(nonceSize);
        while (nonceBuilder.length() < nonceSize) {
            int codePoint = random.nextInt(94) + 33;
            if (codePoint == 44) continue;
            nonceBuilder.append((char)codePoint);
        }
        return nonceBuilder.toString();
    }

    public static byte @NotNull [] salt(int saltSize, @NotNull SecureRandom random) {
        return CryptoUtil.salt(saltSize, random);
    }

    public static String authMessage(ClientFirstMessage clientFirstMessage, ServerFirstMessage serverFirstMessage, byte[] cbindData) {
        StringBuilder sb = clientFirstMessage.clientFirstMessageBare(new StringBuilder(96)).append(',').append(serverFirstMessage).append(',');
        ClientFinalMessage.withoutProof(sb, clientFirstMessage.getGs2Header(), cbindData, serverFirstMessage.getNonce());
        return sb.toString();
    }
}

