/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mysql.cj.jdbc;

import com.vecoo.extralib.shade.mysql.cj.exceptions.CJException;
import com.vecoo.extralib.shade.mysql.cj.jdbc.JdbcConnection;
import com.vecoo.extralib.shade.mysql.cj.jdbc.MysqlDataSource;
import com.vecoo.extralib.shade.mysql.cj.jdbc.MysqlPooledConnection;
import com.vecoo.extralib.shade.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class MysqlConnectionPoolDataSource
extends MysqlDataSource
implements ConnectionPoolDataSource {
    static final long serialVersionUID = -7767325445592304961L;
    private final Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        try {
            this.lock.lock();
            try {
                MysqlPooledConnection mysqlPooledConnection;
                Connection connection = this.getConnection();
                MysqlPooledConnection mysqlPooledConnection2 = mysqlPooledConnection = MysqlPooledConnection.getInstance((JdbcConnection)connection);
                return mysqlPooledConnection2;
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PooledConnection getPooledConnection(String u, String p) throws SQLException {
        try {
            this.lock.lock();
            try {
                MysqlPooledConnection mysqlPooledConnection;
                Connection connection = this.getConnection(u, p);
                MysqlPooledConnection mysqlPooledConnection2 = mysqlPooledConnection = MysqlPooledConnection.getInstance((JdbcConnection)connection);
                return mysqlPooledConnection2;
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }
}

