/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.world;

import com.vecoo.extralib.ExtraLib;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UtilWorld {
    @Nullable
    public static ServerLevel getLevelByName(@NotNull String levelName) {
        for (ServerLevel level : ExtraLib.getInstance().getServer().m_129785_()) {
            if (!level.m_46472_().m_135782_().m_135815_().equals(levelName.toLowerCase())) continue;
            return level;
        }
        return null;
    }

    @NotNull
    public static String worldDirectory(@NotNull String file, @NotNull MinecraftServer server) {
        if (server.m_6982_()) {
            return file.replace("%directory%", "world");
        }
        return file.replace("%directory%", "saves/" + server.m_129843_(LevelResource.f_78178_).normalize().getParent().getFileName().toString());
    }

    public static int countBlocksInChunk(@NotNull LevelChunk chunk, @NotNull Block targetBlock) {
        int[] count = new int[]{0};
        for (LevelChunkSection section : chunk.m_7103_()) {
            if (section == null || section.m_188008_()) continue;
            PalettedContainer states = section.m_63019_();
            states.m_63099_((blockState, amount) -> {
                if (blockState.m_60713_(targetBlock)) {
                    count[0] = count[0] + amount;
                }
            });
        }
        return count[0];
    }
}

