/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.player;

import com.vecoo.extralib.ExtraLib;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.UsernameCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UtilPlayer {
    @Nullable
    public static UUID getUUID(@NotNull String playerName) {
        return UsernameCache.getMap().entrySet().stream().filter(entry -> ((String)entry.getValue()).equalsIgnoreCase(playerName)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    public static boolean hasUUID(@NotNull String playerName) {
        return UtilPlayer.getUUID(playerName) != null;
    }

    @NotNull
    public static String getPlayerName(@NotNull UUID playerUUID) {
        String name = UsernameCache.getLastKnownUsername((UUID)playerUUID);
        return name != null ? name : "Unknown";
    }

    public static void sendMessageUuid(@NotNull UUID playerUUID, @NotNull Component message) {
        ServerPlayer player = ExtraLib.getInstance().getServer().m_6846_().m_11259_(playerUUID);
        if (player != null) {
            player.m_213846_(message);
        }
    }

    public static void sendMessageUuid(@NotNull UUID playerUUID, @NotNull MutableComponent message) {
        ServerPlayer player = ExtraLib.getInstance().getServer().m_6846_().m_11259_(playerUUID);
        if (player != null) {
            player.m_213846_((Component)message);
        }
    }

    @Nullable
    public static ServerPlayer getPlayer(@NotNull String playerName) {
        return ExtraLib.getInstance().getServer().m_6846_().m_11255_(playerName);
    }

    @NotNull
    public static CommandSourceStack getSource(@NotNull String sourceName) {
        MinecraftServer server = ExtraLib.getInstance().getServer();
        ServerPlayer player = server.m_6846_().m_11255_(sourceName);
        return player != null ? player.m_20203_() : server.m_129893_();
    }

    public void executeCommand(@NotNull ServerPlayer player, @NotNull String command) {
        ExtraLib.getInstance().getServer().m_129892_().m_230957_(player.m_20203_(), command);
    }

    public static int countItemStack(@NotNull ServerPlayer player, @NotNull ItemStack searchItemStack) {
        int count = 0;
        for (ItemStack itemStack : player.f_36095_.m_38927_()) {
            if (itemStack.m_41619_() || !ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)searchItemStack)) continue;
            count += itemStack.m_41613_();
        }
        return count;
    }

    public static int countItemStackTag(@NotNull ServerPlayer player, @NotNull ItemStack searchItemStack, @NotNull String tag) {
        int count = 0;
        for (ItemStack itemStack : player.f_36095_.m_38927_()) {
            if (itemStack.m_41619_() || itemStack.m_41720_() != searchItemStack.m_41720_()) continue;
            if (itemStack.m_41783_() == null && searchItemStack.m_41783_() == null) {
                count += itemStack.m_41613_();
                continue;
            }
            if (itemStack.m_41783_() == null || searchItemStack.m_41783_() == null || !Objects.equals(itemStack.m_41783_().m_128423_(tag), searchItemStack.m_41783_().m_128423_(tag))) continue;
            count += itemStack.m_41613_();
        }
        return count;
    }

    public static void removeItemStack(@NotNull ServerPlayer player, @NotNull ItemStack removeItemStack, int amount) {
        int totalRemoved = 0;
        InventoryMenu playerContainer = player.f_36095_;
        for (ItemStack itemStack : playerContainer.m_38927_()) {
            if (totalRemoved >= amount) break;
            if (itemStack.m_41619_() || !ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)removeItemStack)) continue;
            int toRemove = Math.min(itemStack.m_41613_(), amount - totalRemoved);
            itemStack.m_41774_(toRemove);
            totalRemoved += toRemove;
        }
        playerContainer.m_38946_();
    }

    public static void removeItemStackTag(@NotNull ServerPlayer player, @NotNull ItemStack removeItemStack, @NotNull String tag, int amount) {
        int totalRemoved = 0;
        InventoryMenu playerContainer = player.f_36095_;
        for (ItemStack itemStack : playerContainer.m_38927_()) {
            if (totalRemoved >= amount) break;
            if (itemStack.m_41619_() || itemStack.m_41720_() != removeItemStack.m_41720_()) continue;
            int toRemove = Math.min(itemStack.m_41613_(), amount - totalRemoved);
            if (itemStack.m_41783_() == null && removeItemStack.m_41783_() == null) {
                itemStack.m_41774_(toRemove);
                totalRemoved += toRemove;
                continue;
            }
            if (itemStack.m_41783_() == null || removeItemStack.m_41783_() == null || !Objects.equals(itemStack.m_41783_().m_128423_(tag), removeItemStack.m_41783_().m_128423_(tag))) continue;
            itemStack.m_41774_(toRemove);
            totalRemoved += toRemove;
        }
        playerContainer.m_38946_();
    }

    public static boolean hasFreeSlot(@NotNull ServerPlayer player) {
        return player.m_150109_().m_36062_() != -1;
    }
}

