/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mariadb.jdbc.client.column;

import com.vecoo.extralib.shade.mariadb.jdbc.Configuration;
import com.vecoo.extralib.shade.mariadb.jdbc.client.ColumnDecoder;
import com.vecoo.extralib.shade.mariadb.jdbc.client.Context;
import com.vecoo.extralib.shade.mariadb.jdbc.client.DataType;
import com.vecoo.extralib.shade.mariadb.jdbc.client.ReadableByteBuf;
import com.vecoo.extralib.shade.mariadb.jdbc.client.util.MutableInt;
import com.vecoo.extralib.shade.mariadb.jdbc.message.server.ColumnDefinitionPacket;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class UnsignedBigIntColumn
extends ColumnDefinitionPacket
implements ColumnDecoder {
    public UnsignedBigIntColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat, false);
    }

    protected UnsignedBigIntColumn(UnsignedBigIntColumn prev) {
        super(prev, true);
    }

    @Override
    public UnsignedBigIntColumn useAliasAsName() {
        return new UnsignedBigIntColumn(this);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        return BigInteger.class.getName();
    }

    @Override
    public int getColumnType(Configuration conf) {
        return -5;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        return "BIGINT UNSIGNED";
    }

    @Override
    public Object getDefaultText(ReadableByteBuf buf, MutableInt length, Context context) throws SQLDataException {
        return new BigInteger(buf.readAscii(length.get()));
    }

    @Override
    public Object getDefaultBinary(ReadableByteBuf buf, MutableInt length, Context context) throws SQLDataException {
        byte[] bb = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bb[i] = buf.readByte();
        }
        return new BigInteger(1, bb);
    }

    @Override
    public boolean decodeBooleanText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        String s2 = buf.readAscii(length.get());
        return !"0".equals(s2);
    }

    @Override
    public boolean decodeBooleanBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return buf.readLong() != 0L;
    }

    @Override
    public byte decodeByteText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        long result = buf.atoull(length.get());
        if ((long)((byte)result) != result || result < 0L) {
            throw new SQLDataException("byte overflow");
        }
        return (byte)result;
    }

    @Override
    public byte decodeByteBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        byte[] bb = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bb[i] = buf.readByte();
        }
        BigInteger val = new BigInteger(1, bb);
        try {
            return val.byteValueExact();
        }
        catch (ArithmeticException | NumberFormatException nfe) {
            throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as Byte", new Object[]{val, this.dataType}));
        }
    }

    @Override
    public String decodeStringText(ReadableByteBuf buf, MutableInt length, Calendar cal, Context context) throws SQLDataException {
        return buf.readString(length.get());
    }

    @Override
    public String decodeStringBinary(ReadableByteBuf buf, MutableInt length, Calendar cal, Context context) throws SQLDataException {
        byte[] bb = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bb[i] = buf.readByte();
        }
        return new BigInteger(1, bb).toString();
    }

    @Override
    public short decodeShortText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        long result = buf.atoull(length.get());
        if ((long)((short)result) != result || result < 0L) {
            throw new SQLDataException("Short overflow");
        }
        return (short)result;
    }

    @Override
    public short decodeShortBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        long result = buf.readLong();
        if ((long)((short)result) != result || result < 0L) {
            throw new SQLDataException("Short overflow");
        }
        return (short)result;
    }

    @Override
    public int decodeIntText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        long result = buf.atoull(length.get());
        int res = (int)result;
        if ((long)res != result || result < 0L) {
            throw new SQLDataException("integer overflow");
        }
        return res;
    }

    @Override
    public int decodeIntBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        byte[] bb = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bb[i] = buf.readByte();
        }
        BigInteger val = new BigInteger(1, bb);
        try {
            return val.intValueExact();
        }
        catch (ArithmeticException ae) {
            throw new SQLDataException(String.format("value '%s' cannot be decoded as Integer", val));
        }
    }

    @Override
    public long decodeLongText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        if (length.get() < 10) {
            return buf.atoull(length.get());
        }
        BigInteger val = new BigInteger(buf.readAscii(length.get()));
        try {
            return val.longValueExact();
        }
        catch (ArithmeticException ae) {
            throw new SQLDataException(String.format("value '%s' cannot be decoded as Long", val));
        }
    }

    @Override
    public long decodeLongBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        if ((buf.getByte(buf.pos() + 7) & 0x80) == 0) {
            return buf.readLong();
        }
        byte[] bb = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bb[i] = buf.readByte();
        }
        BigInteger val = new BigInteger(1, bb);
        try {
            return val.longValueExact();
        }
        catch (ArithmeticException ae) {
            throw new SQLDataException(String.format("value '%s' cannot be decoded as Long", val));
        }
    }

    @Override
    public float decodeFloatText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return Float.parseFloat(buf.readAscii(length.get()));
    }

    @Override
    public float decodeFloatBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        byte[] bb = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bb[i] = buf.readByte();
        }
        return new BigInteger(1, bb).floatValue();
    }

    @Override
    public double decodeDoubleText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return Double.parseDouble(buf.readAscii(length.get()));
    }

    @Override
    public double decodeDoubleBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        byte[] bb = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bb[i] = buf.readByte();
        }
        return new BigInteger(1, bb).doubleValue();
    }

    @Override
    public Date decodeDateText(ReadableByteBuf buf, MutableInt length, Calendar cal, Context context) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Date", new Object[]{this.dataType}));
    }

    @Override
    public Date decodeDateBinary(ReadableByteBuf buf, MutableInt length, Calendar cal, Context context) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Date", new Object[]{this.dataType}));
    }

    @Override
    public Time decodeTimeText(ReadableByteBuf buf, MutableInt length, Calendar cal, Context context) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Time", new Object[]{this.dataType}));
    }

    @Override
    public Time decodeTimeBinary(ReadableByteBuf buf, MutableInt length, Calendar cal, Context context) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Time", new Object[]{this.dataType}));
    }

    @Override
    public Timestamp decodeTimestampText(ReadableByteBuf buf, MutableInt length, Calendar cal, Context context) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{this.dataType}));
    }

    @Override
    public Timestamp decodeTimestampBinary(ReadableByteBuf buf, MutableInt length, Calendar cal, Context context) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{this.dataType}));
    }
}

