/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mysql.cj.xdevapi;

import com.vecoo.extralib.shade.mysql.cj.MysqlxSession;
import com.vecoo.extralib.shade.mysql.cj.conf.PropertySet;
import com.vecoo.extralib.shade.mysql.cj.exceptions.ExceptionFactory;
import com.vecoo.extralib.shade.mysql.cj.exceptions.WrongArgumentException;
import com.vecoo.extralib.shade.mysql.cj.protocol.ColumnDefinition;
import com.vecoo.extralib.shade.mysql.cj.protocol.ProtocolEntity;
import com.vecoo.extralib.shade.mysql.cj.protocol.ResultBuilder;
import com.vecoo.extralib.shade.mysql.cj.protocol.x.FetchDoneEntity;
import com.vecoo.extralib.shade.mysql.cj.protocol.x.Notice;
import com.vecoo.extralib.shade.mysql.cj.protocol.x.StatementExecuteOk;
import com.vecoo.extralib.shade.mysql.cj.protocol.x.StatementExecuteOkBuilder;
import com.vecoo.extralib.shade.mysql.cj.result.BufferedRowList;
import com.vecoo.extralib.shade.mysql.cj.result.DefaultColumnDefinition;
import com.vecoo.extralib.shade.mysql.cj.result.Field;
import com.vecoo.extralib.shade.mysql.cj.result.Row;
import com.vecoo.extralib.shade.mysql.cj.xdevapi.RowResult;
import com.vecoo.extralib.shade.mysql.cj.xdevapi.RowResultImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;

public class RowResultBuilder
implements ResultBuilder<RowResult> {
    private ArrayList<Field> fields = new ArrayList();
    private ColumnDefinition metadata;
    private List<Row> rows = new ArrayList<Row>();
    private RowResult result;
    TimeZone defaultTimeZone;
    PropertySet pset;
    private StatementExecuteOkBuilder statementExecuteOkBuilder = new StatementExecuteOkBuilder();

    public RowResultBuilder(MysqlxSession sess) {
        this.defaultTimeZone = sess.getServerSession().getDefaultTimeZone();
        this.pset = sess.getPropertySet();
    }

    @Override
    public boolean addProtocolEntity(ProtocolEntity entity) {
        if (entity instanceof Field) {
            this.fields.add((Field)entity);
            return false;
        }
        if (entity instanceof Row) {
            if (this.metadata == null) {
                this.metadata = new DefaultColumnDefinition(this.fields.toArray(new Field[0]));
            }
            this.rows.add(((Row)entity).setMetadata(this.metadata));
            return false;
        }
        if (entity instanceof Notice) {
            this.statementExecuteOkBuilder.addProtocolEntity(entity);
            return false;
        }
        if (entity instanceof FetchDoneEntity) {
            return false;
        }
        if (entity instanceof StatementExecuteOk) {
            return true;
        }
        throw ExceptionFactory.createException(WrongArgumentException.class, "Unexpected protocol entity " + entity);
    }

    @Override
    public RowResult build() {
        if (this.metadata == null) {
            this.metadata = new DefaultColumnDefinition(this.fields.toArray(new Field[0]));
        }
        this.result = new RowResultImpl(this.metadata, this.defaultTimeZone, new BufferedRowList(this.rows), () -> this.statementExecuteOkBuilder.build(), this.pset);
        return this.result;
    }
}

