/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.permission;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.vecoo.extralib.ExtraLib;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.Context;
import net.minecraftforge.server.permission.context.IContext;

public class UtilPermission {
    public static boolean hasPermission(@Nonnull CommandSource source, @Nonnull String node) {
        try {
            if (PermissionAPI.getPermissionHandler().getRegisteredNodes().contains(node)) {
                return PermissionAPI.hasPermission((PlayerEntity)source.func_197035_h(), (String)node) || source.func_197034_c(4);
            }
        }
        catch (CommandSyntaxException e) {
            return true;
        }
        ExtraLib.getLogger().error("[ExtraLib] No permission found for node: " + node);
        return false;
    }

    public static boolean hasPermission(@Nonnull PlayerEntity player, @Nonnull String node) {
        if (PermissionAPI.getPermissionHandler().getRegisteredNodes().contains(node)) {
            return PermissionAPI.hasPermission((PlayerEntity)player, (String)node) || player.func_211513_k(4);
        }
        ExtraLib.getLogger().error("[ExtraLib] No permission found for node: " + node);
        return false;
    }

    public static boolean hasPermission(@Nonnull UUID playerUUID, @Nonnull String playerName, @Nonnull String node) {
        if (PermissionAPI.getPermissionHandler().getRegisteredNodes().contains(node)) {
            return PermissionAPI.hasPermission((GameProfile)new GameProfile(playerUUID, playerName), (String)node, (IContext)new Context());
        }
        ExtraLib.getLogger().error("[ExtraLib] No permission found for node: " + node);
        return false;
    }

    public static int minValue(int value, @Nonnull PlayerEntity player, @Nonnull Set<String> permissionList) {
        for (String permission : permissionList) {
            if (!UtilPermission.hasPermission(player, permission)) continue;
            value = Math.min(value, Integer.parseInt(permission.substring(permission.lastIndexOf(46) + 1)));
        }
        return value;
    }

    public static int maxValue(int value, @Nonnull PlayerEntity player, @Nonnull Set<String> permissionList) {
        for (String permission : permissionList) {
            if (!UtilPermission.hasPermission(player, permission)) continue;
            value = Math.max(value, Integer.parseInt(permission.substring(permission.lastIndexOf(46) + 1)));
        }
        return value;
    }

    public static int minValue(int value, @Nonnull UUID playerUUID, @Nonnull String playerName, @Nonnull Set<String> permissionList) {
        for (String permission : permissionList) {
            if (!UtilPermission.hasPermission(playerUUID, playerName, permission)) continue;
            value = Math.min(value, Integer.parseInt(permission.substring(permission.lastIndexOf(46) + 1)));
        }
        return value;
    }

    public static int maxValue(int value, @Nonnull UUID playerUUID, @Nonnull String playerName, @Nonnull Set<String> permissionList) {
        for (String permission : permissionList) {
            if (!UtilPermission.hasPermission(playerUUID, playerName, permission)) continue;
            value = Math.max(value, Integer.parseInt(permission.substring(permission.lastIndexOf(46) + 1)));
        }
        return value;
    }
}

