/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mariadb.jdbc.plugin.codec;

import com.vecoo.extralib.shade.mariadb.jdbc.client.ColumnDecoder;
import com.vecoo.extralib.shade.mariadb.jdbc.client.Context;
import com.vecoo.extralib.shade.mariadb.jdbc.client.DataType;
import com.vecoo.extralib.shade.mariadb.jdbc.client.ReadableByteBuf;
import com.vecoo.extralib.shade.mariadb.jdbc.client.socket.Writer;
import com.vecoo.extralib.shade.mariadb.jdbc.client.util.MutableInt;
import com.vecoo.extralib.shade.mariadb.jdbc.plugin.Codec;
import com.vecoo.extralib.shade.mariadb.jdbc.type.Geometry;
import com.vecoo.extralib.shade.mariadb.jdbc.type.LineString;
import com.vecoo.extralib.shade.mariadb.jdbc.type.MultiLineString;
import com.vecoo.extralib.shade.mariadb.jdbc.type.Point;
import java.io.IOException;
import java.sql.SQLDataException;
import java.util.Calendar;

public class MultiLinestringCodec
implements Codec<MultiLineString> {
    public static final MultiLinestringCodec INSTANCE = new MultiLinestringCodec();

    @Override
    public String className() {
        return MultiLineString.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return column.getType() == DataType.GEOMETRY && type.isAssignableFrom(MultiLineString.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof MultiLineString;
    }

    @Override
    public MultiLineString decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        return this.decodeBinary(buf, length, column, cal, context);
    }

    @Override
    public MultiLineString decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        if (column.getType() == DataType.GEOMETRY) {
            buf.skip(4);
            Geometry geo = Geometry.getGeometry(buf, length.get() - 4, column);
            if (geo instanceof MultiLineString) {
                return (MultiLineString)geo;
            }
            throw new SQLDataException(String.format("Geometric type %s cannot be decoded as MultiLineString", geo.getClass().getName()));
        }
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as MultiLineString", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeBytes(("ST_MLineFromText('" + value.toString() + "')").getBytes());
    }

    @Override
    public void encodeBinary(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        MultiLineString mp = (MultiLineString)value;
        int length = 13;
        for (LineString ls : mp.getLines()) {
            length += 9 + ls.getPoints().length * 16;
        }
        encoder.writeLength(length);
        encoder.writeInt(0);
        encoder.writeByte(1);
        encoder.writeInt(5);
        encoder.writeInt(mp.getLines().length);
        for (LineString ls : mp.getLines()) {
            encoder.writeByte(1);
            encoder.writeInt(2);
            encoder.writeInt(ls.getPoints().length);
            for (Point pt : ls.getPoints()) {
                encoder.writeDouble(pt.getX());
                encoder.writeDouble(pt.getY());
            }
        }
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.BLOB.get();
    }
}

