/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mariadb.jdbc.plugin.credential.env;

import com.vecoo.extralib.shade.mariadb.jdbc.Configuration;
import com.vecoo.extralib.shade.mariadb.jdbc.HostAddress;
import com.vecoo.extralib.shade.mariadb.jdbc.plugin.Credential;
import com.vecoo.extralib.shade.mariadb.jdbc.plugin.CredentialPlugin;

public class EnvCredentialPlugin
implements CredentialPlugin {
    private Configuration conf;
    private String userName;

    @Override
    public String type() {
        return "ENV";
    }

    @Override
    public CredentialPlugin initialize(Configuration conf, String userName, HostAddress hostAddress) {
        this.conf = conf;
        this.userName = userName;
        return this;
    }

    @Override
    public Credential get() {
        String userKey = this.conf.nonMappedOptions().getProperty("userKey");
        String pwdKey = this.conf.nonMappedOptions().getProperty("pwdKey");
        String envUser = System.getenv(userKey != null ? userKey : "MARIADB_USER");
        return new Credential(envUser == null ? this.userName : envUser, System.getenv(pwdKey != null ? pwdKey : "MARIADB_PWD"));
    }
}

