/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.postgresql.util;

public class NumberParser {
    private static final NumberFormatException FAST_NUMBER_FAILED = new NumberFormatException(){

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    };
    private static final long MAX_LONG_DIV_TEN = 0xCCCCCCCCCCCCCCCL;

    public static long getFastLong(byte[] bytes, long minVal, long maxVal) throws NumberFormatException {
        int start;
        int len = bytes.length;
        if (len == 0) {
            throw FAST_NUMBER_FAILED;
        }
        boolean neg = bytes[0] == 45;
        long val = 0L;
        int n = start = neg ? 1 : 0;
        while (start < len) {
            byte b;
            if ((b = bytes[start++]) < 48 || b > 57) {
                if (b == 46) {
                    if (neg && len == 2 || !neg && len == 1) {
                        throw FAST_NUMBER_FAILED;
                    }
                    while (start < len) {
                        if ((b = bytes[start++]) >= 48 && b <= 57) continue;
                        throw FAST_NUMBER_FAILED;
                    }
                    break;
                }
                throw FAST_NUMBER_FAILED;
            }
            if (val <= 0xCCCCCCCCCCCCCCCL) {
                val *= 10L;
                val += (long)(b - 48);
                continue;
            }
            throw FAST_NUMBER_FAILED;
        }
        if (val < 0L) {
            if (!neg || val != Long.MIN_VALUE) {
                throw FAST_NUMBER_FAILED;
            }
        } else if (neg) {
            val = -val;
        }
        if (val < minVal || val > maxVal) {
            throw FAST_NUMBER_FAILED;
        }
        return val;
    }
}

