/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.player;

import com.vecoo.extralib.ExtraLib;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.UsernameCache;

public class UtilPlayer {
    @Nullable
    public static UUID getUUID(@Nonnull String playerName) {
        return UsernameCache.getMap().entrySet().stream().filter(entry -> ((String)entry.getValue()).equalsIgnoreCase(playerName)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    public static boolean hasUUID(@Nonnull String playerName) {
        return UtilPlayer.getUUID(playerName) != null;
    }

    @Nonnull
    public static String getPlayerName(@Nonnull UUID playerUUID) {
        String name = UsernameCache.getLastKnownUsername((UUID)playerUUID);
        return name != null ? name : "Unknown";
    }

    public static void sendMessageUuid(@Nonnull UUID playerUUID, @Nonnull StringTextComponent message) {
        ServerPlayerEntity player = ExtraLib.getInstance().getServer().func_184103_al().func_177451_a(playerUUID);
        if (player != null) {
            player.func_145747_a((ITextComponent)message, Util.field_240973_b_);
        }
    }

    public static void sendMessageUuid(@Nonnull UUID playerUUID, @Nonnull IFormattableTextComponent message) {
        ServerPlayerEntity player = ExtraLib.getInstance().getServer().func_184103_al().func_177451_a(playerUUID);
        if (player != null) {
            player.func_145747_a((ITextComponent)message, Util.field_240973_b_);
        }
    }

    @Nullable
    public static ServerPlayerEntity getPlayer(String playerName) {
        return ExtraLib.getInstance().getServer().func_184103_al().func_152612_a(playerName);
    }

    @Nonnull
    public static CommandSource getSource(@Nonnull String sourceName) {
        MinecraftServer server = ExtraLib.getInstance().getServer();
        ServerPlayerEntity player = server.func_184103_al().func_152612_a(sourceName);
        return player != null ? player.func_195051_bN() : server.func_195573_aM();
    }

    public static int countItemStack(@Nonnull ServerPlayerEntity player, @Nonnull ItemStack searchItemStack) {
        int count = 0;
        for (ItemStack itemStack : player.field_71069_bz.func_75138_a()) {
            if (itemStack.func_190926_b() || itemStack.func_77973_b() != searchItemStack.func_77973_b() || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)searchItemStack)) continue;
            count += itemStack.func_190916_E();
        }
        return count;
    }

    public static int countItemStackTag(@Nonnull ServerPlayerEntity player, @Nonnull ItemStack searchItemStack, @Nonnull String tag) {
        int count = 0;
        for (ItemStack itemStack : player.field_71069_bz.func_75138_a()) {
            if (itemStack.func_190926_b() || itemStack.func_77973_b() != searchItemStack.func_77973_b()) continue;
            if (itemStack.func_77978_p() == null && searchItemStack.func_77978_p() == null) {
                count += itemStack.func_190916_E();
                continue;
            }
            if (itemStack.func_77978_p() == null || searchItemStack.func_77978_p() == null || !Objects.equals(itemStack.func_77978_p().func_74781_a(tag), searchItemStack.func_77978_p().func_74781_a(tag))) continue;
            count += itemStack.func_190916_E();
        }
        return count;
    }

    public static void removeItemStack(@Nonnull ServerPlayerEntity player, @Nonnull ItemStack removeItemStack, int amount) {
        int totalRemoved = 0;
        PlayerContainer playerContainer = player.field_71069_bz;
        for (ItemStack itemStack : playerContainer.func_75138_a()) {
            if (totalRemoved >= amount) break;
            if (itemStack.func_190926_b() || itemStack.func_77973_b() != removeItemStack.func_77973_b() || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)removeItemStack)) continue;
            int toRemove = Math.min(itemStack.func_190916_E(), amount - totalRemoved);
            itemStack.func_190918_g(toRemove);
            totalRemoved += toRemove;
        }
        playerContainer.func_75142_b();
    }

    public static void removeItemStackTag(@Nonnull ServerPlayerEntity player, @Nonnull ItemStack removeItemStack, @Nonnull String tag, int amount) {
        int totalRemoved = 0;
        PlayerContainer playerContainer = player.field_71069_bz;
        for (ItemStack itemStack : playerContainer.func_75138_a()) {
            if (totalRemoved >= amount) break;
            if (itemStack.func_190926_b() || itemStack.func_77973_b() != removeItemStack.func_77973_b()) continue;
            int toRemove = Math.min(itemStack.func_190916_E(), amount - totalRemoved);
            if (itemStack.func_77978_p() == null && removeItemStack.func_77978_p() == null) {
                itemStack.func_190918_g(toRemove);
                totalRemoved += toRemove;
                continue;
            }
            if (itemStack.func_77978_p() == null || removeItemStack.func_77978_p() == null || !Objects.equals(itemStack.func_77978_p().func_74781_a(tag), removeItemStack.func_77978_p().func_74781_a(tag))) continue;
            itemStack.func_190918_g(toRemove);
            totalRemoved += toRemove;
        }
        playerContainer.func_75142_b();
    }

    public static boolean hasFreeSlot(@Nonnull ServerPlayerEntity player) {
        return player.field_71071_by.func_70447_i() != -1;
    }
}

