/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.item;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.vecoo.extralib.ExtraLib;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class UtilItem {
    @NotNull
    public static ItemStack parseItem(@NotNull String itemId) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
        if (item == null) {
            return ItemStack.f_41583_;
        }
        return item.m_7968_();
    }

    @NotNull
    public static ItemStack parseItemCustomModel(@NotNull String itemId) {
        String[] parts = itemId.split(":");
        ItemStack itemStack = UtilItem.parseItem(parts[0] + ":" + parts[1]);
        if (itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (parts.length == 3) {
            try {
                itemStack.m_41784_().m_128405_("CustomModelData", Integer.parseInt(parts[2]));
            }
            catch (NumberFormatException e) {
                ExtraLib.getLogger().error("Invalid CustomModelData value in item: " + itemId);
            }
        }
        return itemStack;
    }

    @NotNull
    public static String serialize(@NotNull ItemStack itemStack) {
        return itemStack.m_41739_(new CompoundTag()).m_7916_();
    }

    @NotNull
    public static ItemStack deserialize(@NotNull String itemStack) {
        try {
            return ItemStack.m_41712_((CompoundTag)TagParser.m_129359_((String)itemStack));
        }
        catch (CommandSyntaxException e) {
            ExtraLib.getLogger().error("Invalid tag item.");
            return Items.f_41905_.m_7968_();
        }
    }
}

