/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mysql.cj.jdbc;

import com.vecoo.extralib.shade.mysql.cj.Messages;
import com.vecoo.extralib.shade.mysql.cj.exceptions.CJException;
import com.vecoo.extralib.shade.mysql.cj.exceptions.ExceptionInterceptor;
import com.vecoo.extralib.shade.mysql.cj.jdbc.exceptions.SQLError;
import com.vecoo.extralib.shade.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import com.vecoo.extralib.shade.mysql.cj.jdbc.result.ResultSetInternalMethods;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class MysqlSQLXML
implements SQLXML {
    private final Lock lock = new ReentrantLock();
    private XMLInputFactory inputFactory;
    private XMLOutputFactory outputFactory;
    private String stringRep;
    private ResultSetInternalMethods owningResultSet;
    private int columnIndexOfXml;
    private boolean fromResultSet;
    private boolean isClosed = false;
    private boolean workingWithResult;
    private DOMResult asDOMResult;
    private SAXResult asSAXResult;
    private SimpleSaxToReader saxToReaderConverter;
    private StringWriter asStringWriter;
    private ByteArrayOutputStream asByteArrayOutputStream;
    private ExceptionInterceptor exceptionInterceptor;

    public MysqlSQLXML(ResultSetInternalMethods owner, int index, ExceptionInterceptor exceptionInterceptor) {
        this.owningResultSet = owner;
        this.columnIndexOfXml = index;
        this.fromResultSet = true;
        this.exceptionInterceptor = exceptionInterceptor;
    }

    public MysqlSQLXML(ExceptionInterceptor exceptionInterceptor) {
        this.fromResultSet = false;
        this.exceptionInterceptor = exceptionInterceptor;
    }

    @Override
    public void free() throws SQLException {
        try {
            this.lock.lock();
            try {
                this.stringRep = null;
                this.asDOMResult = null;
                this.asSAXResult = null;
                this.inputFactory = null;
                this.outputFactory = null;
                this.owningResultSet = null;
                this.workingWithResult = false;
                this.isClosed = true;
            }
            finally {
                this.lock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.exceptionInterceptor);
        }
    }

    @Override
    public String getString() throws SQLException {
        try {
            this.lock.lock();
            try {
                this.checkClosed();
                this.checkWorkingWithResult();
                if (this.fromResultSet) {
                    String string = this.owningResultSet.getString(this.columnIndexOfXml);
                    return string;
                }
                String string = this.stringRep;
                return string;
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.exceptionInterceptor);
        }
    }

    private void checkClosed() throws SQLException {
        this.lock.lock();
        try {
            if (this.isClosed) {
                throw SQLError.createSQLException(Messages.getString("MysqlSQLXML.0"), this.exceptionInterceptor);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkWorkingWithResult() throws SQLException {
        this.lock.lock();
        try {
            if (this.workingWithResult) {
                throw SQLError.createSQLException(Messages.getString("MysqlSQLXML.1"), "S1009", this.exceptionInterceptor);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setString(String str) throws SQLException {
        try {
            this.lock.lock();
            try {
                this.checkClosed();
                this.checkWorkingWithResult();
                this.stringRep = str;
                this.fromResultSet = false;
            }
            finally {
                this.lock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.exceptionInterceptor);
        }
    }

    public boolean isEmpty() throws SQLException {
        this.lock.lock();
        try {
            this.checkClosed();
            this.checkWorkingWithResult();
            if (!this.fromResultSet) {
                boolean bl = this.stringRep == null || this.stringRep.length() == 0;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        try {
            this.lock.lock();
            try {
                this.checkClosed();
                this.checkWorkingWithResult();
                InputStream inputStream = this.owningResultSet.getBinaryStream(this.columnIndexOfXml);
                return inputStream;
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.exceptionInterceptor);
        }
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        try {
            this.lock.lock();
            try {
                this.checkClosed();
                this.checkWorkingWithResult();
                Reader reader = this.owningResultSet.getCharacterStream(this.columnIndexOfXml);
                return reader;
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.exceptionInterceptor);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T extends Source> T getSource(Class<T> clazz) throws SQLException {
        try {
            block18: {
                this.lock.lock();
                this.checkClosed();
                this.checkWorkingWithResult();
                if (clazz == null || clazz.equals(SAXSource.class)) {
                    try {
                        XMLReader reader = XMLReaderFactory.createXMLReader();
                        reader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                        MysqlSQLXML.setFeature(reader, "http://apache.org/xml/features/disallow-doctype-decl", true);
                        MysqlSQLXML.setFeature(reader, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                        MysqlSQLXML.setFeature(reader, "http://xml.org/sax/features/external-general-entities", false);
                        MysqlSQLXML.setFeature(reader, "http://xml.org/sax/features/external-parameter-entities", false);
                        SAXSource sAXSource = new SAXSource(reader, this.fromResultSet ? new InputSource(this.owningResultSet.getCharacterStream(this.columnIndexOfXml)) : new InputSource(new StringReader(this.stringRep)));
                        return (T)sAXSource;
                    }
                    catch (SAXException ex) {
                        SQLException sqlEx = SQLError.createSQLException(ex.getMessage(), "S1009", ex, this.exceptionInterceptor);
                        throw sqlEx;
                    }
                }
                if (clazz.equals(DOMSource.class)) {
                    try {
                        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                        builderFactory.setNamespaceAware(true);
                        MysqlSQLXML.setFeature(builderFactory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
                        MysqlSQLXML.setFeature(builderFactory, "http://apache.org/xml/features/disallow-doctype-decl", true);
                        MysqlSQLXML.setFeature(builderFactory, "http://xml.org/sax/features/external-general-entities", false);
                        MysqlSQLXML.setFeature(builderFactory, "http://xml.org/sax/features/external-parameter-entities", false);
                        MysqlSQLXML.setFeature(builderFactory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                        builderFactory.setXIncludeAware(false);
                        builderFactory.setExpandEntityReferences(false);
                        builderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                        DocumentBuilder builder = builderFactory.newDocumentBuilder();
                        DOMSource dOMSource = new DOMSource(builder.parse(this.fromResultSet ? new InputSource(this.owningResultSet.getCharacterStream(this.columnIndexOfXml)) : new InputSource(new StringReader(this.stringRep))));
                        return (T)dOMSource;
                    }
                    catch (Throwable t2) {
                        SQLException sqlEx = SQLError.createSQLException(t2.getMessage(), "S1009", t2, this.exceptionInterceptor);
                        throw sqlEx;
                    }
                }
                if (clazz.equals(StreamSource.class)) {
                    StreamSource t2 = new StreamSource(this.fromResultSet ? this.owningResultSet.getCharacterStream(this.columnIndexOfXml) : new StringReader(this.stringRep));
                    return (T)t2;
                }
                if (!clazz.equals(StAXSource.class)) break block18;
                try {
                    StAXSource t2 = new StAXSource(this.inputFactory.createXMLStreamReader(this.fromResultSet ? this.owningResultSet.getCharacterStream(this.columnIndexOfXml) : new StringReader(this.stringRep)));
                    return (T)t2;
                }
                catch (XMLStreamException ex) {
                    SQLException sqlEx = SQLError.createSQLException(ex.getMessage(), "S1009", ex, this.exceptionInterceptor);
                    throw sqlEx;
                }
            }
            throw SQLError.createSQLException(Messages.getString("MysqlSQLXML.2", new Object[]{clazz.toString()}), "S1009", this.exceptionInterceptor);
            finally {
                this.lock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.exceptionInterceptor);
        }
    }

    private static void setFeature(Object factory, String name, boolean value) {
        try {
            if (factory instanceof DocumentBuilderFactory) {
                ((DocumentBuilderFactory)factory).setFeature(name, value);
            } else if (factory instanceof XMLReader) {
                ((XMLReader)factory).setFeature(name, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public OutputStream setBinaryStream() throws SQLException {
        try {
            this.lock.lock();
            try {
                this.checkClosed();
                this.checkWorkingWithResult();
                this.workingWithResult = true;
                OutputStream outputStream = this.setBinaryStreamInternal();
                return outputStream;
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.exceptionInterceptor);
        }
    }

    private OutputStream setBinaryStreamInternal() throws SQLException {
        this.lock.lock();
        try {
            ByteArrayOutputStream byteArrayOutputStream = this.asByteArrayOutputStream = new ByteArrayOutputStream();
            return byteArrayOutputStream;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Writer setCharacterStream() throws SQLException {
        try {
            this.lock.lock();
            try {
                this.checkClosed();
                this.checkWorkingWithResult();
                this.workingWithResult = true;
                Writer writer = this.setCharacterStreamInternal();
                return writer;
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.exceptionInterceptor);
        }
    }

    private Writer setCharacterStreamInternal() throws SQLException {
        this.lock.lock();
        try {
            StringWriter stringWriter = this.asStringWriter = new StringWriter();
            return stringWriter;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public <T extends Result> T setResult(Class<T> clazz) throws SQLException {
        try {
            this.lock.lock();
            try {
                this.checkClosed();
                this.checkWorkingWithResult();
                this.workingWithResult = true;
                this.asDOMResult = null;
                this.asSAXResult = null;
                this.saxToReaderConverter = null;
                this.stringRep = null;
                this.asStringWriter = null;
                this.asByteArrayOutputStream = null;
                if (clazz == null || clazz.equals(SAXResult.class)) {
                    this.saxToReaderConverter = new SimpleSaxToReader();
                    SAXResult sAXResult = this.asSAXResult = new SAXResult(this.saxToReaderConverter);
                    return (T)sAXResult;
                }
                if (clazz.equals(DOMResult.class)) {
                    DOMResult dOMResult = this.asDOMResult = new DOMResult();
                    return (T)dOMResult;
                }
                if (clazz.equals(StreamResult.class)) {
                    StreamResult streamResult = new StreamResult(this.setCharacterStreamInternal());
                    return (T)streamResult;
                }
                if (clazz.equals(StAXResult.class)) {
                    StAXResult stAXResult;
                    try {
                        if (this.outputFactory == null) {
                            this.outputFactory = XMLOutputFactory.newInstance();
                        }
                        stAXResult = new StAXResult(this.outputFactory.createXMLEventWriter(this.setCharacterStreamInternal()));
                    }
                    catch (XMLStreamException ex) {
                        SQLException sqlEx = SQLError.createSQLException(ex.getMessage(), "S1009", ex, this.exceptionInterceptor);
                        throw sqlEx;
                    }
                    return (T)stAXResult;
                }
                throw SQLError.createSQLException(Messages.getString("MysqlSQLXML.3", new Object[]{clazz.toString()}), "S1009", this.exceptionInterceptor);
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.exceptionInterceptor);
        }
    }

    private Reader binaryInputStreamStreamToReader(ByteArrayOutputStream out) {
        try {
            String encoding = "UTF-8";
            try {
                ByteArrayInputStream bIn = new ByteArrayInputStream(out.toByteArray());
                XMLStreamReader reader = this.inputFactory.createXMLStreamReader(bIn);
                int eventType = 0;
                while ((eventType = reader.next()) != 8) {
                    if (eventType != 7) continue;
                    String possibleEncoding = reader.getEncoding();
                    if (possibleEncoding != null) {
                        encoding = possibleEncoding;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return new StringReader(new String(out.toByteArray(), encoding));
        }
        catch (UnsupportedEncodingException badEnc) {
            throw new RuntimeException(badEnc);
        }
    }

    protected String readerToString(Reader reader) throws SQLException {
        StringBuilder buf = new StringBuilder();
        int charsRead = 0;
        char[] charBuf = new char[512];
        try {
            while ((charsRead = reader.read(charBuf)) != -1) {
                buf.append(charBuf, 0, charsRead);
            }
        }
        catch (IOException ioEx) {
            SQLException sqlEx = SQLError.createSQLException(ioEx.getMessage(), "S1009", ioEx, this.exceptionInterceptor);
            throw sqlEx;
        }
        return buf.toString();
    }

    protected Reader serializeAsCharacterStream() throws SQLException {
        this.lock.lock();
        try {
            this.checkClosed();
            if (this.workingWithResult || this.owningResultSet == null) {
                if (this.stringRep != null) {
                    StringReader stringReader = new StringReader(this.stringRep);
                    return stringReader;
                }
                if (this.asDOMResult != null) {
                    StringReader stringReader = new StringReader(this.domSourceToString());
                    return stringReader;
                }
                if (this.asStringWriter != null) {
                    StringReader stringReader = new StringReader(this.asStringWriter.toString());
                    return stringReader;
                }
                if (this.asSAXResult != null) {
                    Reader reader = this.saxToReaderConverter.toReader();
                    return reader;
                }
                if (this.asByteArrayOutputStream != null) {
                    Reader reader = this.binaryInputStreamStreamToReader(this.asByteArrayOutputStream);
                    return reader;
                }
            }
            Reader reader = this.owningResultSet.getCharacterStream(this.columnIndexOfXml);
            return reader;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected String domSourceToString() throws SQLException {
        try {
            DOMSource source = new DOMSource(this.asDOMResult.getNode());
            Transformer identity = TransformerFactory.newInstance().newTransformer();
            StringWriter stringOut = new StringWriter();
            StreamResult result = new StreamResult(stringOut);
            identity.transform(source, result);
            return stringOut.toString();
        }
        catch (Throwable t2) {
            SQLException sqlEx = SQLError.createSQLException(t2.getMessage(), "S1009", t2, this.exceptionInterceptor);
            throw sqlEx;
        }
    }

    protected String serializeAsString() throws SQLException {
        this.lock.lock();
        try {
            this.checkClosed();
            if (this.workingWithResult) {
                if (this.stringRep != null) {
                    String string = this.stringRep;
                    return string;
                }
                if (this.asDOMResult != null) {
                    String string = this.domSourceToString();
                    return string;
                }
                if (this.asStringWriter != null) {
                    String string = this.asStringWriter.toString();
                    return string;
                }
                if (this.asSAXResult != null) {
                    String string = this.readerToString(this.saxToReaderConverter.toReader());
                    return string;
                }
                if (this.asByteArrayOutputStream != null) {
                    String string = this.readerToString(this.binaryInputStreamStreamToReader(this.asByteArrayOutputStream));
                    return string;
                }
            }
            String string = this.owningResultSet.getString(this.columnIndexOfXml);
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    class SimpleSaxToReader
    extends DefaultHandler {
        StringBuilder buf = new StringBuilder();
        private boolean inCDATA = false;

        SimpleSaxToReader() {
        }

        @Override
        public void startDocument() throws SAXException {
            this.buf.append("<?xml version='1.0' encoding='UTF-8'?>");
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
            this.buf.append("<");
            this.buf.append(qName);
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    this.buf.append(" ");
                    this.buf.append(attrs.getQName(i)).append("=\"");
                    this.escapeCharsForXml(attrs.getValue(i), true);
                    this.buf.append("\"");
                }
            }
            this.buf.append(">");
        }

        @Override
        public void characters(char[] buffer, int offset, int len) throws SAXException {
            if (!this.inCDATA) {
                this.escapeCharsForXml(buffer, offset, len, false);
            } else {
                this.buf.append(buffer, offset, len);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.characters(ch, start, length);
        }

        public void startCDATA() throws SAXException {
            this.buf.append("<![CDATA[");
            this.inCDATA = true;
        }

        public void endCDATA() throws SAXException {
            this.inCDATA = false;
            this.buf.append("]]>");
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            this.buf.append("<!--");
            for (int i = 0; i < length; ++i) {
                this.buf.append(ch[start + i]);
            }
            this.buf.append("-->");
        }

        Reader toReader() {
            return new StringReader(this.buf.toString());
        }

        private void escapeCharsForXml(String str, boolean isAttributeData) {
            if (str == null) {
                return;
            }
            int strLen = str.length();
            for (int i = 0; i < strLen; ++i) {
                this.escapeCharsForXml(str.charAt(i), isAttributeData);
            }
        }

        private void escapeCharsForXml(char[] buffer, int offset, int len, boolean isAttributeData) {
            if (buffer == null) {
                return;
            }
            for (int i = 0; i < len; ++i) {
                this.escapeCharsForXml(buffer[offset + i], isAttributeData);
            }
        }

        private void escapeCharsForXml(char c, boolean isAttributeData) {
            switch (c) {
                case '<': {
                    this.buf.append("&lt;");
                    break;
                }
                case '>': {
                    this.buf.append("&gt;");
                    break;
                }
                case '&': {
                    this.buf.append("&amp;");
                    break;
                }
                case '\"': {
                    if (!isAttributeData) {
                        this.buf.append("\"");
                        break;
                    }
                    this.buf.append("&quot;");
                    break;
                }
                case '\r': {
                    this.buf.append("&#xD;");
                    break;
                }
                default: {
                    if (c >= '\u0001' && c <= '\u001f' && c != '\t' && c != '\n' || c >= '\u007f' && c <= '\u009f' || c == '\u2028' || isAttributeData && (c == '\t' || c == '\n')) {
                        this.buf.append("&#x");
                        this.buf.append(Integer.toHexString(c).toUpperCase());
                        this.buf.append(";");
                        break;
                    }
                    this.buf.append(c);
                }
            }
        }
    }
}

