/*
 * Decompiled with CFR 0.152.
 */
package com.highhybrid.createrecycle;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.content.kinetics.crusher.CrushingRecipe;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateRecycle
implements ModInitializer {
    public static final String ID = "createrecycle";
    public static final String NAME = "Create Recycling";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Create Recycling");

    public void onInitialize() {
        LOGGER.info("Loading {} alongside Create {}", (Object)NAME, (Object)"0.5.1j");
        ServerLifecycleEvents.SERVER_STARTED.register(this::installDatapack);
    }

    private void installDatapack(MinecraftServer server) {
        File worldDir = server.method_27050(class_5218.field_24186).toFile();
        File packFolder = new File(worldDir, ID);
        if (!packFolder.exists()) {
            packFolder.mkdirs();
            JsonObject packMeta = new JsonObject();
            JsonObject packObj = new JsonObject();
            packObj.addProperty("pack_format", (Number)15);
            packObj.addProperty("description", "Create Recycling dynamic recipes");
            packMeta.add("pack", (JsonElement)packObj);
            try (FileWriter writer = new FileWriter(new File(packFolder, "pack.mcmeta"));){
                writer.write(packMeta.toString());
            }
            catch (Exception e) {
                LOGGER.error("Failed to create pack.mcmeta for dynamic recipes", (Throwable)e);
            }
        }
        RecipeInjector injector = new RecipeInjector(server);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)injector);
        injector.apply(server.method_34864());
        LOGGER.info("Installed dynamic recycling datapack listener and performed initial injection");
    }

    private record RecipeInjector(MinecraftServer server) implements SimpleSynchronousResourceReloadListener
    {
        private static final Set<String> FULL_YIELD_ITEMS = Set.of("minecraft:slime_block", "minecraft:honeycomb_block", "minecraft:dried_kelp_block", "minecraft:coal_block", "minecraft:iron_block", "minecraft:gold_block", "minecraft:lapis_block", "minecraft:redstone_block", "minecraft:diamond_block", "minecraft:emerald_block", "minecraft:netherite_block", "create:andesite_alloy_block", "create:brass_block", "create:zinc_block", "create:experience_block", "minecraft:hay_block");
        private static final Set<String> SKIP_RECIPE_ITEMS = Set.of("minecraft:honey_bottle", "minecraft:honey_block");

        public void apply(class_3300 resourceManager) {
            class_1863 rm = this.server.method_3772();
            class_2378 itemRegistry = this.server.method_30611().method_30530(class_7924.field_41197);
            int count = 0;
            Map<class_2960, class_1792> existingCrushingRecipes = this.getExistingCrushingRecipes(rm);
            LOGGER.info("Existing crushing recipes:");
            existingCrushingRecipes.forEach((rl, item) -> LOGGER.info("Recipe: {}, Input: {}", rl, (Object)item.toString()));
            class_6862 planksTag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("minecraft", "planks"));
            class_6862 terracottaTag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("minecraft", "terracotta"));
            class_6862 glassTag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("minecraft", "glass"));
            for (class_3955 cr : rm.method_30027(class_3956.field_17545)) {
                JsonObject recipeJson;
                class_1792 resultItem;
                class_2960 itemRL;
                class_2960 recipeId = cr.method_8114();
                if (recipeId.method_12836().equals(CreateRecycle.ID) || this.shouldSkipRecipe(existingCrushingRecipes, itemRL = itemRegistry.method_10221((Object)(resultItem = cr.method_8110((class_5455)this.server.method_30611()).method_7909())), resultItem, (class_2378<class_1792>)itemRegistry, (class_6862<class_1792>)planksTag, (class_6862<class_1792>)glassTag) || (recipeJson = this.createRecipeJson(cr, resultItem, itemRL, (class_2378<class_1792>)itemRegistry, (class_6862<class_1792>)terracottaTag, (class_6862<class_1792>)glassTag)) == null) continue;
                this.writeRecipeFile(itemRL, recipeJson);
                ++count;
            }
            LOGGER.info("Injected {} recycling recipes", (Object)count);
        }

        private Map<class_2960, class_1792> getExistingCrushingRecipes(class_1863 rm) {
            HashMap<class_2960, class_1792> existingCrushingRecipes = new HashMap<class_2960, class_1792>();
            for (class_1860 recipe : rm.method_8126()) {
                class_1856 firstIngredient;
                class_1799[] matchingStacks;
                CrushingRecipe crushingRecipe;
                if (!recipe.method_8114().method_12832().contains("crushing") || !(recipe instanceof CrushingRecipe) || (crushingRecipe = (CrushingRecipe)recipe).method_8117().isEmpty() || (matchingStacks = (firstIngredient = (class_1856)crushingRecipe.method_8117().get(0)).method_8105()).length <= 0) continue;
                existingCrushingRecipes.put(recipe.method_8114(), matchingStacks[0].method_7909());
            }
            return existingCrushingRecipes;
        }

        private boolean shouldSkipRecipe(Map<class_2960, class_1792> existingCrushingRecipes, class_2960 itemRL, class_1792 resultItem, class_2378<class_1792> itemRegistry, class_6862<class_1792> planksTag, class_6862<class_1792> glassTag) {
            if (existingCrushingRecipes.containsValue(resultItem)) {
                LOGGER.debug("Skipping recipe for {} because a crushing recipe with this item as input already exists", (Object)itemRL);
                return true;
            }
            if (SKIP_RECIPE_ITEMS.contains(itemRL.toString())) {
                LOGGER.debug("Skipping recipe for {} because it's in the SKIP_RECIPE_ITEMS set", (Object)itemRL);
                return true;
            }
            if (itemRegistry.method_40290((class_5321)itemRegistry.method_29113((Object)resultItem).get()).method_40220(planksTag)) {
                LOGGER.debug("Skipping recipe for {} because it has the #planks tag", (Object)itemRL);
                return true;
            }
            if (itemRL.method_12832().endsWith("_glass_pane")) {
                LOGGER.debug("Skipping recipe for {} because it's a glass pane", (Object)itemRL);
                return true;
            }
            if (itemRL.method_12832().endsWith("_wool")) {
                LOGGER.debug("Skipping recipe for {} because it's wool", (Object)itemRL);
                return true;
            }
            if (itemRL.method_12832().startsWith("waxed_")) {
                LOGGER.debug("Skipping recipe for {} because it's a waxed block", (Object)itemRL);
                return true;
            }
            return false;
        }

        private JsonObject createRecipeJson(class_3955 cr, class_1792 resultItem, class_2960 itemRL, class_2378<class_1792> itemRegistry, class_6862<class_1792> terracottaTag, class_6862<class_1792> glassTag) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "create:crushing");
            JsonArray ingredientsArr = new JsonArray();
            ingredientsArr.add(class_1856.method_8101((class_1799[])new class_1799[]{new class_1799((class_1935)resultItem)}).method_8089());
            json.add("ingredients", (JsonElement)ingredientsArr);
            json.addProperty("processingTime", (Number)350);
            JsonArray results = new JsonArray();
            if (itemRegistry.method_40290((class_5321)itemRegistry.method_29113((Object)resultItem).get()).method_40220(terracottaTag)) {
                this.addTerracottaResult(results);
            } else if (itemRL.method_12832().endsWith("_glass")) {
                this.addGlassResult(results, itemRL);
            } else if (resultItem.toString().endsWith("_carpet")) {
                this.addCarpetResult(results);
            } else {
                this.addDefaultResults(cr, itemRL, itemRegistry, results);
            }
            json.add("results", (JsonElement)results);
            LOGGER.debug("Created recipe for {}: {}", (Object)itemRL, (Object)json);
            return json;
        }

        private void addTerracottaResult(JsonArray results) {
            JsonObject sandEntry = new JsonObject();
            sandEntry.addProperty("item", "minecraft:sand");
            sandEntry.addProperty("count", (Number)1);
            results.add((JsonElement)sandEntry);
        }

        private void addGlassResult(JsonArray results, class_2960 itemRL) {
            JsonObject sandEntry = new JsonObject();
            sandEntry.addProperty("item", "minecraft:sand");
            sandEntry.addProperty("count", (Number)1);
            results.add((JsonElement)sandEntry);
        }

        private void addCarpetResult(JsonArray results) {
            JsonObject stringEntry = new JsonObject();
            stringEntry.addProperty("item", "minecraft:string");
            stringEntry.addProperty("count", (Number)1);
            results.add((JsonElement)stringEntry);
        }

        private void addDefaultResults(class_3955 cr, class_2960 itemRL, class_2378<class_1792> itemRegistry, JsonArray results) {
            HashMap<class_1792, Integer> tally = new HashMap<class_1792, Integer>();
            for (class_1856 ing : cr.method_8117()) {
                class_1799[] matches = ing.method_8105();
                if (matches.length == 0) continue;
                tally.merge(matches[0].method_7909(), matches[0].method_7947(), Integer::sum);
            }
            boolean isFullYield = FULL_YIELD_ITEMS.contains(itemRL.toString());
            tally.forEach((item, qty) -> {
                String itemKey = itemRegistry.method_10221(item).toString();
                if (isFullYield) {
                    this.addFullYieldResult(results, itemKey, (int)qty);
                } else {
                    this.addPartialYieldResult(results, itemKey, (int)qty);
                }
            });
        }

        private void addFullYieldResult(JsonArray results, String itemKey, int qty) {
            JsonObject entry = new JsonObject();
            entry.addProperty("item", itemKey);
            entry.addProperty("count", (Number)qty);
            results.add((JsonElement)entry);
        }

        private void addPartialYieldResult(JsonArray results, String itemKey, int qty) {
            boolean hasRemainder;
            int guaranteed = qty / 2;
            boolean bl = hasRemainder = qty % 2 == 1;
            if (guaranteed > 0) {
                JsonObject entry = new JsonObject();
                entry.addProperty("item", itemKey);
                entry.addProperty("count", (Number)guaranteed);
                results.add((JsonElement)entry);
            }
            if (hasRemainder) {
                JsonObject chanceEntry = new JsonObject();
                chanceEntry.addProperty("item", itemKey);
                chanceEntry.addProperty("chance", (Number)0.25);
                results.add((JsonElement)chanceEntry);
            }
        }

        private void writeRecipeFile(class_2960 itemRL, JsonObject json) {
            File worldDir = this.server.method_27050(class_5218.field_24186).toFile();
            File packDir = new File(worldDir, "createrecycle/data/createrecycle/recipes");
            File recipeFile = new File(packDir, itemRL.method_12832() + "_recycle.json");
            packDir.mkdirs();
            try (FileWriter fw = new FileWriter(recipeFile);){
                fw.write(json.toString());
                LOGGER.debug("Successfully wrote recipe file for {} at {}", (Object)itemRL, (Object)recipeFile.getAbsolutePath());
            }
            catch (Exception e) {
                LOGGER.error("Failed to write recipe {} to {}", new Object[]{itemRL, recipeFile.getAbsolutePath(), e});
            }
        }

        public class_2960 getFabricId() {
            return new class_2960(CreateRecycle.ID, "dynamic_recipes");
        }

        public void method_14491(@NotNull class_3300 resourceManager) {
            this.apply(resourceManager);
        }
    }
}

