/*
 * Decompiled with CFR 0.152.
 */
package com.carmellium.antiportals.mixin;

import com.carmellium.antiportals.Constants;
import com.carmellium.antiportals.platform.Services;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnderEyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnderEyeItem.class})
public abstract class MixinEnderEye {
    @Inject(method={"useOn"}, at={@At(value="HEAD", remap=false)}, cancellable=true)
    public void onItemUse(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        if (Services.PLATFORM.shouldOPsBypassDimension() && context.getPlayer().hasPermissions(4)) {
            return;
        }
        if (Services.PLATFORM.isEndDisabled()) {
            Constants.LOG.debug("Someone tried to create end portal at {}", (Object)context.getClickedPos());
            cir.setReturnValue((Object)InteractionResult.PASS);
        }
    }

    @Inject(method={"use"}, at={@At(value="HEAD", remap=false)}, cancellable=true)
    public void onItemUse(Level worldIn, Player playerIn, InteractionHand handIn, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (Services.PLATFORM.shouldOPsBypassDimension() && playerIn.hasPermissions(4)) {
            return;
        }
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        if (Services.PLATFORM.isEnderEyeDisabled()) {
            Constants.LOG.debug("Someone tried to use ender eye at {}", (Object)playerIn.position());
            cir.setReturnValue((Object)InteractionResultHolder.pass((Object)itemstack));
        }
    }
}

