/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.simpledeathimprovements.compat;

import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.events.OnDeathCallback;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.UUID;
import me.pajic.simpledeathimprovements.config.Config;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class AccessoriesCompat {
    private static final Object2ObjectOpenHashMap<UUID, NonNullList<ItemStack>> KEEP_CACHE = new Object2ObjectOpenHashMap();

    public static void init() {
        OnDeathCallback.EVENT.register((currentState, entity, capability, damageSource, droppedStacks) -> {
            switch (Config.keepAccessories) {
                case ALL: {
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        NonNullList keepList = NonNullList.create();
                        droppedStacks.forEach(stack -> {
                            if (!stack.is(Items.AIR)) {
                                keepList.add((Object)stack.copy());
                            }
                        });
                        KEEP_CACHE.put((Object)player.getUUID(), (Object)keepList);
                        return TriState.FALSE;
                    }
                    return currentState;
                }
                case LIST: {
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        NonNullList dropList = NonNullList.create();
                        NonNullList keepList = NonNullList.create();
                        droppedStacks.forEach(stack -> {
                            if (!stack.is(Items.AIR)) {
                                if (Config.accessoryKeepList.contains(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString())) {
                                    keepList.add((Object)stack.copy());
                                } else {
                                    dropList.add(stack);
                                }
                            }
                        });
                        for (int i = 0; i < dropList.size(); ++i) {
                            ItemStack itemStack = (ItemStack)dropList.get(i);
                            if (itemStack.isEmpty()) continue;
                            player.drop(itemStack, !Config.noItemSplatterOnDeath, false);
                            dropList.set(i, (Object)ItemStack.EMPTY);
                        }
                        KEEP_CACHE.put((Object)player.getUUID(), (Object)keepList);
                        return TriState.FALSE;
                    }
                    return currentState;
                }
            }
            return currentState;
        });
    }

    public static void restoreAccessoryInventory(ServerPlayer respawnedPlayer) {
        AccessoriesCapability.getOptionally((LivingEntity)respawnedPlayer).ifPresent(ac -> {
            UUID uuid = respawnedPlayer.getUUID();
            if (KEEP_CACHE.containsKey((Object)uuid)) {
                ((NonNullList)KEEP_CACHE.get((Object)uuid)).forEach(arg_0 -> ((AccessoriesCapability)ac).attemptToEquipAccessory(arg_0));
                KEEP_CACHE.remove((Object)uuid);
            }
        });
    }
}

