/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.simpledeathimprovements.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import me.pajic.simpledeathimprovements.config.Config;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(value={Inventory.class})
public class InventoryMixin {
    @Shadow
    @Final
    public NonNullList<ItemStack> items;
    @Shadow
    @Final
    public NonNullList<ItemStack> armor;
    @Shadow
    @Final
    public NonNullList<ItemStack> offhand;

    @ModifyArg(method={"dropAll"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"), index=1)
    private boolean preventItemSplatterOnDeath(boolean dropAround) {
        if (Config.noItemSplatterOnDeath) {
            return false;
        }
        return dropAround;
    }

    @ModifyExpressionValue(method={"dropAll"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z")})
    private boolean keepItems(boolean original, @Local List<ItemStack> list, @Local int i) {
        if (Config.keepArmorOnDeath && list.equals(this.armor)) {
            return true;
        }
        if (Config.keepHotbarOnDeath) {
            if (list.equals(this.offhand)) {
                return true;
            }
            if (list.equals(this.items) && i < 9) {
                return true;
            }
        }
        return original;
    }
}

