/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.simpledeathimprovements.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.authlib.GameProfile;
import me.pajic.simpledeathimprovements.Main;
import me.pajic.simpledeathimprovements.compat.AccessoriesCompat;
import me.pajic.simpledeathimprovements.config.AccessoryKeepMode;
import me.pajic.simpledeathimprovements.config.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Player {
    @Unique
    ServerPlayer self = (ServerPlayer)this;
    @Unique
    BlockPos lastSafePos = BlockPos.ZERO;

    @Shadow
    public abstract ServerLevel serverLevel();

    public ServerPlayerMixin(Level level, BlockPos pos, float yRot, GameProfile gameProfile) {
        super(level, pos, yRot, gameProfile);
    }

    @WrapMethod(method={"restoreFrom"})
    private void restoreItems(ServerPlayer that, boolean keepEverything, Operation<Void> original) {
        if (!(keepEverything || that.isSpectator() || this.serverLevel().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY))) {
            if (Config.keepArmorOnDeath || Config.keepHotbarOnDeath) {
                this.getInventory().replaceWith(that.getInventory());
            }
            if (Main.ACCESSORIES_LOADED && Config.keepAccessories != AccessoryKeepMode.NONE) {
                AccessoriesCompat.restoreAccessoryInventory(that);
            }
        }
        original.call(new Object[]{that, keepEverything});
    }

    @Inject(method={"createItemStackToDrop"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;setPickUpDelay(I)V")})
    private void preventItemDespawnOnDeath(ItemStack droppedItem, boolean dropAround, boolean includeThrowerName, CallbackInfoReturnable<ItemEntity> cir, @Local ItemEntity itemEntity) {
        if (Config.noDeathItemDespawn && this.self.isDeadOrDying()) {
            itemEntity.setUnlimitedLifetime();
        }
    }

    @ModifyArgs(method={"createItemStackToDrop"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;setDeltaMovement(DDD)V", ordinal=1))
    private void preventItemThrowOnDeath(Args args) {
        if (Config.noItemSplatterOnDeath && this.self.isDeadOrDying()) {
            args.setAll(new Object[]{0.0, 0.0, 0.0});
        }
    }

    @WrapOperation(method={"createItemStackToDrop"}, at={@At(value="NEW", target="(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/entity/item/ItemEntity;")})
    private ItemEntity trySaveItemsOnDeath(Level level, double posX, double posY, double posZ, ItemStack itemStack, Operation<ItemEntity> original) {
        if (!this.lastSafePos.equals((Object)BlockPos.ZERO) && this.self.isDeadOrDying() && (Config.tryItemLavaSaveOnDeath && this.self.isInLava() || Config.tryItemVoidSaveOnDeath && this.self.getY() < (double)(level.getMinY() - 64))) {
            return (ItemEntity)original.call(new Object[]{level, (double)this.lastSafePos.getX(), (double)this.lastSafePos.getY() + 1.0, (double)this.lastSafePos.getZ(), itemStack});
        }
        return (ItemEntity)original.call(new Object[]{level, posX, posY, posZ, itemStack});
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void trackLastSafeSpot(CallbackInfo ci) {
        if (this.self.getBlockStateOn().entityCanStandOn((BlockGetter)this.self.level(), this.self.getOnPos(), (Entity)this.self) && !this.self.isInLava()) {
            this.lastSafePos = this.self.getOnPos();
        }
    }
}

