/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.simple_death_improvements.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import me.pajic.simple_death_improvements.SDI;
import me.pajic.simple_death_improvements.access.PlayerAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={Player.class})
public abstract class PlayerMixin
implements PlayerAccess {
    @Unique
    Player self = (Player)this;
    @Unique
    BlockPos lastSafePos = BlockPos.ZERO;
    @Unique
    boolean startedTrackingSafePos = false;
    @Unique
    int delayBeforeTracking = 100;

    @Shadow
    public abstract Component getDisplayName();

    @Inject(method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;setPickUpDelay(I)V")})
    private void preventItemDespawnOnDeath(ItemStack droppedItem, boolean dropAround, boolean includeThrowerName, CallbackInfoReturnable<ItemEntity> cir, @Local ItemEntity itemEntity) {
        if (((Boolean)SDI.CONFIG.noDeathItemDespawn.get()).booleanValue() && this.self.isDeadOrDying()) {
            itemEntity.setUnlimitedLifetime();
            SDI.debugLog("Set infinite lifetime to items dropped by player {}", this.self.getDisplayName().getString());
        }
    }

    @ModifyArgs(method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;setDeltaMovement(DDD)V"))
    private void preventItemThrowOnDeath(Args args) {
        if (((Boolean)SDI.CONFIG.noItemSplatterOnDeath.get()).booleanValue() && this.self.isDeadOrDying()) {
            args.setAll(new Object[]{0.0, 0.0, 0.0});
            SDI.debugLog("Prevented item splatter for player {}", this.self.getDisplayName().getString());
        }
    }

    @WrapOperation(method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="NEW", target="(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/entity/item/ItemEntity;")})
    private ItemEntity trySaveItemsOnDeath(Level level, double posX, double posY, double posZ, ItemStack itemStack, Operation<ItemEntity> original) {
        if (!this.lastSafePos.equals((Object)BlockPos.ZERO) && this.self.isDeadOrDying() && (((Boolean)SDI.CONFIG.tryItemLavaSaveOnDeath.get()).booleanValue() && this.self.isInLava() || ((Boolean)SDI.CONFIG.tryItemVoidSaveOnDeath.get()).booleanValue() && this.self.getY() < (double)(level.getMinBuildHeight() - 64))) {
            SDI.debugLog("Dropped items for player {} at {} {} {}", this.self.getDisplayName().getString(), this.lastSafePos.getX(), this.lastSafePos.getY(), this.lastSafePos.getZ());
            return (ItemEntity)original.call(new Object[]{level, (double)this.lastSafePos.getX() + 0.5, (double)this.lastSafePos.getY() + 1.0, (double)this.lastSafePos.getZ() + 0.5, itemStack});
        }
        return (ItemEntity)original.call(new Object[]{level, posX, posY, posZ, itemStack});
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void trackLastSafeSpot(CallbackInfo ci) {
        BlockPos pos = this.self.getOnPos();
        if (this.delayBeforeTracking > 0) {
            --this.delayBeforeTracking;
        } else if (pos != BlockPos.ZERO && this.self.getBlockStateOn().entityCanStandOn((BlockGetter)this.self.level(), pos, (Entity)this.self) && !this.self.isInLava()) {
            if (!this.startedTrackingSafePos) {
                this.startedTrackingSafePos = true;
                SDI.debugLog("Started tracking last safe position for player {}", this.self.getDisplayName().getString());
            }
            this.lastSafePos = pos;
        }
    }

    @WrapMethod(method={"getBaseExperienceReward"})
    private int modifyDroppedXpOnDeath(Operation<Integer> original) {
        if (((Boolean)SDI.CONFIG.playerDropMoreXpOnDeath.get()).booleanValue() && !this.self.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) {
            int xp = 0;
            int xpLevel = this.self.experienceLevel;
            int i = 0;
            while (i < xpLevel) {
                this.self.experienceLevel = i++;
                xp += this.self.getXpNeededForNextLevel();
            }
            this.self.experienceLevel = xpLevel;
            return (int)((float)(xp += (int)(this.self.experienceProgress * (float)this.self.getXpNeededForNextLevel())) * (float)((Integer)SDI.CONFIG.droppedExperiencePercent.get()).intValue() / 100.0f);
        }
        return (Integer)original.call(new Object[0]);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void saveLastSafeSpot(CompoundTag compound, CallbackInfo ci) {
        compound.putInt("LastSafePosX", this.lastSafePos.getX());
        compound.putInt("LastSafePosY", this.lastSafePos.getY());
        compound.putInt("LastSafePosZ", this.lastSafePos.getZ());
        SDI.debugLog("Saved safe position {} {} {} for player {}", this.lastSafePos.getX(), this.lastSafePos.getY(), this.lastSafePos.getZ(), this.getDisplayName().getString());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void loadLastSafeSpot(CompoundTag compound, CallbackInfo ci) {
        int x = compound.getInt("LastSafePosX");
        int y = compound.getInt("LastSafePosY");
        int z = compound.getInt("LastSafePosZ");
        this.lastSafePos = new BlockPos(x, y, z);
        SDI.debugLog("Loaded safe position {} {} {} for player {}", x, y, z, this.getDisplayName().getString());
    }

    @Override
    public BlockPos sdi$getLastSafeBlockPosition() {
        return this.lastSafePos;
    }
}

