package me.pajic.simple_death_improvements.config;

import me.fzzyhmstrs.fzzy_config.annotations.Version;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedList;
import me.fzzyhmstrs.fzzy_config.validation.minecraft.ValidatedIdentifier;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedBoolean;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedEnum;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import me.pajic.simple_death_improvements.SDI;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

@Version(version = 1)
public class ModConfig extends Config {
    public ModConfig() {
        super(SDI.CONFIG_RL);
    }

	public ValidatedBoolean noItemSplatterOnDeath = new ValidatedBoolean(true);
	public ValidatedBoolean noDeathItemDespawn = new ValidatedBoolean(true);
	public ValidatedBoolean tryItemLavaSaveOnDeath = new ValidatedBoolean(true);
	public ValidatedBoolean tryItemVoidSaveOnDeath = new ValidatedBoolean(true);
	public ValidatedBoolean explosionResistantItems = new ValidatedBoolean(true);
	public ValidatedBoolean playerDropMoreXpOnDeath = new ValidatedBoolean(true);
	public ValidatedInt droppedExperiencePercent = new ValidatedInt(80, 100, 1);
	public ValidatedBoolean keepArmorOnDeath = new ValidatedBoolean(false);
	public ValidatedList<class_2960> armorDropList = ValidatedIdentifier.ofRegistry(class_2960.method_60656("diamond_chestplate"), class_7923.field_41178).toList();
	public ValidatedBoolean keepHotbarOnDeath = new ValidatedBoolean(false);
	public ValidatedList<class_2960> hotbarDropList = ValidatedIdentifier.ofRegistry(class_2960.method_60656("diamond_pickaxe"), class_7923.field_41178).toList();
	public ValidatedEnum<AccessoryKeepMode> keepAccessories = new ValidatedEnum<>(AccessoryKeepMode.NONE);
	public ValidatedList<class_2960> accessoryKeepList = ValidatedIdentifier.ofRegistry(class_2960.method_60656("diamond"), class_7923.field_41178).toList();
}
