package me.pajic.simple_death_improvements.mixin;

//? if > 1.21.1 {

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import me.pajic.simple_death_improvements.SDI;
import net.minecraft.class_10630;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

import java.util.EnumMap;

@Mixin(class_10630.class)
public abstract class EntityEquipmentMixin {

    @Shadow @Final private EnumMap<class_1304, class_1799> items;

    @WrapMethod(method = "dropAll")
    private void keepOffhandAndEquipment(class_1309 entity, Operation<Void> original) {
        if (entity instanceof class_1657 && SDI.CONFIG.keepHotbarOnDeath.get() || SDI.CONFIG.keepArmorOnDeath.get()) {
            items.replaceAll((slot, stack) -> {
                if (SDI.CONFIG.keepHotbarOnDeath.get() && slot.equals(class_1304.field_6171) &&
                        !SDI.CONFIG.hotbarDropList.contains(SDI.getItemId(stack))) return stack;
                if (SDI.CONFIG.keepArmorOnDeath.get() && !SDI.CONFIG.armorDropList.contains(SDI.getItemId(stack)) && (
                        slot.equals(class_1304.field_6169) ||
                        slot.equals(class_1304.field_6174) ||
                        slot.equals(class_1304.field_6172) ||
                        slot.equals(class_1304.field_6166)
                )) return stack;
                entity.method_7329(stack, !SDI.CONFIG.noItemSplatterOnDeath.get(), false);
                return class_1799.field_8037;
            });
        }
        else original.call(entity);
    }

    @ModifyArg(
            method = "dropAll",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/LivingEntity;drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"
            ),
            index = 1
    )
    private boolean preventItemSplatterOnDeath(boolean dropAround) {
		return !SDI.CONFIG.noItemSplatterOnDeath.get() && dropAround;
    }
}
//?}
