package me.pajic.simple_death_improvements.mixin;

//? if > 1.21.1 {

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import me.pajic.simple_death_improvements.SDI;
import me.pajic.simple_death_improvements.access.PlayerAccess;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(class_1309.class)
public class LivingEntityMixin {


    @Unique class_1309 self = (class_1309) (Object) this;

    @Inject(
            method = "createItemStackToDrop",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/item/ItemEntity;setPickUpDelay(I)V"
            )
    )
    private void preventItemDespawnOnDeath(class_1799 droppedItem, boolean dropAround, boolean includeThrowerName, CallbackInfoReturnable<class_1542> cir,
                                           @Local class_1542 itemEntity
    ) {
        if (self instanceof class_1657 && SDI.CONFIG.noDeathItemDespawn.get() && self.method_29504()) {
            itemEntity.method_35190();
			SDI.debugLog("Set infinite lifetime to items dropped by player {}", self.method_5476().getString());
        }
    }

    @ModifyArgs(
            method = "createItemStackToDrop",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/item/ItemEntity;setDeltaMovement(DDD)V"
            )
    )
    private void preventItemThrowOnDeath(Args args) {
        if (self instanceof class_1657 && SDI.CONFIG.noItemSplatterOnDeath.get() && self.method_29504()) {
            args.setAll(0.0d, 0.0d, 0.0d);
			SDI.debugLog("Prevented item splatter for player {}", self.method_5476().getString());
        }
    }

    @WrapOperation(
            method = "createItemStackToDrop",
            at = @At(
                    value = "NEW",
                    target = "(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/entity/item/ItemEntity;"
            )
    )
    private class_1542 trySaveItemsOnDeath(class_1937 level, double posX, double posY, double posZ, class_1799 itemStack, Operation<class_1542> original) {
        if (self instanceof class_1657 player && self.method_29504()) {
            class_2338 lastSafePos = ((PlayerAccess) player).sdi$getLastSafeBlockPosition();
            if (!lastSafePos.equals(class_2338.field_10980) && SDI.CONFIG.tryItemLavaSaveOnDeath.get() && self.method_5771() || SDI.CONFIG.tryItemVoidSaveOnDeath.get() && self.method_23318() < (double) (level.method_31607() - 64)) {
				SDI.debugLog("Dropped items for player {} at {} {} {}", self.method_5476().getString(), lastSafePos.method_10263(), lastSafePos.method_10264(), lastSafePos.method_10260());
                return original.call(level, (double) lastSafePos.method_10263() + 0.5, (double) lastSafePos.method_10264() + 1, (double) lastSafePos.method_10260() + 0.5, itemStack);
            }
        }
        return original.call(level, posX, posY, posZ, itemStack);
    }
}
//?}
