package me.pajic.simple_death_improvements.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import me.pajic.simple_death_improvements.SDI;
import me.pajic.simple_death_improvements.access.PlayerAccess;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_1657.class)
public abstract class PlayerMixin implements PlayerAccess {

    @Shadow public abstract class_2561 getDisplayName();

    @Unique class_1657 self = (class_1657) (Object) this;
    @Unique class_2338 lastSafePos = class_2338.field_10980;
    @Unique boolean startedTrackingSafePos = false;
    @Unique int delayBeforeTracking = 100;

    //? if 1.21.1 {
    /*@Inject(
            method = "drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/item/ItemEntity;setPickUpDelay(I)V"
            )
    )
    private void preventItemDespawnOnDeath(ItemStack droppedItem, boolean dropAround, boolean includeThrowerName, CallbackInfoReturnable<ItemEntity> cir,
                              @Local ItemEntity itemEntity
    ) {
        if (SDI.CONFIG.noDeathItemDespawn.get() && self.isDeadOrDying()) {
            itemEntity.setUnlimitedLifetime();
            SDI.debugLog("Set infinite lifetime to items dropped by player {}", self.getDisplayName().getString());
        }
    }

    @ModifyArgs(
            method = "drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/item/ItemEntity;setDeltaMovement(DDD)V"
            )
    )
    private void preventItemThrowOnDeath(Args args) {
        if (SDI.CONFIG.noItemSplatterOnDeath.get() && self.isDeadOrDying()) {
            args.setAll(0.0d, 0.0d, 0.0d);
            SDI.debugLog("Prevented item splatter for player {}", self.getDisplayName().getString());
        }
    }

    @WrapOperation(
            method = "drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;",
            at = @At(
                    value = "NEW",
                    target = "(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/entity/item/ItemEntity;"
            )
    )
    private ItemEntity trySaveItemsOnDeath(Level level, double posX, double posY, double posZ, ItemStack itemStack, Operation<ItemEntity> original) {
        if (!lastSafePos.equals(BlockPos.ZERO) && self.isDeadOrDying()) {
            if (SDI.CONFIG.tryItemLavaSaveOnDeath.get() && self.isInLava() || SDI.CONFIG.tryItemVoidSaveOnDeath.get() && self.getY() < (double) (level.getMinBuildHeight() - 64)) {
                SDI.debugLog("Dropped items for player {} at {} {} {}", self.getDisplayName().getString(), lastSafePos.getX(), lastSafePos.getY(), lastSafePos.getZ());
                return original.call(level, (double) lastSafePos.getX() + 0.5, (double) lastSafePos.getY() + 1, (double) lastSafePos.getZ() + 0.5, itemStack);
            }
        }
        return original.call(level, posX, posY, posZ, itemStack);
    }
    *///?}

    @Inject(
            method = "tick",
            at = @At("HEAD")
    )
    private void trackLastSafeSpot(CallbackInfo ci) {
        class_2338 pos = self.method_23312();
        if (delayBeforeTracking > 0) delayBeforeTracking--;
        else if (pos != class_2338.field_10980 && self.method_25936().method_26168(self.method_73183(), pos, self) && !self.method_5771()) {
            if (!startedTrackingSafePos) {
                startedTrackingSafePos = true;
				SDI.debugLog("Started tracking last safe position for player {}", self.method_5476().getString());
            }
            lastSafePos = pos;
        }
    }

    @WrapMethod(method = "getBaseExperienceReward")
    //? if 1.21.1
    //private int modifyDroppedXpOnDeath(Operation<Integer> original) {
    //? if > 1.21.1
    private int modifyDroppedXpOnDeath(class_3218 level, Operation<Integer> original) {
        //? if 1.21.1
        //if (SDI.CONFIG.playerDropMoreXpOnDeath.get() && !self.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) {
        //? if > 1.21.1
        if (SDI.CONFIG.playerDropMoreXpOnDeath.get() && !level.method_64395()./*? if > 1.21.10 {*//*get*//*?} else {*/method_8355/*?}*/(class_1928./*? if > 1.21.10 {*//*KEEP_INVENTORY*//*?} else {*/field_19389/*?}*/)) {
            int xp = 0;
            int xpLevel = self.field_7520;
            for (int i = 0; i < xpLevel; i++) {
                self.field_7520 = i;
                xp += self.method_7349();
            }
            self.field_7520 = xpLevel;
            xp += (int) (self.field_7510 * self.method_7349());
            return (int) (xp * (float) SDI.CONFIG.droppedExperiencePercent.get() / 100);
        }
        //? if 1.21.1
        //return original.call();
        //? if > 1.21.1
        return original.call(level);
    }

    //? if 1.21.1 {
    /*@Inject(
            method = "addAdditionalSaveData",
            at = @At("TAIL")
    )
    private void saveLastSafeSpot(CompoundTag compound, CallbackInfo ci) {
        compound.putInt("LastSafePosX", lastSafePos.getX());
        compound.putInt("LastSafePosY", lastSafePos.getY());
        compound.putInt("LastSafePosZ", lastSafePos.getZ());
        SDI.debugLog("Saved safe position {} {} {} for player {}", lastSafePos.getX(), lastSafePos.getY(), lastSafePos.getZ(), getDisplayName().getString());
    }

    @Inject(
            method = "readAdditionalSaveData",
            at = @At("TAIL")
    )
    private void loadLastSafeSpot(CompoundTag compound, CallbackInfo ci) {
        int x = compound.getInt("LastSafePosX");
        int y = compound.getInt("LastSafePosY");
        int z = compound.getInt("LastSafePosZ");
        lastSafePos = new BlockPos(x, y, z);
        SDI.debugLog("Loaded safe position {} {} {} for player {}", x, y, z, getDisplayName().getString());
    }
    *///?} else {
    @Inject(
            method = "addAdditionalSaveData",
            at = @At("TAIL")
    )
    private void saveLastSafeSpot(class_11372 output, CallbackInfo ci) {
        output.method_71465("LastSafePosX", lastSafePos.method_10263());
        output.method_71465("LastSafePosY", lastSafePos.method_10264());
        output.method_71465("LastSafePosZ", lastSafePos.method_10260());
		SDI.debugLog("Saved safe position {} {} {} for player {}", lastSafePos.method_10263(), lastSafePos.method_10264(), lastSafePos.method_10260(), getDisplayName().getString());
    }

    @Inject(
            method = "readAdditionalSaveData",
            at = @At("TAIL")
    )
    private void loadLastSafeSpot(class_11368 input, CallbackInfo ci) {
        int x = input.method_71424("LastSafePosX", 0);
        int y = input.method_71424("LastSafePosY", 0);
        int z = input.method_71424("LastSafePosZ", 0);
        lastSafePos = new class_2338(x, y, z);
		SDI.debugLog("Loaded safe position {} {} {} for player {}", x, y, z, getDisplayName().getString());
    }
    //?}

    @Override
    public class_2338 sdi$getLastSafeBlockPosition() {
        return lastSafePos;
    }
}
