/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.maceDash;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class DashMace
implements CommandExecutor,
Listener {
    private final JavaPlugin plugin;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final String MACE_NAME = "\u00a7dDash Mace";
    private double dashDistance;
    private long cooldownMs;

    public DashMace(JavaPlugin plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        plugin.saveDefaultConfig();
        this.dashDistance = plugin.getConfig().getDouble("dash-distance", 2.0);
        this.cooldownMs = plugin.getConfig().getLong("cooldown-seconds", 10L) * 1000L;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        player.getInventory().addItem(new ItemStack[]{this.createDashMace()});
        player.sendMessage("\u00a7aYou received the \u00a7dDash Mace\u00a7a!");
        return true;
    }

    private ItemStack createDashMace() {
        ItemStack mace = new ItemStack(Material.MACE);
        ItemMeta meta = mace.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7dDash Mace");
            meta.addEnchant(Enchantment.KNOCKBACK, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            mace.setItemMeta(meta);
        }
        return mace;
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getItem() == null || !event.getItem().hasItemMeta()) {
            return;
        }
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack item = event.getItem();
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !"\u00a7dDash Mace".equals(meta.getDisplayName())) {
            return;
        }
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        long now = System.currentTimeMillis();
        if (this.cooldowns.containsKey(uuid) && now - this.cooldowns.get(uuid) < this.cooldownMs) {
            return;
        }
        Vector dashDirection = player.getLocation().getDirection().normalize().multiply(this.dashDistance);
        player.setVelocity(dashDirection);
        player.setCooldown(Material.MACE, (int)(this.cooldownMs / 50L));
        player.playSound(player.getLocation(), Sound.ENTITY_ENDER_DRAGON_FLAP, 1.0f, 1.2f);
        this.cooldowns.put(uuid, now);
    }
}

