/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.network.message;

import com.misterpemodder.shulkerboxtooltip.impl.network.context.MessageContext;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.MessageType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.PlayerEnderChestContainer;

public record S2CEnderChestUpdate(@Nullable ListTag nbtInventory) {
    private static final S2CEnderChestUpdate EMPTY = new S2CEnderChestUpdate(null);

    public static S2CEnderChestUpdate create(PlayerEnderChestContainer inventory, HolderLookup.Provider registries) {
        return new S2CEnderChestUpdate(inventory.createTag(registries));
    }

    public static class Type
    implements MessageType<S2CEnderChestUpdate> {
        @Override
        public void encode(S2CEnderChestUpdate message, FriendlyByteBuf buf) {
            CompoundTag compound = new CompoundTag();
            compound.put("inv", (Tag)Objects.requireNonNull(message.nbtInventory));
            buf.writeNbt((Tag)compound);
        }

        @Override
        public S2CEnderChestUpdate decode(FriendlyByteBuf buf) {
            return Optional.ofNullable(buf.readNbt()).flatMap(compound -> compound.getList("inv")).map(S2CEnderChestUpdate::new).orElse(EMPTY);
        }

        @Override
        public void onReceive(S2CEnderChestUpdate message, MessageContext<S2CEnderChestUpdate> context) {
            if (message.nbtInventory == null) {
                return;
            }
            Minecraft.getInstance().execute(() -> {
                if (Minecraft.getInstance().player != null) {
                    LocalPlayer player = Minecraft.getInstance().player;
                    player.getEnderChestInventory().fromTag(message.nbtInventory, (HolderLookup.Provider)player.registryAccess());
                }
            });
        }
    }
}

