/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.config.gui;

import com.misterpemodder.shulkerboxtooltip.impl.PluginManager;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.ConfigCategoryTab;
import com.misterpemodder.shulkerboxtooltip.impl.tree.CategoryConfigNode;
import com.misterpemodder.shulkerboxtooltip.impl.tree.RootConfigNode;
import com.mojang.blaze3d.opengl.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.TabButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ConfigScreen<C>
extends Screen {
    private final RootConfigNode<C> root;
    private final C config;
    private final Consumer<C> onSave;
    private final Screen previous;
    private final HeaderAndFooterLayout layout;
    private final TabManager tabManager;
    private TabNavigationBar tabNavigationBar;
    private List<ConfigCategoryTab<C>> tabs;
    private Button quitButton;
    private Button saveAndQuitButton;
    private static final Component CANCEL_LABEL = CommonComponents.GUI_CANCEL;
    private static final Component QUIT_UNSAVED_LABEL = Component.translatable((String)"shulkerboxtooltip.config.quit.unsaved");
    private static final Component SAVE_LABEL = Component.translatable((String)"shulkerboxtooltip.config.save");
    private static final Component CANNOT_SAVE_LABEL = Component.translatable((String)"shulkerboxtooltip.config.cannot_save");
    private static final Component QUIT_CONFIRM_LABEL = Component.translatable((String)"shulkerboxtooltip.config.quit.confirm");
    private static final Component QUIT_CONFIRM_TITLE = Component.translatable((String)"shulkerboxtooltip.config.quit.confirm.title");
    private static final Component QUIT_CONFIRM_WARNING = Component.translatable((String)"shulkerboxtooltip.config.quit.confirm.warning");
    private static final Component RESTART_REQUIRED_LABEL = Component.translatable((String)"shulkerboxtooltip.config.restart_required");
    private static final Component RESTART_REQUIRED_TITLE = Component.translatable((String)"shulkerboxtooltip.config.restart_required.title");
    private static final Component EXIT_MINECRAFT_LABEL = Component.translatable((String)"shulkerboxtooltip.config.exit_minecraft");
    private static final Component IGNORE_RESTART_LABEL = Component.translatable((String)"shulkerboxtooltip.config.ignore_restart");

    public ConfigScreen(Screen previous, RootConfigNode<C> root, C config, Consumer<C> onSave) {
        super(root.getTitle());
        PluginManager.loadColors();
        this.root = root;
        this.config = config;
        this.onSave = onSave;
        this.previous = previous;
        this.layout = new HeaderAndFooterLayout((Screen)this, 24, 33);
        this.tabManager = new TabManager(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        }, x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.tabs = List.of();
    }

    protected void init() {
        this.root.resetToActive(this.config);
        TabNavigationBar.Builder tabNavigationBarBuilder = TabNavigationBar.builder((TabManager)this.tabManager, (int)this.width);
        this.tabs = new ArrayList<ConfigCategoryTab<C>>();
        for (CategoryConfigNode category : this.root.getCategories()) {
            ConfigCategoryTab<C> tab = new ConfigCategoryTab<C>(this, category, this.config);
            tabNavigationBarBuilder.addTabs(new Tab[]{tab});
            this.tabs.add(tab);
        }
        this.tabNavigationBar = tabNavigationBarBuilder.build();
        this.initTabs(this.tabNavigationBar);
        this.addRenderableWidget((GuiEventListener)this.tabNavigationBar);
        LinearLayout footerLayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        this.quitButton = (Button)footerLayout.addChild((LayoutElement)Button.builder((Component)this.getQuitLabel(), b -> this.onClose()).width(200).build());
        this.saveAndQuitButton = (Button)footerLayout.addChild((LayoutElement)Button.builder((Component)this.getSaveLabel(), b -> this.saveAndQuit()).width(200).build());
        this.saveAndQuitButton.active = !this.root.isActiveValue(this.config) && this.root.validate(this.config) == null;
        this.layout.visitWidgets(abstractWidget -> {
            abstractWidget.setTabOrderGroup(1);
            this.addRenderableWidget((GuiEventListener)abstractWidget);
        });
        this.tabNavigationBar.selectTab(0, false);
        this.repositionElements();
    }

    private void initTabs(TabNavigationBar bar) {
        int i = 0;
        for (GuiEventListener child : bar.children()) {
            if (!(child instanceof TabButton)) continue;
            TabButton tabButton = (TabButton)child;
            this.tabs.get(i).setTabButton(tabButton);
            ++i;
        }
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        GlStateManager._enableBlend();
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Screen.FOOTER_SEPARATOR, 0, this.height - this.getFooterHeight() - 2, 0.0f, 0.0f, this.width, 2, 32, 2);
        GlStateManager._disableBlend();
    }

    protected void repositionElements() {
        this.refresh();
        if (this.tabNavigationBar != null) {
            this.tabNavigationBar.setWidth(this.width);
            this.tabNavigationBar.arrangeElements();
            int i = this.tabNavigationBar.getRectangle().bottom();
            ScreenRectangle screenRectangle = new ScreenRectangle(0, i, this.width, this.height - this.layout.getFooterHeight() - i);
            this.tabManager.setTabArea(screenRectangle);
            this.layout.setHeaderHeight(i);
            this.layout.arrangeElements();
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.tabManager.getCurrentTab() != null && ((ConfigCategoryTab)this.tabManager.getCurrentTab()).keyPressed(keyCode, scanCode) || this.tabNavigationBar.keyPressed(keyCode) || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onClose() {
        if (this.root.isActiveValue(this.config)) {
            this.getMinecraft().setScreen(this.previous);
            return;
        }
        this.getMinecraft().setScreen((Screen)new ConfirmScreen(confirmed -> this.getMinecraft().setScreen((Screen)(confirmed ? this.previous : this)), QUIT_CONFIRM_TITLE, QUIT_CONFIRM_WARNING, QUIT_CONFIRM_LABEL, CANCEL_LABEL));
    }

    public void saveAndQuit() {
        boolean restartRequired = this.root.restartRequired(this.config);
        this.root.writeEditingToConfig(this.config);
        this.onSave.accept(this.config);
        if (restartRequired) {
            this.getMinecraft().setScreen((Screen)new ConfirmScreen(confirmed -> {
                if (confirmed) {
                    this.getMinecraft().stop();
                } else {
                    this.getMinecraft().setScreen(this.previous);
                }
            }, RESTART_REQUIRED_TITLE, RESTART_REQUIRED_LABEL, EXIT_MINECRAFT_LABEL, IGNORE_RESTART_LABEL));
        } else {
            this.getMinecraft().setScreen(this.previous);
        }
    }

    public Minecraft getMinecraft() {
        return Objects.requireNonNull(this.minecraft);
    }

    public int getHeaderHeight() {
        return this.layout.getHeaderHeight();
    }

    public int getFooterHeight() {
        return this.layout.getFooterHeight();
    }

    public void refresh() {
        this.tabs.forEach(ConfigCategoryTab::refresh);
        this.saveAndQuitButton.active = !this.root.isActiveValue(this.config) && this.root.validate(this.config) == null;
        this.quitButton.setMessage(this.getQuitLabel());
        this.saveAndQuitButton.setMessage(this.getSaveLabel());
    }

    private Component getQuitLabel() {
        return this.root.isActiveValue(this.config) ? CANCEL_LABEL : QUIT_UNSAVED_LABEL;
    }

    private Component getSaveLabel() {
        return this.root.validate(this.config) == null ? SAVE_LABEL : CANNOT_SAVE_LABEL;
    }
}

