/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.network.forge;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.network.ClientNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.network.channel.C2SChannel;
import com.misterpemodder.shulkerboxtooltip.impl.network.forge.ForgeC2SChannel;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.C2SMessages;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.MessageType;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.S2CMessages;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;

public final class ClientNetworkingImpl {
    public static final Map<ResourceLocation, ForgeC2SChannel<?>> C2S_CHANNELS = new HashMap();

    private ClientNetworkingImpl() {
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onJoinServer(ClientPlayerNetworkEvent.LoggingIn event) {
        if (ShulkerBoxTooltip.config.preview.serverIntegration) {
            S2CMessages.registerAll();
        }
        ClientNetworking.onJoinServer(Minecraft.getInstance());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onLeaveServer(ClientPlayerNetworkEvent.LoggingOut event) {
        if (ShulkerBoxTooltip.config.preview.serverIntegration) {
            C2SMessages.onDisconnectFromServer();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void init() {
        S2CMessages.registerPayloadTypes();
        C2SMessages.registerPayloadTypes();
        MinecraftForge.EVENT_BUS.register(ClientNetworkingImpl.class);
    }

    public static <T> C2SChannel<T> createC2SChannel(ResourceLocation id, MessageType<T> type) {
        ForgeC2SChannel<T> channel = new ForgeC2SChannel<T>(id, type);
        C2S_CHANNELS.put(id, channel);
        return channel;
    }
}

