/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.renderer;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltipClient;
import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.config.PreviewConfiguration;
import com.misterpemodder.shulkerboxtooltip.api.provider.EmptyPreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.renderer.PreviewRenderer;
import com.misterpemodder.shulkerboxtooltip.impl.hook.GuiGraphicsExtensions;
import com.misterpemodder.shulkerboxtooltip.impl.util.MergedItemStack;
import com.misterpemodder.shulkerboxtooltip.impl.util.ShulkerBoxTooltipUtil;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class BasePreviewRenderer
implements PreviewRenderer {
    protected PreviewType previewType;
    protected PreviewConfiguration config;
    protected int compactMaxRowSize;
    protected int maxRowSize = 9;
    protected ResourceLocation textureOverride;
    protected PreviewProvider provider;
    protected List<ItemStack> fullItems = List.of();
    protected List<MergedItemStack> compactItems = List.of();
    protected PreviewContext previewContext;
    protected final int slotWidth;
    protected final int slotHeight;
    protected final int slotXOffset;
    protected final int slotYOffset;

    protected BasePreviewRenderer(int slotWidth, int slotHeight, int slotXOffset, int slotYOffset) {
        this.previewType = PreviewType.FULL;
        this.slotWidth = slotWidth;
        this.slotHeight = slotHeight;
        this.slotXOffset = slotXOffset;
        this.slotYOffset = slotYOffset;
        ClientLevel world = ShulkerBoxTooltipClient.client == null ? null : ShulkerBoxTooltipClient.client.level;
        this.setPreview(PreviewContext.builder(ItemStack.EMPTY).withRegistryLookup((HolderLookup.Provider)(world == null ? null : world.registryAccess())).build(), EmptyPreviewProvider.INSTANCE);
    }

    protected int getMaxRowSize() {
        return this.previewType == PreviewType.COMPACT ? this.compactMaxRowSize : this.maxRowSize;
    }

    @Override
    public void setPreviewType(PreviewType type) {
        this.previewType = type;
    }

    @Override
    public void setPreview(PreviewContext context, PreviewProvider provider) {
        int rowSize = provider.getMaxRowSize(context);
        int compactRowSize = provider.getCompactMaxRowSize(context);
        this.config = context.config();
        if (compactRowSize <= 0) {
            compactRowSize = this.config.defaultMaxRowSize();
        }
        if (compactRowSize <= 0) {
            compactRowSize = 9;
        }
        if (rowSize <= 0) {
            rowSize = compactRowSize;
        }
        this.maxRowSize = rowSize;
        this.compactMaxRowSize = compactRowSize;
        this.textureOverride = provider.getTextureOverride(context);
        this.provider = provider;
        this.fullItems = provider.getInventory(context);
        this.compactItems = MergedItemStack.mergeInventory(this.fullItems, provider.getInventoryMaxSize(context), this.config.itemStackMergingStrategy());
        this.previewContext = context;
    }

    protected int getSlotAt(int x, int y) {
        int slot = -1;
        if (x + 1 >= this.slotXOffset && y + 1 >= this.slotYOffset) {
            int maxRowSize = this.getMaxRowSize();
            int slotX = (x + 1 - this.slotXOffset) / this.slotWidth;
            int slotY = (y + 1 - this.slotYOffset) / this.slotHeight;
            if (slotX < maxRowSize) {
                slot = slotX + slotY * maxRowSize;
            }
        }
        return slot;
    }

    private ItemStack getStackAt(int x, int y) {
        int slot = this.getSlotAt(x, y);
        if (this.previewType == PreviewType.COMPACT) {
            if (slot < 0 || slot >= this.compactItems.size()) {
                return ItemStack.EMPTY;
            }
            MergedItemStack merged = this.compactItems.get(slot);
            return merged == null ? ItemStack.EMPTY : merged.get();
        }
        if (slot >= 0 && slot < this.fullItems.size()) {
            return this.fullItems.get(slot);
        }
        return ItemStack.EMPTY;
    }

    protected void drawSlots(int x, int y, GuiGraphics graphics, Font font, int mouseX, int mouseY, int maxSlot) {
        int highlightedSlot = this.getSlotAt(mouseX - x, mouseY - y);
        if (this.previewType == PreviewType.COMPACT) {
            boolean shortItemCounts = this.config.shortItemCounts();
            int size = this.compactItems.size();
            for (int slot = 0; slot < size; ++slot) {
                if (slot > maxSlot) continue;
                this.drawSlot(this.compactItems.get(slot).get(), x, y, graphics, font, slot, highlightedSlot == slot, shortItemCounts);
            }
        } else {
            int size = this.fullItems.size();
            for (int slot = 0; slot < size; ++slot) {
                if (slot > maxSlot) continue;
                this.drawSlot(this.fullItems.get(slot), x, y, graphics, font, slot, highlightedSlot == slot, false);
            }
        }
    }

    protected abstract void drawSlot(ItemStack var1, int var2, int var3, GuiGraphics var4, Font var5, int var6, boolean var7, boolean var8);

    protected void drawItem(ItemStack stack, int x, int y, GuiGraphics graphics, Font font, boolean shortItemCount) {
        String countLabel = "";
        if (stack.getCount() != 1) {
            countLabel = shortItemCount ? ShulkerBoxTooltipUtil.abbreviateInteger(stack.getCount()) : String.valueOf(stack.getCount());
        }
        graphics.renderItem(stack, x, y);
        graphics.renderItemDecorations(font, stack, x, y, countLabel);
    }

    protected void drawInnerTooltip(int x, int y, GuiGraphics graphics, Font font, int mouseX, int mouseY) {
        ItemStack stack = this.getStackAt(mouseX - x, mouseY - y);
        if (stack.isEmpty()) {
            return;
        }
        GuiGraphicsExtensions.renderTooltipImmediate(graphics, () -> graphics.setTooltipForNextFrame(font, stack, mouseX, mouseY));
    }
}

