/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.api.color;

import com.misterpemodder.shulkerboxtooltip.impl.color.ColorKeyImpl;
import com.misterpemodder.shulkerboxtooltip.impl.util.ShulkerBoxTooltipUtil;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1767;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
@Environment(value=EnvType.CLIENT)
public interface ColorKey {
    public static final ColorKey DEFAULT = ColorKey.ofRgb(0xFFFFFF);
    public static final ColorKey ENDER_CHEST = ColorKey.ofRgb(740161);
    public static final ColorKey SHULKER_BOX = ColorKey.ofRgb(0x976797);
    public static final ColorKey WHITE_SHULKER_BOX = ColorKey.ofDye(class_1767.field_7952);
    public static final ColorKey ORANGE_SHULKER_BOX = ColorKey.ofDye(class_1767.field_7946);
    public static final ColorKey MAGENTA_SHULKER_BOX = ColorKey.ofDye(class_1767.field_7958);
    public static final ColorKey LIGHT_BLUE_SHULKER_BOX = ColorKey.ofDye(class_1767.field_7951);
    public static final ColorKey YELLOW_SHULKER_BOX = ColorKey.ofDye(class_1767.field_7947);
    public static final ColorKey LIME_SHULKER_BOX = ColorKey.ofDye(class_1767.field_7961);
    public static final ColorKey PINK_SHULKER_BOX = ColorKey.ofDye(class_1767.field_7954);
    public static final ColorKey GRAY_SHULKER_BOX = ColorKey.ofDye(class_1767.field_7944);
    public static final ColorKey LIGHT_GRAY_SHULKER_BOX = ColorKey.ofDye(class_1767.field_7967);
    public static final ColorKey CYAN_SHULKER_BOX = ColorKey.ofDye(class_1767.field_7955);
    public static final ColorKey PURPLE_SHULKER_BOX = ColorKey.ofDye(class_1767.field_7945);
    public static final ColorKey BLUE_SHULKER_BOX = ColorKey.ofDye(class_1767.field_7966);
    public static final ColorKey BROWN_SHULKER_BOX = ColorKey.ofDye(class_1767.field_7957);
    public static final ColorKey GREEN_SHULKER_BOX = ColorKey.ofDye(class_1767.field_7942);
    public static final ColorKey RED_SHULKER_BOX = ColorKey.ofDye(class_1767.field_7964);
    public static final ColorKey BLACK_SHULKER_BOX = ColorKey.ofDye(class_1767.field_7963);

    public int rgb();

    public float[] rgbComponents();

    public int defaultRgb();

    public float[] defaultRgbComponents();

    public void setRgb(int var1);

    public void setRgb(float[] var1);

    public static ColorKey copyOf(ColorKey original) {
        return ColorKey.ofRgb(original.rgbComponents());
    }

    public static ColorKey ofRgb(float[] rgb) {
        return new ColorKeyImpl(new float[]{rgb[0], rgb[1], rgb[2]}, new float[]{rgb[0], rgb[1], rgb[2]});
    }

    public static ColorKey ofRgb(int rgb) {
        float[] components = ShulkerBoxTooltipUtil.rgbToComponents(rgb);
        return new ColorKeyImpl(components, new float[]{components[0], components[1], components[2]});
    }

    private static ColorKey ofDye(class_1767 dye) {
        float[] color = dye.method_7787();
        float[] clamped = new float[]{Math.max(0.15f, color[0]), Math.max(0.15f, color[1]), Math.max(0.15f, color[2])};
        return new ColorKeyImpl(Arrays.copyOf(clamped, 3), clamped);
    }
}

