/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip;

import com.misterpemodder.shulkerboxtooltip.api.ShulkerBoxTooltipApi;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorKey;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorRegistry;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProviderRegistry;
import com.misterpemodder.shulkerboxtooltip.forge.ShulkerBoxTooltipImpl;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.config.ConfigurationHandler;
import com.misterpemodder.shulkerboxtooltip.impl.network.ServerNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.provider.EnderChestPreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.provider.FixedPreviewProviderRegistry;
import com.misterpemodder.shulkerboxtooltip.impl.provider.InventoryAwarePreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.provider.LecternPreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.provider.ShulkerBoxPreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.tree.RootConfigNode;
import com.misterpemodder.shulkerboxtooltip.impl.util.EnvironmentUtil;
import com.misterpemodder.shulkerboxtooltip.impl.util.NamedLogger;
import com.misterpemodder.shulkerboxtooltip.impl.util.ShulkerBoxTooltipUtil;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.nio.file.Path;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.DropperBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import net.minecraft.world.level.block.entity.TrappedChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

@ParametersAreNonnullByDefault
@ApiStatus.Internal
public class ShulkerBoxTooltip
implements ShulkerBoxTooltipApi {
    public static final String MOD_ID = "shulkerboxtooltip";
    public static final String MOD_NAME = "ShulkerBoxTooltip";
    public static final NamedLogger LOGGER = new NamedLogger(LogManager.getFormatterLogger((String)"ShulkerBoxTooltip"));
    public static Configuration config;
    public static Configuration savedConfig;
    public static RootConfigNode<Configuration> configTree;

    public static void init() {
        configTree = RootConfigNode.create(EnvironmentUtil.getInstance().makeConfiguration());
        savedConfig = ConfigurationHandler.register();
        config = EnvironmentUtil.getInstance().makeConfiguration();
        configTree.copy(savedConfig, config);
        ServerNetworking.init();
    }

    @Override
    public void registerProviders(PreviewProviderRegistry registry) {
        new FixedPreviewProviderRegistry<ShulkerBoxBlockEntity>(registry, ShulkerBoxPreviewProvider::new).register("shulker_box", 9, ShulkerBoxBlockEntity::new, Blocks.SHULKER_BOX).register("white_shulker_box", 9, ShulkerBoxBlockEntity::new, Blocks.WHITE_SHULKER_BOX).register("orange_shulker_box", 9, ShulkerBoxBlockEntity::new, Blocks.ORANGE_SHULKER_BOX).register("magenta_shulker_box", 9, ShulkerBoxBlockEntity::new, Blocks.MAGENTA_SHULKER_BOX).register("light_blue_shulker_box", 9, ShulkerBoxBlockEntity::new, Blocks.LIGHT_BLUE_SHULKER_BOX).register("yellow_shulker_box", 9, ShulkerBoxBlockEntity::new, Blocks.YELLOW_SHULKER_BOX).register("lime_shulker_box", 9, ShulkerBoxBlockEntity::new, Blocks.LIME_SHULKER_BOX).register("pink_shulker_box", 9, ShulkerBoxBlockEntity::new, Blocks.PINK_SHULKER_BOX).register("gray_shulker_box", 9, ShulkerBoxBlockEntity::new, Blocks.GRAY_SHULKER_BOX).register("light_gray_shulker_box", 9, ShulkerBoxBlockEntity::new, Blocks.LIGHT_GRAY_SHULKER_BOX).register("cyan_shulker_box", 9, ShulkerBoxBlockEntity::new, Blocks.CYAN_SHULKER_BOX).register("purple_shulker_box", 9, ShulkerBoxBlockEntity::new, Blocks.PURPLE_SHULKER_BOX).register("blue_shulker_box", 9, ShulkerBoxBlockEntity::new, Blocks.BLUE_SHULKER_BOX).register("brown_shulker_box", 9, ShulkerBoxBlockEntity::new, Blocks.BROWN_SHULKER_BOX).register("green_shulker_box", 9, ShulkerBoxBlockEntity::new, Blocks.GREEN_SHULKER_BOX).register("red_shulker_box", 9, ShulkerBoxBlockEntity::new, Blocks.RED_SHULKER_BOX).register("black_shulker_box", 9, ShulkerBoxBlockEntity::new, Blocks.BLACK_SHULKER_BOX);
        new FixedPreviewProviderRegistry<Container>(registry, InventoryAwarePreviewProvider::new).register("chest", 9, ChestBlockEntity::new, Blocks.CHEST).register("trapped_chest", 9, TrappedChestBlockEntity::new, Blocks.TRAPPED_CHEST).register("barrel", 9, BarrelBlockEntity::new, Blocks.BARREL).register("furnace", 3, FurnaceBlockEntity::new, Blocks.FURNACE).register("blast_furnace", 3, BlastFurnaceBlockEntity::new, Blocks.BLAST_FURNACE).register("smoker", 3, SmokerBlockEntity::new, Blocks.SMOKER).register("dropper", 3, DropperBlockEntity::new, Blocks.DROPPER).register("dispenser", 3, DispenserBlockEntity::new, Blocks.DISPENSER).register("hopper", 5, HopperBlockEntity::new, Blocks.HOPPER).register("brewing_stand", 7, BrewingStandBlockEntity::new, Blocks.BREWING_STAND).register("chiseled_bookshelf", 3, ChiseledBookShelfBlockEntity::new, Blocks.CHISELED_BOOKSHELF).register("decorated_pot", 1, DecoratedPotBlockEntity::new, Blocks.DECORATED_POT);
        new FixedPreviewProviderRegistry<Container>(registry, LecternPreviewProvider::new).register("lectern", 1, (pos, state) -> new LecternBlockEntity((BlockPos)pos, (BlockState)state).bookAccess, Blocks.LECTERN);
        registry.register(ShulkerBoxTooltipUtil.id("ender_chest"), (PreviewProvider)new EnderChestPreviewProvider(), Items.ENDER_CHEST);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerColors(ColorRegistry registry) {
        registry.defaultCategory().register(ColorKey.DEFAULT, "default").register(ColorKey.ENDER_CHEST, "ender_chest", ShulkerBoxTooltip.blockName("ender_chest"));
        registry.category(ShulkerBoxTooltipUtil.id("shulker_boxes")).register(ColorKey.SHULKER_BOX, "shulker_box", ShulkerBoxTooltip.blockName("shulker_box")).register(ColorKey.WHITE_SHULKER_BOX, "white_shulker_box", ShulkerBoxTooltip.blockName("white_shulker_box")).register(ColorKey.ORANGE_SHULKER_BOX, "orange_shulker_box", ShulkerBoxTooltip.blockName("orange_shulker_box")).register(ColorKey.MAGENTA_SHULKER_BOX, "magenta_shulker_box", ShulkerBoxTooltip.blockName("magenta_shulker_box")).register(ColorKey.LIGHT_BLUE_SHULKER_BOX, "light_blue_shulker_box", ShulkerBoxTooltip.blockName("light_blue_shulker_box")).register(ColorKey.YELLOW_SHULKER_BOX, "yellow_shulker_box", ShulkerBoxTooltip.blockName("yellow_shulker_box")).register(ColorKey.LIME_SHULKER_BOX, "lime_shulker_box", ShulkerBoxTooltip.blockName("lime_shulker_box")).register(ColorKey.PINK_SHULKER_BOX, "pink_shulker_box", ShulkerBoxTooltip.blockName("pink_shulker_box")).register(ColorKey.GRAY_SHULKER_BOX, "gray_shulker_box", ShulkerBoxTooltip.blockName("gray_shulker_box")).register(ColorKey.LIGHT_GRAY_SHULKER_BOX, "light_gray_shulker_box", ShulkerBoxTooltip.blockName("light_gray_shulker_box")).register(ColorKey.CYAN_SHULKER_BOX, "cyan_shulker_box", ShulkerBoxTooltip.blockName("cyan_shulker_box")).register(ColorKey.PURPLE_SHULKER_BOX, "purple_shulker_box", ShulkerBoxTooltip.blockName("purple_shulker_box")).register(ColorKey.BLUE_SHULKER_BOX, "blue_shulker_box", ShulkerBoxTooltip.blockName("blue_shulker_box")).register(ColorKey.BROWN_SHULKER_BOX, "brown_shulker_box", ShulkerBoxTooltip.blockName("brown_shulker_box")).register(ColorKey.GREEN_SHULKER_BOX, "green_shulker_box", ShulkerBoxTooltip.blockName("green_shulker_box")).register(ColorKey.RED_SHULKER_BOX, "red_shulker_box", ShulkerBoxTooltip.blockName("red_shulker_box")).register(ColorKey.BLACK_SHULKER_BOX, "black_shulker_box", ShulkerBoxTooltip.blockName("black_shulker_box"));
    }

    private static String blockName(String block) {
        return "block.minecraft." + block;
    }

    @ExpectPlatform
    @Contract(value="-> _", pure=true)
    @ExpectPlatform.Transformed
    public static Path getConfigDir() {
        return ShulkerBoxTooltipImpl.getConfigDir();
    }
}

