/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.network;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.PluginManager;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.network.EnderChestInventoryListener;
import com.misterpemodder.shulkerboxtooltip.impl.network.ProtocolVersion;
import com.misterpemodder.shulkerboxtooltip.impl.network.channel.S2CChannel;
import com.misterpemodder.shulkerboxtooltip.impl.network.forge.ServerNetworkingImpl;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.MessageType;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.S2CEnderChestUpdate;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.S2CMessages;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ServerNetworking {
    private static final Map<ServerPlayer, ProtocolVersion> CLIENTS = new WeakHashMap<ServerPlayer, ProtocolVersion>();

    private ServerNetworking() {
    }

    public static boolean hasModAvailable(ServerPlayer player) {
        return CLIENTS.containsKey(player);
    }

    public static void addClient(ServerPlayer client, ProtocolVersion version) {
        CLIENTS.put(client, version);
        PluginManager.loadProviders();
        Configuration.EnderChestSyncType ecSyncType = ShulkerBoxTooltip.config.server.enderChestSyncType;
        if (ecSyncType != Configuration.EnderChestSyncType.NONE) {
            S2CMessages.ENDER_CHEST_UPDATE.sendTo(client, S2CEnderChestUpdate.create(client.getEnderChestInventory(), (HolderLookup.Provider)client.registryAccess()));
        }
        if (ecSyncType == Configuration.EnderChestSyncType.ACTIVE) {
            EnderChestInventoryListener.attachTo(client);
        }
    }

    public static void removeClient(ServerPlayer client) {
        CLIENTS.remove(client);
        EnderChestInventoryListener.detachFrom(client);
    }

    public static void onPlayerChangeWorld(ServerPlayer player) {
        Configuration.EnderChestSyncType ecSyncType = ShulkerBoxTooltip.config.server.enderChestSyncType;
        if (CLIENTS.containsKey(player) && ecSyncType != Configuration.EnderChestSyncType.NONE) {
            S2CMessages.ENDER_CHEST_UPDATE.sendTo(player, S2CEnderChestUpdate.create(player.getEnderChestInventory(), (HolderLookup.Provider)player.registryAccess()));
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        ServerNetworkingImpl.init();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> S2CChannel<T> createS2CChannel(ResourceLocation id, MessageType<T> type) {
        void var1_1;
        return ServerNetworkingImpl.createS2CChannel(id, var1_1);
    }
}

