/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.network.forge;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.network.ServerNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.network.channel.S2CChannel;
import com.misterpemodder.shulkerboxtooltip.impl.network.forge.ForgeS2CChannel;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.C2SMessages;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.MessageType;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.S2CMessages;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class ServerNetworkingImpl {
    public static final Map<ResourceLocation, ForgeS2CChannel<?>> S2C_CHANNELS = new HashMap();

    private ServerNetworkingImpl() {
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        C2SMessages.registerAllFor((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerNetworking.removeClient((ServerPlayer)event.getEntity());
    }

    public static void init() {
        if (!ShulkerBoxTooltip.config.server.clientIntegration) {
            return;
        }
        S2CMessages.registerPayloadTypes();
        C2SMessages.registerPayloadTypes();
        MinecraftForge.EVENT_BUS.register(ServerNetworkingImpl.class);
    }

    public static <T> S2CChannel<T> createS2CChannel(ResourceLocation id, MessageType<T> type) {
        ForgeS2CChannel<T> channel = new ForgeS2CChannel<T>(id, type);
        S2C_CHANNELS.put(id, channel);
        return channel;
    }
}

