/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.provider;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorKey;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.provider.InventoryAwarePreviewProvider;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ShulkerBoxPreviewProvider
extends InventoryAwarePreviewProvider<ShulkerBoxBlockEntity> {
    public ShulkerBoxPreviewProvider(int maxRowSize, Supplier<? extends ShulkerBoxBlockEntity> blockEntitySupplier) {
        super(maxRowSize, blockEntitySupplier);
    }

    @Override
    public boolean showTooltipHints(PreviewContext context) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ColorKey getWindowColorKey(PreviewContext context) {
        DyeColor dye = ((ShulkerBoxBlock)Block.byItem((Item)context.stack().getItem())).getColor();
        if (dye == null) {
            return ColorKey.SHULKER_BOX;
        }
        return switch (dye) {
            case DyeColor.ORANGE -> ColorKey.ORANGE_SHULKER_BOX;
            case DyeColor.MAGENTA -> ColorKey.MAGENTA_SHULKER_BOX;
            case DyeColor.LIGHT_BLUE -> ColorKey.LIGHT_BLUE_SHULKER_BOX;
            case DyeColor.YELLOW -> ColorKey.YELLOW_SHULKER_BOX;
            case DyeColor.LIME -> ColorKey.LIME_SHULKER_BOX;
            case DyeColor.PINK -> ColorKey.PINK_SHULKER_BOX;
            case DyeColor.GRAY -> ColorKey.GRAY_SHULKER_BOX;
            case DyeColor.LIGHT_GRAY -> ColorKey.LIGHT_GRAY_SHULKER_BOX;
            case DyeColor.CYAN -> ColorKey.CYAN_SHULKER_BOX;
            case DyeColor.PURPLE -> ColorKey.PURPLE_SHULKER_BOX;
            case DyeColor.BLUE -> ColorKey.BLUE_SHULKER_BOX;
            case DyeColor.BROWN -> ColorKey.BROWN_SHULKER_BOX;
            case DyeColor.GREEN -> ColorKey.GREEN_SHULKER_BOX;
            case DyeColor.RED -> ColorKey.RED_SHULKER_BOX;
            case DyeColor.BLACK -> ColorKey.BLACK_SHULKER_BOX;
            default -> ColorKey.WHITE_SHULKER_BOX;
        };
    }

    @Override
    public List<Component> addTooltip(PreviewContext context) {
        ItemStack stack = context.stack();
        if (this.canUseLootTables() && ShulkerBoxTooltip.config.tooltip.lootTableInfoType == Configuration.LootTableInfoType.HIDE && stack.has(DataComponents.CONTAINER_LOOT)) {
            Style style = Style.EMPTY.withColor(ChatFormatting.GRAY);
            return Collections.singletonList(Component.literal((String)"???????").setStyle(style));
        }
        return super.addTooltip(context);
    }
}

