/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.tree;

import com.google.common.collect.ImmutableList;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorKey;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorRegistry;
import com.misterpemodder.shulkerboxtooltip.impl.config.annotation.ConfigCategory;
import com.misterpemodder.shulkerboxtooltip.impl.config.annotation.RequiresRestart;
import com.misterpemodder.shulkerboxtooltip.impl.config.annotation.Synchronize;
import com.misterpemodder.shulkerboxtooltip.impl.config.annotation.Validator;
import com.misterpemodder.shulkerboxtooltip.impl.tree.CategoryConfigNode;
import com.misterpemodder.shulkerboxtooltip.impl.tree.ConfigNode;
import com.misterpemodder.shulkerboxtooltip.impl.tree.ValueConfigNode;
import com.misterpemodder.shulkerboxtooltip.impl.util.EnvironmentUtil;
import com.misterpemodder.shulkerboxtooltip.impl.util.ShulkerBoxTooltipUtil;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RootConfigNode<C>
implements ConfigNode<C> {
    public static final Component TITLE = Component.translatable((String)"shulkerboxtooltip.config.title");
    private ImmutableList<CategoryConfigNode<C>> categories;

    private RootConfigNode(ImmutableList<CategoryConfigNode<C>> categories) {
        this.categories = categories;
    }

    public static <C> RootConfigNode<C> create(C defaultConfig) {
        return new Builder<C>(defaultConfig).build();
    }

    public void reload(C defaultConfig) {
        this.categories = new Builder<C>(defaultConfig).build().getCategories();
    }

    @Override
    @NotNull
    public String getName() {
        return "";
    }

    @Override
    @NotNull
    public Component getTitle() {
        return TITLE;
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return null;
    }

    @Override
    @Nullable
    public Component getPrefix() {
        return null;
    }

    @Override
    public void resetToDefault() {
        this.categories.forEach(ConfigNode::resetToDefault);
    }

    @Override
    public void resetToActive(C config) {
        this.categories.forEach(category -> category.resetToActive(config));
    }

    @Override
    public boolean restartRequired(C config) {
        return this.categories.stream().anyMatch(categoryConfigNode -> categoryConfigNode.restartRequired(config));
    }

    @Override
    public boolean isDefaultValue(C config) {
        return this.categories.stream().allMatch(node -> node.isDefaultValue(config));
    }

    @Override
    public boolean isActiveValue(C config) {
        return this.categories.stream().allMatch(node -> node.isActiveValue(config));
    }

    @Override
    @Nullable
    public Component validate(C config) {
        Component error = null;
        for (CategoryConfigNode node : this.categories) {
            Component result = node.validate(config);
            if (result == null) continue;
            if (error != null) {
                return CategoryConfigNode.MULTIPLE_ERRORS;
            }
            error = result;
        }
        return error;
    }

    @NotNull
    public ImmutableList<CategoryConfigNode<C>> getCategories() {
        return this.categories;
    }

    @Override
    public void writeToNbt(C config, CompoundTag compound) {
        this.categories.forEach(node -> node.writeToNbt(config, compound));
    }

    @Override
    public void readFromNbt(C config, CompoundTag compound) {
        this.categories.forEach(node -> node.readFromNbt(config, compound));
    }

    @Override
    public void copy(C from, C to) {
        this.categories.forEach(node -> node.copy(from, to));
    }

    @Override
    public void writeEditingToConfig(C config) {
        this.categories.forEach(node -> node.writeEditingToConfig(config));
    }

    private static class Builder<C> {
        private Object defaultConfig;

        private Builder(C defaultConfig) {
            this.defaultConfig = defaultConfig;
        }

        @NotNull
        public RootConfigNode<C> build() {
            Class<?> configClass = this.defaultConfig.getClass();
            ImmutableList categories = (ImmutableList)Arrays.stream(configClass.getFields()).filter(field -> field.isAnnotationPresent(ConfigCategory.class)).map(field -> Pair.of((Object)field.getAnnotation(ConfigCategory.class).ordinal(), (Object)field)).sorted(Comparator.comparingInt(Pair::getFirst)).map(pair -> this.createCategoryNode((Field)pair.getSecond())).collect(ImmutableList.toImmutableList());
            this.defaultConfig = null;
            return new RootConfigNode(categories);
        }

        private CategoryConfigNode<C> createCategoryNode(Field categoryField) {
            Object defaultCategory;
            try {
                categoryField.setAccessible(true);
                defaultCategory = categoryField.get(this.defaultConfig);
            }
            catch (IllegalAccessException | SecurityException | InaccessibleObjectException e) {
                throw new IllegalArgumentException("Failed to get category field", e);
            }
            Class<?> categoryClass = categoryField.getType();
            String categoryName = categoryField.getName();
            CategoryConfigNode.Builder categoryBuilder = CategoryConfigNode.builder().name(categoryName).title((Component)Component.translatable((String)("shulkerboxtooltip.config.category." + ShulkerBoxTooltipUtil.snakeCase(categoryName))));
            for (Field valueField : categoryClass.getDeclaredFields()) {
                this.addValueNode(defaultCategory, categoryField, valueField, categoryBuilder);
            }
            return categoryBuilder.build();
        }

        private void addValueNode(Object defaultCategory, Field categoryField, Field valueField, CategoryConfigNode.Builder<C> categoryBuilder) {
            Object defaultValue;
            try {
                valueField.setAccessible(true);
                defaultValue = valueField.get(defaultCategory);
            }
            catch (IllegalAccessException | SecurityException | InaccessibleObjectException e) {
                throw new IllegalArgumentException("Failed to get value field", e);
            }
            if (EnvironmentUtil.isClient() && defaultValue instanceof ColorRegistry) {
                ColorRegistry colorRegistry = (ColorRegistry)defaultValue;
                this.addColorRegistryField(colorRegistry, categoryBuilder);
                return;
            }
            this.addSingleValueField(defaultValue.getClass(), defaultValue, categoryField, valueField, categoryBuilder);
        }

        private <T> void addSingleValueField(Class<? extends T> type, T defaultValue, Field categoryField, Field valueField, CategoryConfigNode.Builder<C> categoryBuilder) {
            String valueName = valueField.getName();
            String titleKey = "shulkerboxtooltip.config.option." + ShulkerBoxTooltipUtil.snakeCase(categoryField.getName()) + "." + ShulkerBoxTooltipUtil.snakeCase(valueName);
            MutableComponent title = Component.translatable((String)titleKey);
            MutableComponent tooltip = Component.translatable((String)(titleKey + ".tooltip"));
            String prefixKey = titleKey + ".prefix";
            categoryBuilder.value(valueBuilder -> {
                Validator validatorAnnotation;
                valueBuilder.type(type).valueType(type).name(valueName).title((Component)title).tooltip((Component)tooltip).defaultValue(defaultValue).valueReader(this.makeValueReader(type, categoryField, valueField)).valueWriter(this.makeValueWriter(type, categoryField, valueField)).requiresRestart(valueField.isAnnotationPresent(RequiresRestart.class));
                if (EnvironmentUtil.isClient() && I18n.exists((String)prefixKey)) {
                    valueBuilder.prefix((Component)Component.translatable((String)prefixKey));
                }
                if (valueField.isAnnotationPresent(Synchronize.class)) {
                    valueBuilder.nbtReader(this.makeNbtReader(type, valueField.getName(), defaultValue)).nbtWriter(this.makeNbtWriter(valueField.getName(), defaultValue));
                }
                if ((validatorAnnotation = valueField.getAnnotation(Validator.class)) != null) {
                    valueBuilder.validator(this.makeValueValidator(validatorAnnotation, valueField));
                }
                return valueBuilder;
            });
        }

        @OnlyIn(value=Dist.CLIENT)
        private void addColorRegistryField(ColorRegistry colorRegistry, CategoryConfigNode.Builder<C> categoryBuilder) {
            this.addColorRegistryCategoryNode(colorRegistry.defaultCategory(), ShulkerBoxTooltipUtil.id("default"), categoryBuilder);
            for (Map.Entry<ResourceLocation, ColorRegistry.Category> entry : colorRegistry.categories().entrySet()) {
                ResourceLocation categoryId = entry.getKey();
                ColorRegistry.Category colorCategory = entry.getValue();
                if (colorCategory == colorRegistry.defaultCategory()) continue;
                this.addColorRegistryCategoryNode(colorCategory, categoryId, categoryBuilder);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        private void addColorRegistryCategoryNode(ColorRegistry.Category colorCategory, ResourceLocation categoryId, CategoryConfigNode.Builder<C> categoryBuilder) {
            categoryBuilder.category(subCategoryBuilder -> {
                String titleKey = "shulkerboxtooltip.colors." + categoryId.getNamespace() + "." + categoryId.getPath();
                MutableComponent title = Component.translatable((String)titleKey);
                subCategoryBuilder.name(categoryId.toString()).title((Component)title);
                for (Map.Entry<String, ColorKey> entry : colorCategory.keys().entrySet()) {
                    this.addColorKeyValueNode(entry.getValue(), entry.getKey(), colorCategory, (CategoryConfigNode.Builder<C>)subCategoryBuilder);
                }
                return subCategoryBuilder;
            });
        }

        @OnlyIn(value=Dist.CLIENT)
        private void addColorKeyValueNode(ColorKey colorKey, String colorKeyId, ColorRegistry.Category colorCategory, CategoryConfigNode.Builder<C> subCategoryBuilder) {
            String titleKey = colorCategory.keyUnlocalizedName(colorKey);
            subCategoryBuilder.value(valueBuilder -> valueBuilder.type(ColorKey.class).valueType(Integer.class).name(colorKeyId).title((Component)(titleKey == null ? Component.literal((String)colorKeyId) : Component.translatable((String)titleKey))).defaultValue(colorKey.defaultRgb()).valueReader(s -> colorKey.rgb()).valueWriter((s, v) -> colorKey.setRgb((int)v)).validator(v -> {
                if (v == null || (v & 0xFF000000) != 0) {
                    return Component.translatable((String)"shulkerboxtooltip.config.validator.invalid_color");
                }
                return null;
            }));
        }

        private <T> ValueConfigNode.ValueReader<C, T> makeValueReader(Class<? extends T> type, Field categoryField, Field valueField) {
            try {
                valueField.setAccessible(true);
            }
            catch (SecurityException | InaccessibleObjectException e) {
                throw new IllegalArgumentException("Failed to set value field accessible", e);
            }
            return config -> {
                try {
                    return type.cast(valueField.get(categoryField.get(config)));
                }
                catch (ClassCastException | IllegalAccessException e) {
                    throw new IllegalArgumentException("Failed to get value field", e);
                }
            };
        }

        private <T> ValueConfigNode.ValueWriter<C, T> makeValueWriter(Class<? extends T> type, Field categoryField, Field valueField) {
            try {
                valueField.setAccessible(true);
            }
            catch (SecurityException | InaccessibleObjectException e) {
                throw new IllegalArgumentException("Failed to set value field accessible", e);
            }
            return (config, value) -> {
                try {
                    valueField.set(categoryField.get(config), type.cast(value));
                }
                catch (ClassCastException | IllegalAccessException e) {
                    throw new IllegalArgumentException("Failed to set value field", e);
                }
            };
        }

        private <T> ValueConfigNode.ValueReader<CompoundTag, T> makeNbtReader(Class<? extends T> type, String valueName, T defaultValue) {
            T t = defaultValue;
            Objects.requireNonNull(t);
            T t2 = t;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Enum.class, Boolean.class, String.class, Integer.class}, t2, n)) {
                case 0 -> {
                    Enum ignored = (Enum)t2;
                    yield tag -> Enum.valueOf(type, tag.getString(valueName));
                }
                case 1 -> {
                    Boolean ignored = (Boolean)t2;
                    yield tag -> tag.getBoolean(valueName);
                }
                case 2 -> {
                    String ignored = (String)t2;
                    yield tag -> tag.getString(valueName);
                }
                case 3 -> {
                    Integer ignored = (Integer)t2;
                    yield tag -> tag.getInt(valueName);
                }
                default -> throw new IllegalArgumentException("Unsupported value type: " + String.valueOf(defaultValue.getClass()));
            };
        }

        private <T> ValueConfigNode.ValueWriter<CompoundTag, T> makeNbtWriter(String valueName, T defaultValue) {
            T t = defaultValue;
            Objects.requireNonNull(t);
            T t2 = t;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Enum.class, Boolean.class, String.class, Integer.class}, t2, n)) {
                case 0 -> {
                    Enum ignored = (Enum)t2;
                    yield (tag, value) -> tag.putString(valueName, ((Enum)value).name());
                }
                case 1 -> {
                    Boolean ignored = (Boolean)t2;
                    yield (tag, value) -> tag.putBoolean(valueName, ((Boolean)value).booleanValue());
                }
                case 2 -> {
                    String ignored = (String)t2;
                    yield (tag, value) -> tag.putString(valueName, (String)value);
                }
                case 3 -> {
                    Integer ignored = (Integer)t2;
                    yield (tag, value) -> tag.putInt(valueName, ((Integer)value).intValue());
                }
                default -> throw new IllegalArgumentException("Unsupported value type: " + String.valueOf(defaultValue.getClass()));
            };
        }

        private <T> ValueConfigNode.ValueValidator<T> makeValueValidator(Validator validatorAnnotation, Field valueField) {
            try {
                return validatorAnnotation.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException("Failed to create validator for config field " + String.valueOf(valueField), e);
            }
        }
    }
}

