/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.util;

import net.minecraft.resources.ResourceLocation;

public final class ShulkerBoxTooltipUtil {
    private ShulkerBoxTooltipUtil() {
    }

    public static ResourceLocation id(String id) {
        return new ResourceLocation("shulkerboxtooltip", id);
    }

    public static String abbreviateInteger(int count) {
        int integral;
        if (count == Integer.MIN_VALUE) {
            return "-2G";
        }
        if (count > -1000 && count < 1000) {
            return Integer.toString(count);
        }
        StringBuilder str = new StringBuilder();
        if (count < 0) {
            str.append('-');
            count = -count;
        }
        int decimal = 0;
        char unit = switch ((int)Math.log10(count)) {
            case 3 -> {
                integral = count / 1000;
                decimal = count % 1000 / 100;
                yield 'k';
            }
            case 4, 5 -> {
                integral = count / 1000;
                yield 'k';
            }
            case 6 -> {
                integral = count / 1000000;
                decimal = count % 1000000 / 100000;
                yield 'M';
            }
            case 7, 8 -> {
                integral = count / 1000000;
                yield 'M';
            }
            default -> {
                integral = count / 1000000000;
                decimal = count % 1000000000 / 100000000;
                yield 'G';
            }
        };
        str.append(integral);
        if (decimal > 0) {
            str.append('.').append(decimal);
        }
        str.append(unit);
        return str.toString();
    }

    public static float[] rgbToComponents(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
    }

    public static int componentsToRgb(float[] components) {
        int r = (int)(255.0f * components[0]);
        int g = (int)(255.0f * components[1]);
        int b = (int)(255.0f * components[2]);
        return r << 16 | g << 8 | b;
    }

    public static String snakeCase(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0) {
                    sb.append('_');
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

