/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.provider;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSet;
import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProviderRegistry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PreviewProviderRegistryImpl
implements PreviewProviderRegistry {
    private boolean locked = true;
    private final BiMap<Identifier, PreviewProvider> providerIds = HashBiMap.create();
    private final Map<Item, PreviewProvider> providerItems = new HashMap<Item, PreviewProvider>();
    public static final PreviewProviderRegistryImpl INSTANCE = new PreviewProviderRegistryImpl();

    private PreviewProviderRegistryImpl() {
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    public void register(Identifier id, PreviewProvider provider, Iterable<Item> items) {
        if (this.locked) {
            throw new IllegalStateException("attempted to register PreviewProvider outside ShulkerBoxTooltipApi.registerProviders");
        }
        if (this.providerIds.containsValue((Object)provider)) {
            throw new IllegalStateException("attempted to register PreviewProvider twice");
        }
        if (this.providerIds.containsKey((Object)id)) {
            ShulkerBoxTooltip.LOGGER.warn("registering PreviewProvider with an existing id: " + String.valueOf(id));
        }
        int priority = provider.getPriority();
        this.providerIds.put((Object)id, (Object)provider);
        for (Item item : items) {
            PreviewProvider previousProvider = this.providerItems.get(item);
            if (previousProvider == null) {
                this.providerItems.put(item, provider);
                continue;
            }
            Identifier previousId = this.getId(previousProvider);
            Identifier itemId = BuiltInRegistries.ITEM.getKey((Object)item);
            if (priority > previousProvider.getPriority()) {
                ShulkerBoxTooltip.LOGGER.info("overriding preview provider " + String.valueOf(previousId) + " with " + String.valueOf(id) + " for item " + String.valueOf(itemId));
                this.providerItems.put(item, provider);
                continue;
            }
            ShulkerBoxTooltip.LOGGER.info("overriding preview provider " + String.valueOf(id) + " with " + String.valueOf(previousId) + " for item " + String.valueOf(itemId));
        }
    }

    @Override
    public void register(Identifier id, PreviewProvider provider, Item ... items) {
        this.register(id, provider, Arrays.asList(items));
    }

    @Override
    public PreviewProvider get(Identifier id) {
        return (PreviewProvider)this.providerIds.get((Object)id);
    }

    @Override
    public PreviewProvider get(ItemStack stack) {
        return this.providerItems.get(stack.getItem());
    }

    @Override
    public PreviewProvider get(Item item) {
        return this.providerItems.get(item);
    }

    @Override
    public Identifier getId(PreviewProvider provider) {
        return (Identifier)this.providerIds.inverse().get((Object)provider);
    }

    @Override
    @Nonnull
    public Set<Item> getItems(PreviewProvider provider) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Map.Entry<Item, PreviewProvider> entry : this.providerItems.entrySet()) {
            if (entry.getValue() != provider) continue;
            builder.add((Object)entry.getKey());
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public Set<PreviewProvider> getProviders() {
        return this.providerIds.values();
    }

    @Override
    @Nonnull
    public Set<Identifier> getIds() {
        return this.providerIds.keySet();
    }
}

