/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.api.provider;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.ShulkerBoxTooltipApi;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.SeededContainerLoot;

public class BlockEntityPreviewProvider
implements PreviewProvider {
    @Deprecated(since="4.0.8", forRemoval=true)
    protected final int maxInvSize;
    @Deprecated(since="4.0.8", forRemoval=true)
    protected final boolean canUseLootTables;
    @Deprecated(since="4.0.8", forRemoval=true)
    protected final int maxRowSize;

    public BlockEntityPreviewProvider(int maxInvSize, boolean canUseLootTables) {
        this.maxInvSize = maxInvSize;
        this.canUseLootTables = canUseLootTables;
        this.maxRowSize = 9;
    }

    public BlockEntityPreviewProvider(int maxInvSize, boolean canUseLootTables, int maxRowSize) {
        this.maxInvSize = maxInvSize;
        this.canUseLootTables = canUseLootTables;
        this.maxRowSize = maxRowSize <= 0 ? 9 : maxRowSize;
    }

    @Override
    public boolean shouldDisplay(PreviewContext context) {
        if (this.canUseLootTables() && context.stack().has(DataComponents.CONTAINER_LOOT)) {
            return false;
        }
        return BlockEntityPreviewProvider.getItemCount(this.getInventory(context)) > 0;
    }

    @Override
    public boolean showTooltipHints(PreviewContext context) {
        return context.stack().has(DataComponents.CONTAINER);
    }

    @Override
    public List<ItemStack> getInventory(PreviewContext context) {
        HolderLookup.Provider registries = context.registryLookup();
        ItemContainerContents container = (ItemContainerContents)context.stack().get(DataComponents.CONTAINER);
        int invMaxSize = this.getInventoryMaxSize(context);
        NonNullList inv = NonNullList.withSize((int)invMaxSize, (Object)ItemStack.EMPTY);
        if (registries != null && container != null) {
            container.copyInto(inv);
        }
        return inv;
    }

    @Override
    public int getInventoryMaxSize(PreviewContext context) {
        return this.maxInvSize;
    }

    @Override
    public List<Component> addTooltip(PreviewContext context) {
        ItemStack stack = context.stack();
        SeededContainerLoot lootComponent = (SeededContainerLoot)stack.get(DataComponents.CONTAINER_LOOT);
        Style style = Style.EMPTY.withColor(ChatFormatting.GRAY);
        if (this.canUseLootTables() && lootComponent != null) {
            return switch (ShulkerBoxTooltip.config.tooltip.lootTableInfoType) {
                case Configuration.LootTableInfoType.HIDE -> Collections.emptyList();
                case Configuration.LootTableInfoType.SIMPLE -> Collections.singletonList(Component.translatable((String)"shulkerboxtooltip.hint.loot_table").setStyle(style));
                default -> Arrays.asList(Component.translatable((String)"shulkerboxtooltip.hint.loot_table.advanced").append((Component)Component.literal((String)": ")), Component.literal((String)(" " + String.valueOf(lootComponent.lootTable().location()))).setStyle(style));
            };
        }
        if (ShulkerBoxTooltipApi.getCurrentPreviewType(this.isFullPreviewAvailable(context)) == PreviewType.FULL) {
            return Collections.emptyList();
        }
        return BlockEntityPreviewProvider.getItemListTooltip(new ArrayList<Component>(), this.getInventory(context), style);
    }

    public static List<Component> getItemCountTooltip(List<Component> tooltip, @Nullable List<ItemStack> items) {
        return BlockEntityPreviewProvider.getItemListTooltip(tooltip, items, Style.EMPTY.withColor(ChatFormatting.GRAY));
    }

    public static List<Component> getItemListTooltip(List<Component> tooltip, @Nullable List<ItemStack> items, Style style) {
        int itemCount = BlockEntityPreviewProvider.getItemCount(items);
        MutableComponent text = itemCount > 0 ? Component.translatable((String)"container.shulkerbox.contains", (Object[])new Object[]{itemCount}) : Component.translatable((String)"container.shulkerbox.empty");
        tooltip.add((Component)text.setStyle(style));
        return tooltip;
    }

    @Override
    public int getMaxRowSize(PreviewContext context) {
        return this.maxRowSize;
    }

    public boolean canUseLootTables() {
        return this.canUseLootTables;
    }

    private static int getItemCount(@Nullable List<ItemStack> items) {
        int itemCount = 0;
        if (items != null) {
            for (ItemStack stack : items) {
                if (stack.getItem() == Items.AIR) continue;
                ++itemCount;
            }
        }
        return itemCount;
    }
}

