/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.config.gui;

import com.misterpemodder.shulkerboxtooltip.api.color.ColorKey;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.ConfigEntryList;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.ConfigScreen;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry.BooleanValueConfigEntry;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry.CategoryTitleConfigEntry;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry.ColorValueConfigEntry;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry.ConfigEntry;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry.EnumValueConfigEntry;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry.IntegerValueConfigEntry;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry.KeyValueConfigEntry;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry.PrefixTextConfigEntry;
import com.misterpemodder.shulkerboxtooltip.impl.tree.CategoryConfigNode;
import com.misterpemodder.shulkerboxtooltip.impl.tree.ConfigNode;
import com.misterpemodder.shulkerboxtooltip.impl.tree.ValueConfigNode;
import com.misterpemodder.shulkerboxtooltip.impl.util.Key;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.TabButton;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigCategoryTab<C>
implements Tab {
    private final ConfigScreen<C> screen;
    private final CategoryConfigNode<C> category;
    private final C config;
    private final Component title;
    private final Component titleChanged;
    private final Component titleError;
    private final Component titleErrorChanged;
    private final ConfigEntryList list;
    @Nullable
    private ValueConfigNode<C, Key, Key> selectedKeyNode;
    @Nullable
    private TabButton tabButton;

    public ConfigCategoryTab(ConfigScreen<C> screen, CategoryConfigNode<C> category, C config) {
        this.screen = screen;
        this.category = category;
        this.config = config;
        this.title = category.getTitle();
        this.titleChanged = this.title.copy().withStyle(ChatFormatting.ITALIC);
        this.titleError = this.title.copy().withStyle(ChatFormatting.RED);
        this.titleErrorChanged = this.title.copy().withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.RED});
        ArrayList<ConfigEntry> entries = new ArrayList<ConfigEntry>();
        for (ConfigNode node : category.getChildren()) {
            if (node.getPrefix() != null) {
                entries.add(new PrefixTextConfigEntry(this, node.getPrefix()));
            }
            if (node instanceof ValueConfigNode) {
                ValueConfigNode valueNode = (ValueConfigNode)node;
                entries.add(this.createValueEntry(valueNode));
                continue;
            }
            if (!(node instanceof CategoryConfigNode)) continue;
            CategoryConfigNode categoryNode = (CategoryConfigNode)node;
            entries.addAll(this.createSubCategoryEntries(categoryNode));
        }
        this.list = new ConfigEntryList(this, this.getMinecraft(), this.screen.width, this.screen.height - this.screen.getHeaderHeight() - this.screen.getFooterHeight(), this.screen.getHeaderHeight(), 24, entries);
    }

    @NotNull
    public Component getTabTitle() {
        return this.title;
    }

    @NotNull
    public Component getTabExtraNarration() {
        return Component.empty();
    }

    public void visitChildren(Consumer<AbstractWidget> consumer) {
        consumer.accept((AbstractWidget)this.list);
    }

    public void doLayout(ScreenRectangle screenRectangle) {
        this.list.setRectangle(screenRectangle.width(), screenRectangle.height(), screenRectangle.left(), screenRectangle.top());
    }

    private <T, V> ConfigEntry createValueEntry(ValueConfigNode<C, T, V> valueNode) {
        Class<T> type = valueNode.getType();
        if (type.equals(Boolean.class)) {
            return new BooleanValueConfigEntry<C>(this, valueNode);
        }
        if (ColorKey.class.isAssignableFrom(type)) {
            return new ColorValueConfigEntry<C>(this, valueNode);
        }
        if (Enum.class.isAssignableFrom(type)) {
            return new EnumValueConfigEntry<C, T>(this, valueNode);
        }
        if (type.equals(Integer.class)) {
            return new IntegerValueConfigEntry<C>(this, valueNode);
        }
        if (Key.class.isAssignableFrom(type)) {
            return new KeyValueConfigEntry<C>(this, valueNode);
        }
        throw new UnsupportedOperationException("Unsupported type: " + String.valueOf(type));
    }

    private List<ConfigEntry> createSubCategoryEntries(CategoryConfigNode<C> categoryNode) {
        ArrayList<ConfigEntry> entries = new ArrayList<ConfigEntry>(categoryNode.getChildren().size() + 1);
        entries.add(new CategoryTitleConfigEntry(this, categoryNode.getTitle()));
        for (ConfigNode node : categoryNode.getChildren()) {
            if (!(node instanceof ValueConfigNode)) continue;
            ValueConfigNode valueNode = (ValueConfigNode)node;
            entries.add(this.createValueEntry(valueNode));
        }
        return entries;
    }

    @NotNull
    public Minecraft getMinecraft() {
        return Objects.requireNonNull(this.screen.getMinecraft());
    }

    public ConfigScreen<C> getScreen() {
        return this.screen;
    }

    @Nullable
    public ValueConfigNode<C, Key, Key> getSelectedKeyNode() {
        return this.selectedKeyNode;
    }

    public void setSelectedKeyNode(@Nullable ValueConfigNode<C, Key, Key> selectedKeyNode) {
        this.selectedKeyNode = selectedKeyNode;
    }

    public void refresh() {
        boolean hasError;
        if (this.tabButton == null) {
            return;
        }
        boolean hasChanged = !this.category.isActiveValue(this.config);
        boolean bl = hasError = this.category.validate(this.config) != null;
        Component newTitle = hasError ? (hasChanged ? this.titleErrorChanged : this.titleError) : (hasChanged ? this.titleChanged : this.title);
        this.tabButton.setMessage(newTitle);
        this.list.refreshEntries();
    }

    public C getConfig() {
        return this.config;
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.selectedKeyNode != null) {
            if (event.isEscape()) {
                this.selectedKeyNode.setEditingValue(Key.UNKNOWN_KEY);
            } else {
                this.selectedKeyNode.setEditingValue(new Key(InputConstants.getKey((KeyEvent)event)));
            }
            this.selectedKeyNode = null;
            this.screen.refresh();
            return true;
        }
        return false;
    }

    public void setTabButton(@Nullable TabButton tabButton) {
        this.tabButton = tabButton;
    }
}

