/*
 * Decompiled with CFR 0.152.
 */
package org.duckiee2.Abilities.Primaries;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.duckiee2.Infuse;
import org.duckiee2.Managers.Cooldowns;
import org.duckiee2.Managers.InfuseManager;
import org.duckiee2.Trust.TrustManager;

public class Ender
implements Listener {
    private final Infuse plugin;
    private final InfuseManager infuse;
    private final TrustManager trustManager;

    public Ender(Infuse plugin, InfuseManager infuse, TrustManager trustManager) {
        this.plugin = plugin;
        this.infuse = infuse;
        this.trustManager = trustManager;
        this.startPassiveTask();
        this.resetSparks();
    }

    private void resetSparks() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            String currentInfuse = this.infuse.getInfuse(player.getUniqueId());
            if (currentInfuse == null || !currentInfuse.equals("enderspark")) continue;
            this.infuse.setInfuse(player.getUniqueId(), "ender");
        }
    }

    private void startPassiveTask() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    Ender.this.EnderPassives(player);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public void EnderPassives(Player player) {
        if (this.hasEnderEquipped(player) || this.hasEnderSparkEquipped(player)) {
            Entity closest = null;
            double closestDist = 64.0;
            for (Entity entity : player.getWorld().getEntities()) {
                double dist;
                if (entity.getType() != EntityType.END_CRYSTAL || !((dist = entity.getLocation().distance(player.getLocation())) <= 64.0) || !(dist < closestDist)) continue;
                closest = entity;
                closestDist = dist;
            }
            for (Entity entity : player.getWorld().getEntities()) {
                if (entity.getType() != EntityType.END_CRYSTAL || entity == closest) continue;
                ((EnderCrystal)entity).setBeamTarget(null);
            }
            if (closest != null) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.SATURATION, 40, 0, false, false));
                ((EnderCrystal)closest).setBeamTarget(player.getLocation().subtract(0.0, 1.5, 0.0));
            }
            for (Player target : player.getWorld().getPlayers()) {
                if (!(target.getLocation().distance(player.getLocation()) <= 64.0) || this.hasEnderEquipped(target) || this.hasEnderSparkEquipped(target) || this.isTeammate(target, player)) continue;
                target.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, 40, 0, false, false));
            }
        }
    }

    @EventHandler
    public void onDragonBreathUse(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item != null && item.getType() == Material.DRAGON_BREATH && (this.hasEnderEquipped(player) || this.hasEnderSparkEquipped(player)) && player.getCooldown(Material.DRAGON_BREATH) == 0) {
            player.setCooldown(Material.DRAGON_BREATH, 10);
            item.setAmount(item.getAmount() - 1);
            this.spawnEyeDragonBreath(player);
            player.playSound(player.getLocation(), Sound.ENTITY_SNIFFER_EAT, 5.0f, 1.0f);
        }
    }

    private void spawnEyeDragonBreath(final Player player) {
        final Location eyeLoc = player.getEyeLocation().subtract(0.0, 0.5, 0.0);
        final Vector dir = player.getLocation().getDirection().normalize();
        final World world = player.getWorld();
        new BukkitRunnable(){
            int ticks = 0;

            public void run() {
                if (this.ticks >= 20) {
                    this.cancel();
                    return;
                }
                double distance = (double)this.ticks * 0.2;
                Location particleLoc = eyeLoc.clone().add(dir.clone().multiply(distance));
                double spread = 5.0 * ((double)this.ticks / 20.0);
                int particles = 40 + this.ticks;
                for (int i = 0; i < particles; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)particles;
                    double xOffset = Math.cos(angle) * spread * (0.5 + Math.random() * 0.5);
                    double zOffset = Math.sin(angle) * spread * (0.5 + Math.random() * 0.5);
                    world.spawnParticle(Particle.DRAGON_BREATH, particleLoc.clone().add(xOffset, 0.0, zOffset), 1, 0.02, 0.02, 0.02, 0.001);
                }
                for (Entity e : world.getNearbyEntities(particleLoc, spread, spread, spread)) {
                    Player targetPlayer;
                    if (!(e instanceof LivingEntity)) continue;
                    LivingEntity target = (LivingEntity)e;
                    if (e == player || this.ticks % 10 != 0 || target instanceof Player && Ender.this.isTeammate(targetPlayer = (Player)target, player)) continue;
                    target.setMetadata("enderDrink", (MetadataValue)new FixedMetadataValue((Plugin)Ender.this.plugin, (Object)true));
                    target.damage(1.5, (Entity)player);
                    target.removeMetadata("enderDrink", (Plugin)Ender.this.plugin);
                    world.spawnParticle(Particle.DRAGON_BREATH, target.getEyeLocation(), 8, 0.2, 0.2, 0.2, 0.0);
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    @EventHandler
    public void onPearlThrow(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item != null && item.getType() == Material.ENDER_PEARL && (this.hasEnderEquipped(player) || this.hasEnderSparkEquipped(player))) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, 200, 0));
        }
    }

    @EventHandler
    public void onOffhandAbility(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (player.isSneaking() && this.hasEnderEquipped(player) && !Cooldowns.isOnCooldown(player.getUniqueId(), "ender", 1)) {
            event.setCancelled(true);
            this.activateEnder(player);
        }
    }

    private boolean hasEnderEquipped(Player player) {
        String effectname = "ender";
        String currenteffect = this.infuse.getInfuse(player.getUniqueId());
        return currenteffect != null && currenteffect.equals(effectname);
    }

    private boolean hasEnderSparkEquipped(Player player) {
        String effectname = "enderspark";
        String currenteffect = this.infuse.getInfuse(player.getUniqueId());
        return currenteffect != null && currenteffect.equals(effectname);
    }

    private boolean isTeammate(Player player, Player caster) {
        return this.trustManager.isTrusted(player, caster);
    }

    public void activateEnder(final Player player) {
        if (Cooldowns.isOnCooldown(player.getUniqueId(), "ender", 1)) {
            return;
        }
        this.infuse.setInfuse(player.getUniqueId(), "enderspark");
        Cooldowns.setDuration(player.getUniqueId(), "enderspark", 15L, 1);
        Cooldowns.setCooldown(player.getUniqueId(), "ender", 135L, 1);
        player.playSound((Entity)player, Sound.BLOCK_BEACON_POWER_SELECT, 5.0f, 1.0f);
        Vector direction = player.getLocation().getDirection().normalize();
        Vector velocity = direction.multiply(3);
        velocity.setY(0.5);
        player.setVelocity(velocity);
        new BukkitRunnable(){
            int ticks = 0;

            public void run() {
                if (!player.isOnline() || this.ticks++ > 10) {
                    this.cancel();
                    return;
                }
                player.getWorld().spawnParticle(Particle.PORTAL, player.getLocation(), 25, 0.3, 0.3, 0.3, 0.1);
                for (Entity e : player.getNearbyEntities(2.0, 2.0, 2.0)) {
                    Player targetPlayer;
                    if (!(e instanceof LivingEntity)) continue;
                    LivingEntity target = (LivingEntity)e;
                    if (e == player || target instanceof Player && Ender.this.isTeammate(targetPlayer = (Player)target, player)) continue;
                    target.setVelocity(new Vector(0, 5, 0));
                    target.setMetadata("enderSpark", (MetadataValue)new FixedMetadataValue((Plugin)Ender.this.plugin, (Object)true));
                    target.damage(10.0, (Entity)player);
                    target.removeMetadata("enderSpark", (Plugin)Ender.this.plugin);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.hasEnderSparkEquipped(player)) {
                this.infuse.setInfuse(player.getUniqueId(), "ender");
            }
        }, 300L);
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getEntityType() == EntityType.ARMOR_STAND) {
            return;
        }
        if (event.getEntity().hasMetadata("enderSpark")) {
            event.setDamage(EntityDamageEvent.DamageModifier.ARMOR, 0.0);
        }
        if (event.getEntity().hasMetadata("enderDrink")) {
            event.setDamage(EntityDamageEvent.DamageModifier.ARMOR, 0.0);
        }
    }

    public static ItemStack createEnder() {
        ItemStack effect = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)effect.getItemMeta();
        if (meta != null) {
            String effectName = "\u00a75Ender Effect";
            effectName = Ender.applyHexColors(effectName);
            meta.setDisplayName(effectName);
            List<String> lore = List.of("\u00a79\u1d18\u0280\u026a\u1d0d\u1d00\u0280\u028f \u1d07\u0493\u0493\u1d07\u1d04\u1d1b:", "", "\u00a75\u2b50\u00a77 Give players in a 64 block radius \u00a7eGlow", "\u00a75\u2b50\u00a77 Grants \u00a7oResistance \u00a7o1 \u00a7r\u00a77after \u00a75Pearling", "\u00a75\u2b50\u00a77 Can drink \u00a7eDragon's Breath", "", "\u00a79s\u1d18\u1d00\u0280\u1d0b \u1d00\u0299\u026a\u029f\u026a\u1d1b\u028f:", "", "\u00a75\u2b50\u00a77 Evoke \u00a75Dragon's Aura", "\u00a75\u2b50\u00a77 damaging nearby players", "", "\u00a78Duration: \u00a7315s \u00a78Cooldown: \u00a73120s");
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            meta.setColor(Color.fromRGB((int)135, (int)18, (int)119));
            meta.setLore(lore);
            meta.setCustomModelData(Integer.valueOf(6));
            effect.setItemMeta((ItemMeta)meta);
        }
        return effect;
    }

    private static String applyHexColors(String text) {
        Pattern pattern = Pattern.compile("\u00a7#([A-Fa-f0-9]{6})");
        Matcher matcher = pattern.matcher(text);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hex = matcher.group(1);
            matcher.appendReplacement(buffer, ChatColor.of((String)("#" + hex)).toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

