/*
 * Decompiled with CFR 0.152.
 */
package org.duckiee2.Abilities.Primaries;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.duckiee2.Infuse;
import org.duckiee2.Managers.Cooldowns;
import org.duckiee2.Managers.InfuseManager;

public class Feather
implements Listener {
    private final Infuse plugin;
    private final InfuseManager infuse;

    public Feather(Infuse plugin, InfuseManager infuse) {
        this.plugin = plugin;
        this.infuse = infuse;
        this.resetSparks();
    }

    private void resetSparks() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            String currentInfuse = this.infuse.getInfuse(player.getUniqueId());
            if (currentInfuse == null || !currentInfuse.equals("featherspark")) continue;
            this.infuse.setInfuse(player.getUniqueId(), "feather");
        }
    }

    @EventHandler
    public void onOffhandAbility(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (player.isSneaking() && this.hasFeatherEquipped(player) && !Cooldowns.isOnCooldown(player.getUniqueId(), "feather", 1)) {
            event.setCancelled(true);
            this.activateFeather(player);
        }
    }

    private boolean hasFeatherEquipped(Player player) {
        String effectname = "feather";
        String currenteffect = this.infuse.getInfuse(player.getUniqueId());
        return currenteffect != null && currenteffect.equals(effectname);
    }

    private boolean hasFeatherSparkEquipped(Player player) {
        String effectname = "featherspark";
        String currenteffect = this.infuse.getInfuse(player.getUniqueId());
        return currenteffect != null && currenteffect.equals(effectname);
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if ((this.hasFeatherEquipped(player) || this.hasFeatherSparkEquipped(player)) && event.getCause() == EntityDamageEvent.DamageCause.FALL) {
            event.setCancelled(true);
        }
    }

    public void activateFeather(Player player) {
        if (!Cooldowns.isOnCooldown(player.getUniqueId(), "feather", 1)) {
            this.infuse.setInfuse(player.getUniqueId(), "featherspark");
            Cooldowns.setDuration(player.getUniqueId(), "featherspark", 6L, 1);
            Cooldowns.setCooldown(player.getUniqueId(), "feather", 48L, 1);
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 5.0f, 1.0f);
            player.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, 20, 60, false, false));
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (this.hasFeatherSparkEquipped(player)) {
                    this.infuse.setInfuse(player.getUniqueId(), "feather");
                }
            }, 120L);
        }
    }

    public static ItemStack createFeather() {
        ItemStack effect = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)effect.getItemMeta();
        if (meta != null) {
            String effectName = "\u00a7#BEA3CAFeather Effect";
            effectName = Feather.applyHexColors(effectName);
            meta.setDisplayName(effectName);
            List<String> lore = List.of("\u00a79\u1d18\u0280\u026a\u1d0d\u1d00\u0280\u028f \u1d07\u0493\u0493\u1d07\u1d04\u1d1b:", "", "\u00a7f\u2602\u00a77 No fall damage", "", "\u00a79s\u1d18\u1d00\u0280\u1d0b \u1d00\u0299\u026a\u029f\u026a\u1d1b\u028f:", "", "\u00a7f\u2602\u00a77 Burst of Levitation XXX", "", "\u00a78Duration: \u00a736s \u00a78Cooldown: \u00a7345s");
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            meta.setColor(Color.fromRGB((int)255, (int)255, (int)255));
            meta.setLore(lore);
            meta.setCustomModelData(Integer.valueOf(2));
            effect.setItemMeta((ItemMeta)meta);
        }
        return effect;
    }

    private static String applyHexColors(String text) {
        Pattern pattern = Pattern.compile("\u00a7#([A-Fa-f0-9]{6})");
        Matcher matcher = pattern.matcher(text);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hex = matcher.group(1);
            matcher.appendReplacement(buffer, ChatColor.of((String)("#" + hex)).toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

