/*
 * Decompiled with CFR 0.152.
 */
package org.duckiee2.Abilities.Primaries;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.duckiee2.Infuse;
import org.duckiee2.Managers.Cooldowns;
import org.duckiee2.Managers.InfuseManager;
import org.duckiee2.Trust.TrustManager;

public class Invis
implements Listener {
    private final Infuse plugin;
    private final InfuseManager infuse;
    private final TrustManager trustManager;
    private final Map<UUID, ItemStack[]> hiddenArmor = new HashMap<UUID, ItemStack[]>();

    public Invis(Infuse plugin, InfuseManager infuse, TrustManager trustManager) {
        this.plugin = plugin;
        this.infuse = infuse;
        this.trustManager = trustManager;
        this.startPassiveTask();
        this.resetSparks();
    }

    private void resetSparks() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            String currentInfuse = this.infuse.getInfuse(player.getUniqueId());
            if (currentInfuse == null || !currentInfuse.equals("invisspark")) continue;
            this.infuse.setInfuse(player.getUniqueId(), "invis");
        }
    }

    private void startPassiveTask() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    Invis.this.InvisPassives(player, null);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public void InvisPassives(Player player, Object event) {
        if (this.hasInvisEquipped(player) || this.hasInvisSparkEquipped(player)) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 40, 0, false, false));
        }
    }

    @EventHandler
    public void onPearlThrow(PlayerInteractEvent event) {
        ItemStack item;
        Player player = event.getPlayer();
        if (this.hasInvisSparkEquipped(player) && (event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) && (item = event.getItem()) != null && item.getType() == Material.ENDER_PEARL) {
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (!(player.getLocation().distance(onlinePlayer.getLocation()) <= 16.0)) continue;
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler
    public void onOffhandAbility(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (player.isSneaking() && this.hasInvisEquipped(player) && !Cooldowns.isOnCooldown(player.getUniqueId(), "invis", 1)) {
            event.setCancelled(true);
            this.activateInvis(player);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player joined = event.getPlayer();
        for (Map.Entry<UUID, ItemStack[]> entry : this.hiddenArmor.entrySet()) {
            Player invisPlayer = Bukkit.getPlayer((UUID)entry.getKey());
            if (invisPlayer == null || !invisPlayer.isOnline()) continue;
            ItemStack[] emptyArmor = new ItemStack[4];
            joined.sendEquipmentChange((LivingEntity)invisPlayer, EquipmentSlot.HEAD, emptyArmor[3]);
            joined.sendEquipmentChange((LivingEntity)invisPlayer, EquipmentSlot.CHEST, emptyArmor[2]);
            joined.sendEquipmentChange((LivingEntity)invisPlayer, EquipmentSlot.LEGS, emptyArmor[1]);
            joined.sendEquipmentChange((LivingEntity)invisPlayer, EquipmentSlot.FEET, emptyArmor[0]);
        }
    }

    private boolean hasInvisEquipped(Player player) {
        String effectname = "invis";
        String currenteffect = this.infuse.getInfuse(player.getUniqueId());
        return currenteffect != null && currenteffect.equals(effectname);
    }

    private boolean hasInvisSparkEquipped(Player player) {
        String effectname = "invisspark";
        String currenteffect = this.infuse.getInfuse(player.getUniqueId());
        return currenteffect != null && currenteffect.equals(effectname);
    }

    private boolean isTeammate(Player player, Player caster) {
        return this.trustManager.isTrusted(player, caster);
    }

    private void hideArmor(Player player) {
        ItemStack[] armor = player.getInventory().getArmorContents();
        this.hiddenArmor.put(player.getUniqueId(), armor);
        ItemStack[] emptyArmor = new ItemStack[4];
        for (Player other : Bukkit.getOnlinePlayers()) {
            if (other.equals((Object)player)) continue;
            other.sendEquipmentChange((LivingEntity)player, EquipmentSlot.HEAD, emptyArmor[3]);
            other.sendEquipmentChange((LivingEntity)player, EquipmentSlot.CHEST, emptyArmor[2]);
            other.sendEquipmentChange((LivingEntity)player, EquipmentSlot.LEGS, emptyArmor[1]);
            other.sendEquipmentChange((LivingEntity)player, EquipmentSlot.FEET, emptyArmor[0]);
        }
    }

    private void showArmor(Player player) {
        ItemStack[] armor = this.hiddenArmor.remove(player.getUniqueId());
        if (armor != null) {
            for (Player other : Bukkit.getOnlinePlayers()) {
                if (other.equals((Object)player)) continue;
                other.sendEquipmentChange((LivingEntity)player, EquipmentSlot.HEAD, armor[3]);
                other.sendEquipmentChange((LivingEntity)player, EquipmentSlot.CHEST, armor[2]);
                other.sendEquipmentChange((LivingEntity)player, EquipmentSlot.LEGS, armor[1]);
                other.sendEquipmentChange((LivingEntity)player, EquipmentSlot.FEET, armor[0]);
            }
        }
    }

    public void activateInvis(Player player) {
        if (!Cooldowns.isOnCooldown(player.getUniqueId(), "invis", 1)) {
            this.infuse.setInfuse(player.getUniqueId(), "invisspark");
            Cooldowns.setDuration(player.getUniqueId(), "invisspark", 30L, 1);
            Cooldowns.setCooldown(player.getUniqueId(), "invis", 95L, 1);
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 5.0f, 1.0f);
            this.hideArmor(player);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (this.hasInvisSparkEquipped(player)) {
                    this.infuse.setInfuse(player.getUniqueId(), "invis");
                }
                this.showArmor(player);
            }, 600L);
            BukkitTask repeatTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
                if (!this.hasInvisSparkEquipped(player) || !player.isOnline()) {
                    return;
                }
                Location center = player.getLocation();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (p.equals((Object)player) || !p.getWorld().equals((Object)center.getWorld()) || !(p.getLocation().distance(center) <= 16.0) || this.isTeammate(p, player)) continue;
                    p.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 0, false, false));
                    p.addPotionEffect(new PotionEffect(PotionEffectType.DARKNESS, 40, 0, false, false));
                }
            }, 0L, 20L);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> repeatTask.cancel(), 600L);
        }
    }

    public static ItemStack createInvis() {
        ItemStack effect = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)effect.getItemMeta();
        if (meta != null) {
            String effectName = "\u00a75Invis Effect";
            effectName = Invis.applyHexColors(effectName);
            meta.setDisplayName(effectName);
            List<String> lore = List.of("\u00a79\u1d18\u0280\u026a\u1d0d\u1d00\u0280\u028f \u1d07\u0493\u0493\u1d07\u1d04\u1d1b:", "", "\u00a75\ud83d\udc41\u00a77 Grants Invisibility", "", "\u00a79s\u1d18\u1d00\u0280\u1d0b \u1d00\u0299\u026a\u029f\u026a\u1d1b\u028f:", "", "\u00a75\ud83d\udc41\u00a77 Blinds players in a 16 block radius", "\u00a75\ud83d\udc41\u00a77 Disables pearling in a 16 block radius", "", "\u00a78Duration: \u00a7330s \u00a78Cooldown: \u00a7345s");
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            meta.setColor(Color.fromRGB((int)204, (int)51, (int)255));
            meta.setLore(lore);
            meta.setCustomModelData(Integer.valueOf(4));
            effect.setItemMeta((ItemMeta)meta);
        }
        return effect;
    }

    private static String applyHexColors(String text) {
        Pattern pattern = Pattern.compile("\u00a7#([A-Fa-f0-9]{6})");
        Matcher matcher = pattern.matcher(text);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hex = matcher.group(1);
            matcher.appendReplacement(buffer, ChatColor.of((String)("#" + hex)).toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

