/*
 * Decompiled with CFR 0.152.
 */
package org.duckiee2.Abilities.Primaries;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.duckiee2.Infuse;
import org.duckiee2.Managers.Cooldowns;
import org.duckiee2.Managers.InfuseManager;
import org.duckiee2.Trust.TrustManager;

public class Thunder
implements Listener {
    private final Infuse plugin;
    private final InfuseManager infuse;
    private final TrustManager trustManager;
    private HashMap<UUID, Integer> hits = new HashMap();

    public Thunder(Infuse plugin, InfuseManager infuse, TrustManager trustManager) {
        this.plugin = plugin;
        this.infuse = infuse;
        this.trustManager = trustManager;
        this.resetSparks();
    }

    private void resetSparks() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            String currentInfuse = this.infuse.getInfuse(player.getUniqueId());
            if (currentInfuse == null || !currentInfuse.equals("thunderspark")) continue;
            this.infuse.setInfuse(player.getUniqueId(), "thunder");
        }
    }

    @EventHandler
    public void onPlayerDamageEntity(EntityDamageByEntityEvent event) {
        Player player;
        if (event.getDamager() instanceof Player && this.hasThunderEquipped(player = (Player)event.getDamager()) && event.getEntity() instanceof LivingEntity && !event.getEntity().equals((Object)player)) {
            Player targetPlayer;
            LivingEntity target = (LivingEntity)event.getEntity();
            if (target instanceof Player && this.isTeammate(targetPlayer = (Player)target, player)) {
                return;
            }
            UUID id = player.getUniqueId();
            int count = this.hits.getOrDefault(id, 0) + 1;
            this.hits.put(id, count);
            if (count >= 10) {
                target.getWorld().strikeLightning(target.getLocation());
                target.getWorld().spawnParticle(Particle.DUST, target.getLocation().add(0.0, 1.0, 0.0), 10, 0.5, 0.5, 0.5, 0.0, (Object)new Particle.DustOptions(Color.YELLOW, 1.5f));
                target.damage(4.0);
                this.hits.put(id, 0);
            }
        }
    }

    @EventHandler
    public void onOffhandAbility(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (player.isSneaking() && this.hasThunderEquipped(player) && !Cooldowns.isOnCooldown(player.getUniqueId(), "thunder", 1)) {
            event.setCancelled(true);
            this.activateThunder(player);
        }
    }

    private boolean hasThunderEquipped(Player player) {
        String effectname = "thunder";
        String currenteffect = this.infuse.getInfuse(player.getUniqueId());
        return currenteffect != null && currenteffect.equals(effectname);
    }

    private boolean hasThunderSparkEquipped(Player player) {
        String effectname = "thunderspark";
        String currenteffect = this.infuse.getInfuse(player.getUniqueId());
        return currenteffect != null && currenteffect.equals(effectname);
    }

    public void activateThunder(final Player player) {
        UUID playerUUID = player.getUniqueId();
        if (!Cooldowns.isOnCooldown(playerUUID, "thunder", 1)) {
            this.infuse.setInfuse(player.getUniqueId(), "thunderspark");
            Cooldowns.setDuration(player.getUniqueId(), "thunderspark", 10L, 1);
            Cooldowns.setCooldown(player.getUniqueId(), "thunder", 130L, 1);
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 5.0f, 1.0f);
            new BukkitRunnable(){
                int ticksElapsed = 0;

                public void run() {
                    if (this.ticksElapsed >= 200) {
                        this.cancel();
                    } else {
                        for (Entity entity : player.getNearbyEntities(16.0, 16.0, 16.0)) {
                            Player targetPlayer;
                            if (!(entity instanceof LivingEntity) || entity.equals((Object)player) || entity instanceof Player && Thunder.this.isTeammate(targetPlayer = (Player)entity, player)) continue;
                            LivingEntity target = (LivingEntity)entity;
                            target.getWorld().strikeLightning(target.getLocation());
                            target.getWorld().spawnParticle(Particle.DUST, target.getLocation().add(0.0, 1.0, 0.0), 10, 0.5, 0.5, 0.5, 0.0, (Object)new Particle.DustOptions(Color.YELLOW, 1.5f));
                            int damage = 2;
                            target.damage((double)damage);
                            double multiplier = 1.5;
                            target.damage(target.getLastDamage() * multiplier);
                        }
                        this.ticksElapsed += 60;
                    }
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 60L);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (this.hasThunderSparkEquipped(player)) {
                    this.infuse.setInfuse(player.getUniqueId(), "thunder");
                }
            }, 200L);
        }
    }

    private boolean isTeammate(Player player, Player caster) {
        return this.trustManager.isTrusted(player, caster);
    }

    public static ItemStack createThunder() {
        ItemStack effect = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)effect.getItemMeta();
        if (meta != null) {
            String effectName = "\u00a7eThunder Effect";
            effectName = Thunder.applyHexColors(effectName);
            meta.setDisplayName(effectName);
            List<String> lore = List.of("\u00a79\u1d18\u0280\u026a\u1d0d\u1d00\u0280\u028f \u1d07\u0493\u0493\u1d07\u1d04\u1d1b:", "", "\u00a7e\u26a1\u00a77 Strikes attacked players with \u00a76Lightning", "", "\u00a79s\u1d18\u1d00\u0280\u1d0b \u1d00\u0299\u026a\u029f\u026a\u1d1b\u028f:", "", "\u00a7e\u26a1\u00a77 Smite enemies within a 16 block radius", "", "\u00a78Duration: \u00a7310s \u00a78Cooldown: \u00a73120s");
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            meta.setColor(Color.fromRGB((int)255, (int)255, (int)0));
            meta.setLore(lore);
            meta.setCustomModelData(Integer.valueOf(9));
            effect.setItemMeta((ItemMeta)meta);
        }
        return effect;
    }

    private static String applyHexColors(String text) {
        Pattern pattern = Pattern.compile("\u00a7#([A-Fa-f0-9]{6})");
        Matcher matcher = pattern.matcher(text);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hex = matcher.group(1);
            matcher.appendReplacement(buffer, ChatColor.of((String)("#" + hex)).toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

